/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.constant;

public final class Sql {

    public static final class AdminSql {
        public static final String create = "insert into ADMIN ( ADMIN_ID,ADMIN_ACCOUNT,ADMIN_PASSWORD,ADMIN_TYPE,ADMIN_NAME,ADMIN_CDATE ) values ( ?,?,?,?,?,? )";
        public static final String remove = "delete from ADMIN where ADMIN_ID=?";
        public static final String fetch = "select * from ADMIN where ADMIN_ID=?";
        public static final String export = "select * from ADMIN order by ADMIN_ID desc limit ?,?";
        public static final String fetchByAccount = "select * from ADMIN where ADMIN_ACCOUNT=?";
        public static final String fetchList = "select * from ADMIN where ADMIN_TYPE=? order by ADMIN_ID desc";
    }

    public static final class AgencyBillSql {
        public static final String create = "insert into AGENCY_BILL ( BILL_ID,ADMIN_ID ) values ( ?,? )";
        public static final String remove = "delete from AGENCY_BILL where BILL_ID=?";
        public static final String fetch = "select * from AGENCY_BILL where BILL_ID=?";
        public static final String export = "select * from AGENCY_BILL order by BILL_ID desc limit ?,?";
    }

    public static final class AnswerDayCodeSql {
        public static final String create = "insert into ANSWER_DAY_CODE ( DAY_ID,ANSWER_ID,CODE_DATE,CODE_NUM,NIGHT_CODE_NUM,WRONG_CODE_NUM ) values ( ?,?,?,?,?,? )";
        public static final String remove = "delete from ANSWER_DAY_CODE where DAY_ID=?";
        public static final String fetch = "select * from ANSWER_DAY_CODE where DAY_ID=?";
        public static final String export = "select * from ANSWER_DAY_CODE order by DAY_ID desc limit ?,?";
        public static final String fetchListByCodeDate = "select ANSWER_ID from ANSWER_DAY_CODE where CODE_DATE=?";
        public static final String updateCodeNum = "update ANSWER_DAY_CODE set CODE_NUM=CODE_NUM + ?,WRONG_CODE_NUM=WRONG_CODE_NUM + ?,NIGHT_CODE_NUM=NIGHT_CODE_NUM + ? where ANSWER_ID=? and CODE_DATE=?";
        public static final String fetchListByAnswerId = "select * from ANSWER_DAY_CODE where ANSWER_ID=? and CODE_DATE >=? and CODE_DATE <=? order by DAY_ID asc";
    }

    public static final class AnswerSql {
        public static final String create = "insert into ANSWER ( ANSWER_ID,ADMIN_ID,ANSWER_ACCOUNT,ANSWER_PASSWORD,ANSWER_TYPE,ANSWER_CDATE,ANSWER_ORDER,ANSWER_QQ,ANSWER_ZHIFUBAO ) values ( ?,?,?,?,?,?,?,?,? )";
        public static final String remove = "delete from ANSWER where ANSWER_ID=?";
        public static final String fetch = "select * from ANSWER where ANSWER_ID=?";
        public static final String export = "select * from ANSWER order by ANSWER_ID desc limit ?,?";
        public static final String fetchByAccount = "select * from ANSWER where ANSWER_ACCOUNT=?";
        public static final String fetchList = "select B1.*,B2.CODE_NUM,B2.WRONG_CODE_NUM,B2.NIGHT_CODE_NUM from ANSWER B1 left join ( select T1.ANSWER_ID,sum(T2.CODE_NUM) CODE_NUM,sum(T2.WRONG_CODE_NUM) WRONG_CODE_NUM,sum(T2.NIGHT_CODE_NUM) NIGHT_CODE_NUM from ANSWER T1 inner join ANSWER_DAY_CODE T2 on T1.ANSWER_ID=T2.ANSWER_ID where T1.ADMIN_ID=? and T2.CODE_DATE >=? and T2.CODE_DATE <=? group by T1.ANSWER_ID) B2 on B1.ANSWER_ID=B2.ANSWER_ID where B1.ADMIN_ID=? order by B1.ANSWER_ORDER asc,B1.ANSWER_ID desc";
    }

    public static final class DayCodeSql {
        public static final String create = "insert into DAY_CODE ( CODE_ID,MASTER_ID,ANSWER_ID,CODE_TYPE,CODE_STATUS,CODE_PRIORITY,CODE_TEXT,CREATE_DATE,OUT_DATE,TAKE_DATE,ANSWER_DATE,CODE_MUM,PLAY_TIMES ) values ( ?,?,?,?,?,?,?,?,?,?,?,?,? )";
        public static final String remove = "delete from DAY_CODE where CODE_ID=?";
        public static final String fetch = "select * from DAY_CODE where CODE_ID=?";
        public static final String export = "select * from DAY_CODE order by CODE_ID desc limit ?,?";
        public static final String checkTable = "select max(CODE_ID) from DAY_CODE where 1=0";
        public static final String createTable = "create table DAY_CODE ( CODE_ID int not null auto_increment,MASTER_ID int not null,ANSWER_ID int,CODE_TYPE int not null,CODE_STATUS int not null default 0,CODE_PRIORITY int not null default 1,CODE_TEXT varchar(30),CREATE_DATE datetime not null,OUT_DATE datetime not null,TAKE_DATE datetime,ANSWER_DATE datetime,CODE_MUM varchar(30),PLAY_TIMES int,primary key (CODE_ID) ) ENGINE=MyISAM";
        public static final String fetchList = "select * from DAY_CODE where CODE_STATUS=? and OUT_DATE < ? order by CODE_ID desc limit ?";
        public static final String updateCodeText = "update DAY_CODE set ANSWER_ID=?,CODE_TEXT=?,TAKE_DATE=?,ANSWER_DATE=?,CODE_STATUS=? where CODE_ID=?";
        public static final String updateAnswerDate = "update DAY_CODE set CODE_TEXT=?,ANSWER_DATE=?,CODE_STATUS=? where CODE_ID=?";
        public static final String updateAnswerId = "update DAY_CODE set ANSWER_ID=?,TAKE_DATE=?,CODE_STATUS=? where CODE_ID=?";
        public static final String updateCodeStatus = "update DAY_CODE set CODE_STATUS=? where CODE_ID=?";
        public static final String fetchListByMasterId = "select * from DAY_CODE where MASTER_ID=? and CODE_STATUS=? order by CODE_ID desc limit 0,?";
        public static final String fetchListByAnswerId = "select * from DAY_CODE where ANSWER_ID=? order by CODE_ID desc limit 0,?";
        public static final String fetchLisForSuperAdmin = "select T1.*,T2.MASTER_ID,T2.MASTER_ACCOUNT,T2.MASTER_NAME,T3.ANSWER_ID,T3.ANSWER_ACCOUNT from DAY_CODE T1 inner join MASTER T2 on T1.MASTER_ID=T2.MASTER_ID left join ANSWER T3 on T1.ANSWER_ID=T3.ANSWER_ID order by CODE_ID desc limit 0,?";
        public static final String removeTable = "drop table DAY_CODE";
    }

    public static final class GenericSql {
        public static final String fetchLastInsertId = "select @@IDENTITY";
    }

    public static final class MasterBillSql {
        public static final String create = "insert into MASTER_BILL ( BILL_ID,MASTER_ID,BILL_DATE,BILL_TYPE,BILL_AMOUNT,BILL_CDATE,BILL_INFO ) values ( ?,?,?,?,?,?,? )";
        public static final String remove = "delete from MASTER_BILL where BILL_ID=?";
        public static final String fetch = "select * from MASTER_BILL where BILL_ID=?";
        public static final String export = "select * from MASTER_BILL order by BILL_ID desc limit ?,?";
        public static final String fetchMapByBillDate = "select * from MASTER_BILL where BILL_DATE=? and BILL_TYPE=?";
        public static final String updateBillAmount = "update MASTER_BILL set BILL_AMOUNT=?,BILL_INFO=? where MASTER_ID=? and BILL_DATE=? and BILL_TYPE=?";
        public static final String sumBalance = "select sum(BILL_AMOUNT) BILL_AMOUNT from MASTER_BILL where MASTER_ID=?";
        public static final String fetchListByMasterId = "select * from MASTER_BILL where MASTER_ID=? order by BILL_ID desc limit 0,?";
        public static final String fetchByBillDate = "select * from MASTER_BILL where MASTER_ID=? and BILL_DATE=? and BILL_TYPE=?";
    }

    public static final class MasterDayCodeSql {
        public static final String create = "insert into MASTER_DAY_CODE ( DAY_ID,MASTER_ID,CODE_DATE,CODE_NUM,CODE_PRICE,WRONG_CODE_NUM ) values ( ?,?,?,?,?,? )";
        public static final String remove = "delete from MASTER_DAY_CODE where DAY_ID=?";
        public static final String fetch = "select * from MASTER_DAY_CODE where DAY_ID=?";
        public static final String export = "select * from MASTER_DAY_CODE order by DAY_ID desc limit ?,?";
        public static final String fetchListByCodeDate = "select MASTER_ID from MASTER_DAY_CODE where CODE_DATE=?";
        public static final String updateCodeNum = "update MASTER_DAY_CODE set CODE_NUM=CODE_NUM + ?,WRONG_CODE_NUM=WRONG_CODE_NUM + ?,CODE_PRICE=? where MASTER_ID=? and CODE_DATE=?";
        public static final String fetchListByMasterId = "select * from MASTER_DAY_CODE where MASTER_ID=? and CODE_DATE >=? and CODE_DATE <=? order by DAY_ID asc";
        public static final String fetchList = "select * from MASTER_DAY_CODE where CODE_DATE=?";
    }

    public static final class MasterSql {
        public static final String create = "insert into MASTER ( MASTER_ID,ADMIN_ID,MASTER_ACCOUNT,MASTER_PASSWORD,MASTER_CDATE,MASTER_NAME,MASTER_QQ,MASTER_PHONE,MASTER_TYPE,CODE_PRICE,MASTER_BALANCE ) values ( ?,?,?,?,?,?,?,?,?,?,? )";
        public static final String remove = "delete from MASTER where MASTER_ID=?";
        public static final String fetch = "select * from MASTER where MASTER_ID=?";
        public static final String export = "select * from MASTER order by MASTER_ID desc limit ?,?";
        public static final String fetchById = "select T1.*,T2.CODE_NUM,T2.WRONG_CODE_NUM from MASTER T1 left join MASTER_DAY_CODE T2 on T1.MASTER_ID=T2.MASTER_ID where T1.MASTER_ID=? order by DAY_ID desc limit 0,1";
        public static final String fetchByAccount = "select T1.*,T2.CODE_NUM,T2.WRONG_CODE_NUM from MASTER T1 left join MASTER_DAY_CODE T2 on T1.MASTER_ID=T2.MASTER_ID where T1.MASTER_ACCOUNT=? order by DAY_ID desc limit 0,1";
        public static final String fetchList = "select T1.*,T2.CODE_NUM,T2.WRONG_CODE_NUM from MASTER T1 left join ( select MASTER_ID,sum(CODE_NUM) CODE_NUM,sum(WRONG_CODE_NUM) WRONG_CODE_NUM from MASTER_DAY_CODE where CODE_DATE >=? and CODE_DATE <=? group by MASTER_ID) T2 on T1.MASTER_ID=T2.MASTER_ID order by T2.CODE_NUM desc,T1.MASTER_ID desc";
        public static final String updateBalance = "update MASTER set MASTER_BALANCE=? where MASTER_ID=?";
    }
}

