/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.action;

import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Admin;
import com.coyousoft.yundama.entity.Master;
import com.coyousoft.yundama.entity.MasterBill;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.sun.mvc.support.RequestWrapper;

public class MasterBillAction
extends BaseAction {
    private static Random r = new Random();

    public ActionForward execute(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper, String dispatch) throws Exception {
        if ("create".equals(dispatch)) {
            return this.create(request, response, session, wrapper);
        }
        if ("jsonCreate".equals(dispatch)) {
            return this.jsonCreate(request, response, session, wrapper);
        }
        if ("remove".equals(dispatch)) {
            return this.remove(request, response, session, wrapper);
        }
        if ("update".equals(dispatch)) {
            return this.update(request, response, session, wrapper);
        }
        if ("fetch".equals(dispatch)) {
            return this.fetch(request, response, session, wrapper);
        }
        if ("export".equals(dispatch)) {
            return this.export(request, response, session, wrapper);
        }
        if ("fetchListByMasterId".equals(dispatch)) {
            return this.fetchListByMasterId(request, response, session, wrapper);
        }
        if ("doCharge".equals(dispatch)) {
            return this.doCharge(request, response, session, wrapper);
        }
        return null;
    }

    private ActionForward create(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Logic.masterBillLogic.create(new MasterBill().fill(wrapper));
        return new ActionForward(1, 1);
    }

    private ActionForward jsonCreate(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Object jsonData = Json.toJavaObject((String)wrapper.getString("jsonData"));
        if (jsonData instanceof Map) {
            Logic.masterBillLogic.create(new MasterBill().fillJson((Map)jsonData));
        } else {
            List list = (List)jsonData;
            ArrayList<MasterBill> masterBillList = new ArrayList<MasterBill>(list.size());
            for (Object obj : list) {
                masterBillList.add(new MasterBill().fillJson((Map)obj));
            }
            Logic.masterBillLogic.create(masterBillList);
        }
        return new ActionForward(1, 1);
    }

    private ActionForward remove(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        Integer masterId = wrapper.getInteger("masterId");
        Integer billId = wrapper.getInteger("billId");
        Logic.masterBillLogic.remove(billId);
        Logic.masterLogic.updateBalance(masterId);
        List<MasterBill> masterBillList = Logic.masterBillLogic.fetchListByMasterId(masterId);
        request.setAttribute("masterBillList", masterBillList);
        request.setAttribute("master", (Object)Logic.masterLogic.fetch(masterId));
        request.setAttribute("randomNum", (Object)r.nextInt(100000));
        return new ActionForward("/jsp/masterBill.jsp", 2);
    }

    private ActionForward update(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.masterBillLogic.update(new MasterBill().fill(wrapper));
        return new ActionForward(resp, 1);
    }

    private ActionForward fetch(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        MasterBill masterBill = Logic.masterBillLogic.fetch(wrapper.getInteger("billId"));
        String resp = Json.toJs((String)"billId", (Object)masterBill);
        return new ActionForward(resp, 1);
    }

    private ActionForward export(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        List<MasterBill> masterBillList = Logic.masterBillLogic.export(wrapper.getInteger("offset"), wrapper.getInteger("limit"));
        String resp = Json.toJs((String)"masterBillList", masterBillList);
        return new ActionForward(resp, 1);
    }

    private ActionForward fetchListByMasterId(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Integer masterId = null;
        Admin admin = (Admin)session.getAttribute("admin");
        Master master = (Master)session.getAttribute("master");
        if (admin != null) {
            masterId = wrapper.getInteger("masterId");
        } else if (master != null) {
            masterId = master.getMasterId();
        }
        if (masterId == null) {
            session.invalidate();
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        List<MasterBill> masterBillList = Logic.masterBillLogic.fetchListByMasterId(masterId);
        request.setAttribute("masterBillList", masterBillList);
        request.setAttribute("master", (Object)Logic.masterLogic.fetch(masterId));
        request.setAttribute("randomNum", (Object)r.nextInt(100000));
        return new ActionForward("/jsp/masterBill.jsp", 2);
    }

    private ActionForward doCharge(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Integer cacheNum;
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        int randomNum = wrapper.getInt("randomNum");
        Object obj = session.getAttribute("randomNum");
        if (obj != null && (cacheNum = (Integer)obj) == randomNum) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            session.invalidate();
            return new ActionForward("/adminLogin.jsp", 2);
        }
        Integer masterId = wrapper.getInteger("masterId");
        Double billAmount = wrapper.getDouble("billAmount");
        if (billAmount != null && billAmount > 0.0) {
            Logic.masterBillLogic.doCharge(masterId, billAmount);
            session.setAttribute("randomNum", (Object)randomNum);
        }
        List<MasterBill> masterBillList = Logic.masterBillLogic.fetchListByMasterId(masterId);
        request.setAttribute("master", (Object)Logic.masterLogic.fetch(masterId));
        request.setAttribute("masterBillList", masterBillList);
        request.setAttribute("randomNum", (Object)r.nextInt(100000));
        return new ActionForward("/jsp/masterBill.jsp", 2);
    }
}

