/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.action;

import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Admin;
import com.coyousoft.yundama.entity.Master;
import com.coyousoft.yundama.entity.MasterDayCode;
import com.coyousoft.yundama.support.FormHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.sun.mvc.support.RequestWrapper;
import org.sysolar.util.MD5;

public class MasterAction
extends BaseAction {
    public ActionForward execute(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper, String dispatch) throws Exception {
        if ("create".equals(dispatch)) {
            return this.create(request, response, session, wrapper);
        }
        if ("jsonCreate".equals(dispatch)) {
            return this.jsonCreate(request, response, session, wrapper);
        }
        if ("remove".equals(dispatch)) {
            return this.remove(request, response, session, wrapper);
        }
        if ("update".equals(dispatch)) {
            return this.update(request, response, session, wrapper);
        }
        if ("fetch".equals(dispatch)) {
            return this.fetch(request, response, session, wrapper);
        }
        if ("export".equals(dispatch)) {
            return this.export(request, response, session, wrapper);
        }
        if ("fetchList".equals(dispatch)) {
            return this.fetchList(request, response, session, wrapper);
        }
        if ("login".equals(dispatch)) {
            return this.login(request, response, session, wrapper);
        }
        if ("logout".equals(dispatch)) {
            return this.logout(request, response, session, wrapper);
        }
        return null;
    }

    private ActionForward login(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Master formMaster = new Master().fill(wrapper);
        Master master = Logic.masterLogic.fetchByAccount(formMaster.getMasterAccount(), MD5.encoder((String)formMaster.getMasterPassword()));
        String errMsg = null;
        if (master == null) {
            errMsg = "\u90ae\u7bb1\u6216\u5bc6\u7801\u9519\u8bef";
        }
        if (errMsg != null) {
            request.setAttribute("errMsg", (Object)errMsg);
            request.setAttribute("formMaster", (Object)formMaster);
            return new ActionForward("/masterLogin.jsp", 2);
        }
        session.setAttribute("master", (Object)master);
        request.getRequestDispatcher("/MasterDayCodeAction.do?dispatch=fetchList").forward((ServletRequest)request, (ServletResponse)response);
        return new ActionForward(4);
    }

    private ActionForward logout(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        session.removeAttribute("master");
        return new ActionForward("/index.jsp", 2);
    }

    private ActionForward create(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        List<String[]> list = FormHelper.parseArea(wrapper.getString("masterAccounts"));
        HashMap<String, Master> map = new HashMap<String, Master>(list.size());
        Master master = null;
        String masterErrMsg = null;
        for (String[] arr : list) {
            if (arr.length < 4 || arr.length > 5) {
                masterErrMsg = "\u6dfb\u52a0\u5931\u8d25\uff0c\u8d26\u53f7\u683c\u5f0f\u65e0\u6548\uff01";
                break;
            }
            master = new Master().setMasterAccount(arr[0]).setMasterPassword(arr[1]).setMasterName(arr[2]).setCodePrice(Double.valueOf(arr[3]));
            if (arr.length == 5) {
                master.setMasterType(Integer.valueOf(arr[4]));
            }
            if (!FormHelper.checkAccount(master.getMasterAccount())) {
                masterErrMsg = "\u6dfb\u52a0\u5931\u8d25\uff0c\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff1a" + master.getMasterAccount() + "---" + master.getMasterPassword();
                break;
            }
            if (!FormHelper.checkPassword(master.getMasterPassword())) {
                masterErrMsg = "\u5bc6\u7801\u65e0\u6548\uff0c6-30\u4f4d\u5b57\u6bcd\u6570\u5b57\u7ec4\u5408\uff0c\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\uff1a" + master.getMasterAccount() + "---" + master.getMasterPassword();
                break;
            }
            master.setMasterPassword(MD5.encoder((String)master.getMasterPassword()));
            map.put(master.getMasterAccount(), master);
        }
        if (masterErrMsg != null) {
            request.setAttribute("masterErrMsg", masterErrMsg);
            return new ActionForward("/jsp/superAdminMain.jsp", 2);
        }
        Logic.masterLogic.create(new ArrayList<Master>(map.values()));
        request.setAttribute("masterMsg", (Object)"\u606d\u559c\u7f8e\u5973&\u5e05\u54e5\uff0c\u6dfb\u52a0\u6210\u529f\u4e86\uff01");
        return new ActionForward("/jsp/superAdminMain.jsp", 2);
    }

    private ActionForward fetchList(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        String lastWeek;
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null || admin.getAdminType() != 100) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        String beginDate = wrapper.getString("beginDate");
        String endDate = wrapper.getString("endDate");
        Calendar c = FormHelper.getCalendar();
        Date edDate = null;
        edDate = endDate == null ? c.getTime() : FormHelper.parseDate(endDate);
        Date bgDate = null;
        bgDate = beginDate == null ? c.getTime() : FormHelper.parseDate(beginDate);
        String currWeek = wrapper.getString("currWeek");
        if (currWeek != null) {
            c = FormHelper.getMonday();
            bgDate = c.getTime();
            edDate = FormHelper.getCalendar().getTime();
        }
        if ((lastWeek = wrapper.getString("lastWeek")) != null) {
            c = FormHelper.getMonday();
            c.add(5, -7);
            bgDate = c.getTime();
            c.add(5, 6);
            edDate = c.getTime();
        }
        List<MasterDayCode> masterDayCodeList = Logic.masterLogic.fetchList(bgDate, edDate);
        request.setAttribute("masterDayCodeList", masterDayCodeList);
        int totalCodeNum = 0;
        int totalWrongCodeNum = 0;
        for (MasterDayCode masterDayCode : masterDayCodeList) {
            if (masterDayCode.getCodeNum() != null) {
                totalCodeNum += masterDayCode.getCodeNum().intValue();
            }
            if (masterDayCode.getWrongCodeNum() == null) continue;
            totalWrongCodeNum += masterDayCode.getWrongCodeNum().intValue();
        }
        request.setAttribute("totalCodeNum", (Object)totalCodeNum);
        request.setAttribute("totalWrongCodeNum", (Object)totalWrongCodeNum);
        request.setAttribute("beginDate", (Object)FormHelper.formatDate(bgDate));
        request.setAttribute("endDate", (Object)FormHelper.formatDate(edDate));
        String showAllMaster = wrapper.getString("showAllMaster");
        if (showAllMaster != null && showAllMaster.equals("1")) {
            request.setAttribute("showAllMaster", (Object)showAllMaster);
        }
        return new ActionForward("/jsp/masterList.jsp", 2);
    }

    private ActionForward jsonCreate(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Object jsonData = Json.toJavaObject((String)wrapper.getString("jsonData"));
        if (jsonData instanceof Map) {
            Logic.masterLogic.create(new Master().fillJson((Map)jsonData));
        } else {
            List list = (List)jsonData;
            ArrayList<Master> masterList = new ArrayList<Master>(list.size());
            for (Object obj : list) {
                masterList.add(new Master().fillJson((Map)obj));
            }
            Logic.masterLogic.create(masterList);
        }
        return new ActionForward(1, 1);
    }

    private ActionForward remove(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.masterLogic.remove(wrapper.getInteger("masterId"));
        return new ActionForward(resp, 1);
    }

    private ActionForward update(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.masterLogic.update(new Master().fill(wrapper));
        return new ActionForward(resp, 1);
    }

    private ActionForward fetch(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Master master = Logic.masterLogic.fetch(wrapper.getInteger("masterId"));
        String resp = Json.toJs((String)"masterId", (Object)master);
        return new ActionForward(resp, 1);
    }

    private ActionForward export(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        List<Master> masterList = Logic.masterLogic.export(wrapper.getInteger("offset"), wrapper.getInteger("limit"));
        String resp = Json.toJs((String)"masterList", masterList);
        return new ActionForward(resp, 1);
    }
}

