/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.action;

import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Admin;
import com.coyousoft.yundama.entity.Answer;
import com.coyousoft.yundama.entity.DayCode;
import com.coyousoft.yundama.entity.Master;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.config.FileConfig;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.sun.mvc.support.RequestWrapper;
import org.sysolar.util.Des;

public class DayCodeAction
extends BaseAction {
    private static final Log log = LogFactory.getLog(DayCodeAction.class);
    private static Random r = new Random();

    public ActionForward execute(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper, String dispatch) throws Exception {
        if ("create".equals(dispatch)) {
            return this.create(request, response, session, wrapper);
        }
        if ("jsonCreate".equals(dispatch)) {
            return this.jsonCreate(request, response, session, wrapper);
        }
        if ("remove".equals(dispatch)) {
            return this.remove(request, response, session, wrapper);
        }
        if ("update".equals(dispatch)) {
            return this.update(request, response, session, wrapper);
        }
        if ("fetch".equals(dispatch)) {
            return this.fetch(request, response, session, wrapper);
        }
        if ("export".equals(dispatch)) {
            return this.export(request, response, session, wrapper);
        }
        if ("saveCodeImage".equals(dispatch)) {
            return this.saveCodeImage(request, response, session, wrapper);
        }
        if ("fetchCode".equals(dispatch)) {
            return this.fetchCode(request, response, session, wrapper);
        }
        if ("submitResult".equals(dispatch)) {
            return this.submitResult(request, response, session, wrapper);
        }
        if ("fetchCodeTextList".equals(dispatch)) {
            return this.fetchCodeTextList(request, response, session, wrapper);
        }
        if ("updateCodeStatus".equals(dispatch)) {
            return this.updateCodeStatus(request, response, session, wrapper);
        }
        if ("fetchLisForSuperAdmin".equals(dispatch)) {
            return this.fetchLisForSuperAdmin(request, response, session, wrapper);
        }
        if ("fetchCacheNum".equals(dispatch)) {
            return this.fetchCacheNum(request, response, session, wrapper);
        }
        return null;
    }

    private ActionForward fetchCacheNum(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        return new ActionForward(new DayCode().setCacheNum(Logic.dayCodeLogic.getCacheListSize()).toString(), 1);
    }

    private ActionForward fetchLisForSuperAdmin(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null || admin.getAdminType() != 100) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        List<DayCode> dayCodeList = Logic.dayCodeLogic.fetchLisForSuperAdmin(Logic.dayCodeLogic.getTableName());
        request.setAttribute("dayCodeList", dayCodeList);
        request.setAttribute("cacheSizeArr", (Object)Logic.dayCodeLogic.getCacheSize());
        return new ActionForward("/jsp/dayCodeList.jsp", 2);
    }

    private ActionForward saveCodeImage(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        if (Logic.dayCodeLogic.isMore()) {
            log.info("IS MORE CODE");
            return new ActionForward(new DayCode().setCodeId(-1 * r.nextInt(99999999)).setTableName(Logic.dayCodeLogic.getTableName()).setCodeStatus(4).toString(), 1);
        }
        Master master = (Master)session.getAttribute("master");
        DayCode dayCode = null;
        try {
            BufferedImage bimg;
            DiskFileItemFactory factory = new DiskFileItemFactory();
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            FileItem codeImage = null;
            List itemList = upload.parseRequest(request);
            for (FileItem item : itemList) {
                if (item.isFormField() && item.getFieldName().equals("jsonData")) {
                    Object obj = Json.toJavaObject((String)item.getString());
                    dayCode = new DayCode().fillJson((Map)obj);
                    continue;
                }
                if (codeImage != null || item.get() == null) continue;
                codeImage = item;
            }
            if (codeImage == null) {
                return new ActionForward("ERROR_WRONG_IMAGE", 1);
            }
            if (master == null) {
                master = Logic.masterLogic.fetchByAccount(dayCode.getMaster().getMasterAccount(), dayCode.getMaster().getMasterPassword());
                if (master == null) {
                    return new ActionForward("ERROR_WRONG_MASTER", 1);
                }
                session.setAttribute("master", (Object)master);
            }
            if (master.getMasterBalance() == null || master.getMasterBalance() < 0.0) {
                return new ActionForward(new DayCode().setCodeId(-1 * r.nextInt(99999999)).setTableName(Logic.dayCodeLogic.getTableName()).setCodeStatus(-1).toString(), 1);
            }
            dayCode.setMasterId(master.getMasterId());
            Calendar c = Calendar.getInstance();
            dayCode.setCreateDate(c.getTime());
            c.add(13, FileConfig.getInteger((String)"timeoutSecond", (Integer)30));
            dayCode.setOutDate(c.getTime());
            dayCode.setTableName(Logic.dayCodeLogic.getTableName());
            dayCode.setByteString(Des.byteArray2string((byte[])codeImage.get()));
            Integer codeLength = FileConfig.getInteger((String)("CODE_TYPE_" + dayCode.getCodeType()));
            if (codeLength != null) {
                dayCode.setCodeLength(codeLength);
            }
            if (dayCode.getCodeType() == 204 && (bimg = ImageIO.read(new ByteArrayInputStream(codeImage.get()))).getWidth() == 220 && bimg.getHeight() == 60) {
                dayCode.setCodeLength(null);
                if (master.getMasterType() != null && master.getMasterType() == 2) {
                    dayCode.setCodeStatus(4);
                    dayCode.setOutDate(dayCode.getCreateDate()).setTakeDate(dayCode.getCreateDate());
                }
            }
            Logic.dayCodeLogic.create(dayCode);
            int codeId = dayCode.getCodeId();
            StringBuilder buffer = new StringBuilder(256);
            buffer.append(AppContext.getAppRootPath()).append("\\codeImage\\").append(dayCode.getTableName()).append("\\").append(codeId / 10000).append("\\");
            File imagePath = new File(buffer.toString());
            if (!imagePath.exists()) {
                imagePath.mkdirs();
            }
            buffer.append(codeId).append(".jpg");
            File imageFile = new File(buffer.toString());
            if (!imageFile.exists()) {
                imageFile.createNewFile();
            }
            codeImage.write(imageFile);
            return new ActionForward(new DayCode().setCodeId(dayCode.getCodeId()).setTableName(dayCode.getTableName()).toString(), 1);
        }
        catch (Exception e) {
            log.error(master, e);
            return new ActionForward(new DayCode().setCodeId(-1 * r.nextInt(99999999)).setTableName(Logic.dayCodeLogic.getTableName()).setCodeStatus(4).toString(), 1);
        }
    }

    private ActionForward fetchCodeTextList(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Master master = (Master)session.getAttribute("master");
        if (master == null) {
            String masterPassword;
            String masterAccount = wrapper.getString("masterAccount");
            master = Logic.masterLogic.fetchByAccount(masterAccount, masterPassword = wrapper.getString("masterPassword"));
            if (master == null) {
                return new ActionForward("ERROR_WRONG_MASTER", 1);
            }
            session.setAttribute("master", (Object)master);
        }
        Integer[] codeIdArr = wrapper.getIntValues("codeId");
        List<DayCode> dayCodeList = Logic.dayCodeLogic.fetchCodeTextList(codeIdArr, master);
        return new ActionForward(Json.encode(dayCodeList), 1);
    }

    private ActionForward updateCodeStatus(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        String jsonData = wrapper.getString("jsonData");
        if (jsonData == null) {
            return new ActionForward("ERROR_REQUEST", 1);
        }
        Object obj = Json.toJavaObject((String)jsonData);
        DayCode dayCode = new DayCode().fillJson((Map)obj);
        if (dayCode.getCodeId() == null) {
            Answer answer = (Answer)session.getAttribute("answer");
            if (answer == null) {
                answer = Logic.answerLogic.fetchByAccount(dayCode.getAnswer().getAnswerAccount(), dayCode.getAnswer().getAnswerPassword());
                if (answer == null) {
                    return new ActionForward("ERROR_WRONG_ANSWER", 1);
                }
                session.setAttribute("answer", (Object)answer);
            }
            dayCode.setMasterId(FileConfig.getInteger((String)"qibingMasterId", (Integer)1));
            dayCode.setAnswerId(answer.getAnswerId());
            Calendar c = Calendar.getInstance();
            dayCode.setCreateDate(c.getTime()).setTakeDate(c.getTime()).setAnswerDate(c.getTime());
            dayCode.setOutDate(c.getTime());
            dayCode.setTableName(Logic.dayCodeLogic.getTableName());
            Logic.dayCodeLogic.onlyCreate(dayCode);
        } else {
            Master master = (Master)session.getAttribute("master");
            if (master == null) {
                master = Logic.masterLogic.fetchByAccount(dayCode.getMaster().getMasterAccount(), dayCode.getMaster().getMasterPassword());
                if (master == null) {
                    return new ActionForward("ERROR_WRONG_MASTER", 1);
                }
                session.setAttribute("master", (Object)master);
            }
            Logic.dayCodeLogic.updateCodeStatus(dayCode, master.getMasterId());
        }
        return new ActionForward(1, 1);
    }

    private ActionForward fetchCode(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Answer answer = (Answer)session.getAttribute("answer");
        if (answer == null) {
            Object obj = Json.toJavaObject((String)wrapper.getString("jsonData"));
            answer = new Answer().fillJson((Map)obj);
            if ((answer = Logic.answerLogic.fetchByAccount(answer.getAnswerAccount(), answer.getAnswerPassword())) == null) {
                return new ActionForward("ERROR_WRONG_ANSWER", 1);
            }
            session.setAttribute("answer", (Object)answer);
        }
        if (!Logic.dayCodeLogic.checkOnline(answer)) {
            return new ActionForward("ERROR_NO_MORE_CODE", 1);
        }
        DayCode dayCode = Logic.dayCodeLogic.fetch(answer);
        if (dayCode == null) {
            return new ActionForward("ERROR_NO_CODE", 1);
        }
        StringBuilder buffer = new StringBuilder(128);
        int codeId = dayCode.getCodeId();
        buffer.append(FileConfig.getString((String)"imgUrlDomain")).append("/codeImage/").append(dayCode.getTableName()).append("/").append(codeId / 10000).append("/").append(codeId).append(".jpg");
        dayCode.setImgUrl(buffer.toString());
        dayCode.setCacheNum(Logic.dayCodeLogic.getCacheListSize());
        return new ActionForward(dayCode.toString(), 1);
    }

    private ActionForward submitResult(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        String jsonData = wrapper.getString("jsonData");
        if (jsonData == null) {
            return new ActionForward("ERROR_REQUEST", 1);
        }
        Object obj = Json.toJavaObject((String)jsonData);
        DayCode dayCode = new DayCode().fillJson((Map)obj);
        Answer answer = (Answer)session.getAttribute("answer");
        if (answer == null) {
            answer = Logic.answerLogic.fetchByAccount(dayCode.getAnswer().getAnswerAccount(), dayCode.getAnswer().getAnswerPassword());
            if (answer == null) {
                return new ActionForward("ERROR_WRONG_ANSWER", 1);
            }
            session.setAttribute("answer", (Object)answer);
        }
        Logic.dayCodeLogic.updateCodeText(dayCode.getCodeId(), dayCode.getCodeText());
        return new ActionForward(1, 1);
    }

    private ActionForward create(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Logic.dayCodeLogic.create(new DayCode().fill(wrapper));
        return new ActionForward(1, 1);
    }

    private ActionForward jsonCreate(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Object jsonData = Json.toJavaObject((String)wrapper.getString("jsonData"));
        if (jsonData instanceof Map) {
            Logic.dayCodeLogic.create(new DayCode().fillJson((Map)jsonData));
        } else {
            List list = (List)jsonData;
            ArrayList<DayCode> dayCodeList = new ArrayList<DayCode>(list.size());
            for (Object obj : list) {
                dayCodeList.add(new DayCode().fillJson((Map)obj));
            }
            Logic.dayCodeLogic.create(dayCodeList);
        }
        return new ActionForward(1, 1);
    }

    private ActionForward remove(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.dayCodeLogic.remove(wrapper.getInteger("codeId"));
        return new ActionForward(resp, 1);
    }

    private ActionForward update(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.dayCodeLogic.update(new DayCode().fill(wrapper));
        return new ActionForward(resp, 1);
    }

    private ActionForward fetch(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        DayCode dayCode = Logic.dayCodeLogic.fetch(wrapper.getInteger("codeId"));
        String resp = Json.toJs((String)"codeId", (Object)dayCode);
        return new ActionForward(resp, 1);
    }

    private ActionForward export(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        List<DayCode> dayCodeList = Logic.dayCodeLogic.export(wrapper.getInteger("offset"), wrapper.getInteger("limit"));
        String resp = Json.toJs((String)"dayCodeList", dayCodeList);
        return new ActionForward(resp, 1);
    }

    public static void main(String[] args) throws Exception {
        FileInputStream is = new FileInputStream("F:\\temp\\75721.jpg");
        BufferedImage buff = ImageIO.read(is);
        System.out.println(buff.getWidth());
        System.out.println(buff.getHeight());
        ((InputStream)is).close();
    }
}

