/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.action;

import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Answer;
import com.coyousoft.yundama.entity.AnswerDayCode;
import com.coyousoft.yundama.entity.DayCode;
import com.coyousoft.yundama.support.FormHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.sun.mvc.support.RequestWrapper;

public class AnswerDayCodeAction
extends BaseAction {
    public ActionForward execute(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper, String dispatch) throws Exception {
        if ("create".equals(dispatch)) {
            return this.create(request, response, session, wrapper);
        }
        if ("jsonCreate".equals(dispatch)) {
            return this.jsonCreate(request, response, session, wrapper);
        }
        if ("remove".equals(dispatch)) {
            return this.remove(request, response, session, wrapper);
        }
        if ("update".equals(dispatch)) {
            return this.update(request, response, session, wrapper);
        }
        if ("fetch".equals(dispatch)) {
            return this.fetch(request, response, session, wrapper);
        }
        if ("export".equals(dispatch)) {
            return this.export(request, response, session, wrapper);
        }
        if ("fetchList".equals(dispatch)) {
            return this.fetchList(request, response, session, wrapper);
        }
        return null;
    }

    private ActionForward fetchList(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        String lastWeek;
        Answer answer;
        String beginDate = wrapper.getString("beginDate");
        String endDate = wrapper.getString("endDate");
        String answerAccount = wrapper.getString("answerAccount");
        Integer answerId = wrapper.getInteger("answerId");
        if (answerId == null && (answer = Logic.answerLogic.fetchByAccount(answerAccount)) != null) {
            answerId = answer.getAnswerId();
        }
        Calendar c = FormHelper.getCalendar();
        Date edDate = null;
        edDate = endDate == null ? c.getTime() : FormHelper.parseDate(endDate);
        Date bgDate = null;
        if (beginDate == null) {
            c.add(5, -7);
            bgDate = c.getTime();
        } else {
            bgDate = FormHelper.parseDate(beginDate);
        }
        String currWeek = wrapper.getString("currWeek");
        if (currWeek != null) {
            c = FormHelper.getMonday();
            bgDate = c.getTime();
            edDate = FormHelper.getCalendar().getTime();
        }
        if ((lastWeek = wrapper.getString("lastWeek")) != null) {
            c = FormHelper.getMonday();
            c.add(5, -7);
            bgDate = c.getTime();
            c.add(5, 6);
            edDate = c.getTime();
        }
        List<AnswerDayCode> answerDayCodeList = Logic.answerDayCodeLogic.fetchList(answerId, bgDate, edDate);
        request.setAttribute("answerDayCodeList", answerDayCodeList);
        int totalCodeNum = 0;
        for (AnswerDayCode answerDayCode : answerDayCodeList) {
            totalCodeNum += answerDayCode.getCodeNum().intValue();
        }
        request.setAttribute("totalCodeNum", (Object)totalCodeNum);
        request.setAttribute("beginDate", (Object)FormHelper.formatDate(bgDate));
        request.setAttribute("endDate", (Object)FormHelper.formatDate(edDate));
        request.setAttribute("answerId", (Object)answerId);
        List<DayCode> dayCodeList = Logic.dayCodeLogic.fetchListByAnswerId(Logic.dayCodeLogic.getTableName(), answerId);
        request.setAttribute("dayCodeList", dayCodeList);
        request.setAttribute("cacheSizeArr", (Object)Logic.dayCodeLogic.getCacheSize());
        return new ActionForward("/jsp/answerDayCodeList.jsp", 2);
    }

    private ActionForward create(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Logic.answerDayCodeLogic.create(new AnswerDayCode().fill(wrapper));
        return new ActionForward(1, 1);
    }

    private ActionForward jsonCreate(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Object jsonData = Json.toJavaObject((String)wrapper.getString("jsonData"));
        if (jsonData instanceof Map) {
            Logic.answerDayCodeLogic.create(new AnswerDayCode().fillJson((Map)jsonData));
        } else {
            List list = (List)jsonData;
            ArrayList<AnswerDayCode> answerDayCodeList = new ArrayList<AnswerDayCode>(list.size());
            for (Object obj : list) {
                answerDayCodeList.add(new AnswerDayCode().fillJson((Map)obj));
            }
            Logic.answerDayCodeLogic.create(answerDayCodeList);
        }
        return new ActionForward(1, 1);
    }

    private ActionForward remove(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.answerDayCodeLogic.remove(wrapper.getInteger("dayId"));
        return new ActionForward(resp, 1);
    }

    private ActionForward update(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.answerDayCodeLogic.update(new AnswerDayCode().fill(wrapper));
        return new ActionForward(resp, 1);
    }

    private ActionForward fetch(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        AnswerDayCode answerDayCode = Logic.answerDayCodeLogic.fetch(wrapper.getInteger("dayId"));
        String resp = Json.toJs((String)"dayId", (Object)answerDayCode);
        return new ActionForward(resp, 1);
    }

    private ActionForward export(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        List<AnswerDayCode> answerDayCodeList = Logic.answerDayCodeLogic.export(wrapper.getInteger("offset"), wrapper.getInteger("limit"));
        String resp = Json.toJs((String)"answerDayCodeList", answerDayCodeList);
        return new ActionForward(resp, 1);
    }
}

