/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.action;

import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Admin;
import com.coyousoft.yundama.entity.Answer;
import com.coyousoft.yundama.entity.AnswerDayCode;
import com.coyousoft.yundama.support.FormHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.sysolar.sun.config.FileConfig;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.sun.mvc.support.RequestWrapper;
import org.sysolar.util.MD5;

public class AnswerAction
extends BaseAction {
    public ActionForward execute(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper, String dispatch) throws Exception {
        if ("create".equals(dispatch)) {
            return this.create(request, response, session, wrapper);
        }
        if ("jsonCreate".equals(dispatch)) {
            return this.jsonCreate(request, response, session, wrapper);
        }
        if ("remove".equals(dispatch)) {
            return this.remove(request, response, session, wrapper);
        }
        if ("update".equals(dispatch)) {
            return this.update(request, response, session, wrapper);
        }
        if ("fetch".equals(dispatch)) {
            return this.fetch(request, response, session, wrapper);
        }
        if ("fetchList".equals(dispatch)) {
            return this.fetchList(request, response, session, wrapper);
        }
        if ("export".equals(dispatch)) {
            return this.export(request, response, session, wrapper);
        }
        if ("login".equals(dispatch)) {
            return this.login(request, response, session, wrapper);
        }
        return null;
    }

    private ActionForward login(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Answer formAnswer = new Answer().fill(wrapper);
        Answer answer = Logic.answerLogic.fetchByAccount(formAnswer.getAnswerAccount(), MD5.encoder((String)formAnswer.getAnswerPassword()));
        if (answer == null) {
            request.setAttribute("errMsg", (Object)"\u90ae\u7bb1\u6216\u5bc6\u7801\u9519\u8bef");
            request.setAttribute("formAnswer", (Object)formAnswer);
            return new ActionForward("/answerLogin.jsp", 2);
        }
        String action = "/AnswerDayCodeAction.do?dispatch=fetchList&answerAccount=" + answer.getAnswerAccount();
        request.getRequestDispatcher(action).forward((ServletRequest)request, (ServletResponse)response);
        return new ActionForward(4);
    }

    private ActionForward create(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null || admin.getAdminType() != 200) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        List<String[]> list = FormHelper.parseArea(wrapper.getString("answerAccounts"));
        HashMap<String, Answer> map = new HashMap<String, Answer>(list.size());
        Answer answer = null;
        String answerErrMsg = null;
        for (String[] arr : list) {
            if (arr.length < 3) {
                answerErrMsg = "\u6dfb\u52a0\u5931\u8d25\uff0c\u8d26\u53f7\u683c\u5f0f\u65e0\u6548\uff01";
                break;
            }
            answer = new Answer().setAnswerAccount(arr[0]).setAnswerPassword(arr[1]).setAnswerOrder(arr[2]).setAdminId(admin.getAdminId());
            if (arr.length == 4) {
                answer.setAnswerZhifubao(arr[3]);
            }
            if (!FormHelper.checkAccount(answer.getAnswerAccount())) {
                answerErrMsg = "\u6dfb\u52a0\u5931\u8d25\uff0c\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff1a" + answer.getAnswerAccount();
                break;
            }
            if (!FormHelper.checkPassword(answer.getAnswerPassword())) {
                answerErrMsg = "\u5bc6\u7801\u65e0\u6548\uff0c6-30\u4f4d\u5b57\u6bcd\u6570\u5b57\u7ec4\u5408\uff0c\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\uff1a" + answer.getAnswerAccount();
                break;
            }
            answer.setAnswerPassword(MD5.encoder((String)answer.getAnswerPassword()));
            map.put(answer.getAnswerAccount(), answer);
        }
        if (answerErrMsg != null) {
            request.setAttribute("answerErrMsg", answerErrMsg);
            return new ActionForward("/jsp/agencyAdminMain.jsp", 2);
        }
        Logic.answerLogic.create(new ArrayList<Answer>(map.values()), admin.getAdminId());
        request.setAttribute("answerMsg", (Object)"\u606d\u559c\u7f8e\u5973&\u5e05\u54e5\uff0c\u6dfb\u52a0\u6210\u529f\u4e86\uff01");
        return new ActionForward("/jsp/agencyAdminMain.jsp", 2);
    }

    public ActionForward fetchList(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        String lastWeek;
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        Integer adminId = wrapper.getInteger("adminId");
        if (adminId == null) {
            adminId = admin.getAdminId();
        }
        String beginDate = wrapper.getString("beginDate");
        String endDate = wrapper.getString("endDate");
        Calendar c = FormHelper.getCalendar();
        Date edDate = null;
        edDate = endDate == null ? c.getTime() : FormHelper.parseDate(endDate);
        Date bgDate = null;
        bgDate = beginDate == null ? c.getTime() : FormHelper.parseDate(beginDate);
        String currWeek = wrapper.getString("currWeek");
        if (currWeek != null) {
            c = FormHelper.getMonday();
            bgDate = c.getTime();
            edDate = FormHelper.getCalendar().getTime();
        }
        if ((lastWeek = wrapper.getString("lastWeek")) != null) {
            c = FormHelper.getMonday();
            c.add(5, -7);
            bgDate = c.getTime();
            c.add(5, 6);
            edDate = c.getTime();
        }
        List<AnswerDayCode> answerDayCodeList = Logic.answerLogic.fetchList(adminId, bgDate, edDate);
        request.setAttribute("answerDayCodeList", answerDayCodeList);
        int totalCodeNum = 0;
        int totalWrongCodeNum = 0;
        int nightTotalCodeNum = 0;
        int nightAwardCodeNum = 0;
        for (AnswerDayCode anwserDayCode : answerDayCodeList) {
            if (anwserDayCode.getCodeNum() != null) {
                totalCodeNum += anwserDayCode.getCodeNum().intValue();
            }
            if (anwserDayCode.getWrongCodeNum() != null) {
                totalWrongCodeNum += anwserDayCode.getWrongCodeNum().intValue();
            }
            if (anwserDayCode.getNightCodeNum() == null) continue;
            nightTotalCodeNum += anwserDayCode.getNightCodeNum().intValue();
            int minNightAwardCodeNum = FileConfig.getInteger((String)"minNightAwardCodeNum", (Integer)1000);
            if (anwserDayCode.getNightCodeNum() < minNightAwardCodeNum) continue;
            nightAwardCodeNum += anwserDayCode.getNightCodeNum().intValue();
        }
        String showAllAnswer = wrapper.getString("showAllAnswer");
        if (showAllAnswer != null && showAllAnswer.equals("1")) {
            request.setAttribute("showAllAnswer", (Object)showAllAnswer);
        }
        request.setAttribute("totalCodeNum", (Object)totalCodeNum);
        request.setAttribute("nightTotalCodeNum", (Object)nightTotalCodeNum);
        request.setAttribute("nightAwardCodeNum", (Object)nightAwardCodeNum);
        request.setAttribute("totalWrongCodeNum", (Object)totalWrongCodeNum);
        request.setAttribute("beginDate", (Object)FormHelper.formatDate(bgDate));
        request.setAttribute("endDate", (Object)FormHelper.formatDate(edDate));
        request.setAttribute("adminId", (Object)adminId);
        request.setAttribute("cacheSizeArr", (Object)Logic.dayCodeLogic.getCacheSize());
        return new ActionForward("/jsp/answerList.jsp", 2);
    }

    private ActionForward jsonCreate(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Object jsonData = Json.toJavaObject((String)wrapper.getString("jsonData"));
        if (jsonData instanceof Map) {
            Logic.answerLogic.create(new Answer().fillJson((Map)jsonData));
        } else {
            List list = (List)jsonData;
            ArrayList<Answer> answerList = new ArrayList<Answer>(list.size());
            for (Object obj : list) {
                answerList.add(new Answer().fillJson((Map)obj));
            }
            Logic.answerLogic.create(answerList, null);
        }
        return new ActionForward(1, 1);
    }

    private ActionForward remove(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        Logic.answerLogic.remove(wrapper.getInteger("answerId"));
        return this.fetchList(request, response, session, wrapper);
    }

    private ActionForward update(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.answerLogic.update(new Answer().fill(wrapper));
        return new ActionForward(resp, 1);
    }

    private ActionForward fetch(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Answer answer = Logic.answerLogic.fetch(wrapper.getInteger("answerId"));
        String resp = Json.toJs((String)"answerId", (Object)answer);
        return new ActionForward(resp, 1);
    }

    private ActionForward export(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        List<Answer> answerList = Logic.answerLogic.export(wrapper.getInteger("offset"), wrapper.getInteger("limit"));
        String resp = Json.toJs((String)"answerList", answerList);
        return new ActionForward(resp, 1);
    }
}

