/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yundama.action;

import com.coyousoft.yundama.constant.Logic;
import com.coyousoft.yundama.entity.Admin;
import com.coyousoft.yundama.support.FormHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.sun.mvc.support.RequestWrapper;
import org.sysolar.util.MD5;

public class AdminAction
extends BaseAction {
    public ActionForward execute(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper, String dispatch) throws Exception {
        if ("create".equals(dispatch)) {
            return this.create(request, response, session, wrapper);
        }
        if ("jsonCreate".equals(dispatch)) {
            return this.jsonCreate(request, response, session, wrapper);
        }
        if ("remove".equals(dispatch)) {
            return this.remove(request, response, session, wrapper);
        }
        if ("update".equals(dispatch)) {
            return this.update(request, response, session, wrapper);
        }
        if ("fetch".equals(dispatch)) {
            return this.fetch(request, response, session, wrapper);
        }
        if ("export".equals(dispatch)) {
            return this.export(request, response, session, wrapper);
        }
        if ("login".equals(dispatch)) {
            return this.login(request, response, session, wrapper);
        }
        if ("logout".equals(dispatch)) {
            return this.logout(request, response, session, wrapper);
        }
        if ("addAgency".equals(dispatch)) {
            return this.addAgency(request, response, session, wrapper);
        }
        if ("fetchList".equals(dispatch)) {
            return this.fetchList(request, response, session, wrapper);
        }
        return null;
    }

    private ActionForward login(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin formAdmin = new Admin().fill(wrapper);
        Admin dbAdmin = Logic.adminLogic.fetchByAccount(formAdmin.getAdminAccount());
        String errMsg = null;
        if (dbAdmin == null || !dbAdmin.getAdminAccount().equals(formAdmin.getAdminAccount())) {
            errMsg = "\u90ae\u7bb1\u9519\u8bef";
        } else if (formAdmin.getAdminPassword() == null || !dbAdmin.getAdminPassword().equals(MD5.encoder((String)formAdmin.getAdminPassword()))) {
            errMsg = "\u5bc6\u7801\u9519\u8bef";
        }
        if (errMsg != null) {
            request.setAttribute("errMsg", (Object)errMsg);
            request.setAttribute("formAdmin", (Object)formAdmin);
            return new ActionForward("/adminLogin.jsp", 2);
        }
        session.setAttribute("admin", (Object)dbAdmin);
        if (dbAdmin.getAdminType() == 100) {
            request.getRequestDispatcher("/DayCodeAction.do?dispatch=fetchLisForSuperAdmin").forward((ServletRequest)request, (ServletResponse)response);
        } else {
            request.getRequestDispatcher("/AnswerAction.do?dispatch=fetchList").forward((ServletRequest)request, (ServletResponse)response);
        }
        return new ActionForward(4);
    }

    private ActionForward logout(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        session.invalidate();
        return new ActionForward("/index.jsp", 2);
    }

    private ActionForward addAgency(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null || admin.getAdminType() != 100) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        List<String[]> list = FormHelper.parseArea(wrapper.getString("agencyAccounts"));
        HashMap<String, Admin> map = new HashMap<String, Admin>(list.size());
        Admin agency = null;
        String agencyErrMsg = null;
        for (String[] arr : list) {
            if (arr.length != 3) {
                agencyErrMsg = "\u6dfb\u52a0\u5931\u8d25\uff0c\u8d26\u53f7\u683c\u5f0f\u65e0\u6548\uff01";
                break;
            }
            agency = new Admin().setAdminAccount(arr[0]).setAdminPassword(arr[1]).setAdminName(arr[2]).setAdminType(200);
            if (!FormHelper.checkAccount(agency.getAdminAccount())) {
                agencyErrMsg = "\u6dfb\u52a0\u5931\u8d25\uff0c\u90ae\u7bb1\u683c\u5f0f\u9519\u8bef\uff1a" + agency.getAdminAccount() + "---" + agency.getAdminPassword();
                break;
            }
            if (!FormHelper.checkPassword(agency.getAdminPassword())) {
                agencyErrMsg = "\u5bc6\u7801\u65e0\u6548\uff0c6-30\u4f4d\u5b57\u6bcd\u6570\u5b57\u7ec4\u5408\uff0c\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\uff1a" + agency.getAdminAccount() + "---" + agency.getAdminPassword();
                break;
            }
            agency.setAdminPassword(MD5.encoder((String)agency.getAdminPassword()));
            map.put(agency.getAdminAccount(), agency);
        }
        if (agencyErrMsg != null) {
            request.setAttribute("agencyErrMsg", agencyErrMsg);
            return new ActionForward("/jsp/superAdminMain.jsp", 2);
        }
        Logic.adminLogic.create(new ArrayList<Admin>(map.values()));
        request.setAttribute("agencyMsg", (Object)"\u606d\u559c\u7f8e\u5973&\u5e05\u54e5\uff0c\u6dfb\u52a0\u6210\u529f\u4e86\uff01");
        return new ActionForward("/jsp/superAdminMain.jsp", 2);
    }

    private ActionForward fetchList(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin admin = (Admin)session.getAttribute("admin");
        if (admin == null || admin.getAdminType() != 100) {
            request.setAttribute("errMsg", (Object)"\u767b\u9646\u8d85\u65f6");
            return new ActionForward("/adminLogin.jsp", 2);
        }
        List<Admin> adminList = Logic.adminLogic.fetchList(200);
        request.setAttribute("adminList", adminList);
        return new ActionForward("/jsp/adminList.jsp", 2);
    }

    private ActionForward create(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Logic.adminLogic.create(new Admin().fill(wrapper));
        return new ActionForward(1, 1);
    }

    private ActionForward jsonCreate(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Object jsonData = Json.toJavaObject((String)wrapper.getString("jsonData"));
        if (jsonData instanceof Map) {
            Logic.adminLogic.create(new Admin().fillJson((Map)jsonData));
        } else {
            List list = (List)jsonData;
            ArrayList<Admin> adminList = new ArrayList<Admin>(list.size());
            for (Object obj : list) {
                adminList.add(new Admin().fillJson((Map)obj));
            }
            Logic.adminLogic.create(adminList);
        }
        return new ActionForward(1, 1);
    }

    private ActionForward remove(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.adminLogic.remove(wrapper.getInteger("adminId"));
        return new ActionForward(resp, 1);
    }

    private ActionForward update(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.adminLogic.update(new Admin().fill(wrapper));
        return new ActionForward(resp, 1);
    }

    private ActionForward fetch(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Admin admin = Logic.adminLogic.fetch(wrapper.getInteger("adminId"));
        String resp = Json.toJs((String)"adminId", (Object)admin);
        return new ActionForward(resp, 1);
    }

    private ActionForward export(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        List<Admin> adminList = Logic.adminLogic.export(wrapper.getInteger("offset"), wrapper.getInteger("limit"));
        String resp = Json.toJs((String)"adminList", adminList);
        return new ActionForward(resp, 1);
    }
}

