/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yoxproductparse.gui;

import com.coyousoft.yox.constant.C;
import com.coyousoft.yox.gui.YoxIframe;
import com.coyousoft.yox.gui.YoxListTable;
import com.coyousoft.yoxproductparse.entity.SoldNote;
import com.coyousoft.yoxproductparse.gui.ProductParseIframe;
import java.awt.Dimension;
import java.util.Calendar;
import javax.swing.table.TableColumn;

public class SoldNoteTable<T>
extends YoxListTable<SoldNote> {
    private static final long serialVersionUID = 1L;

    public SoldNoteTable(YoxIframe iframe) {
        super(new String[]{"\u5e8f\u53f7", "\u4ed8\u6b3e\u65e5\u671f", "\u5468\u51e0", "\u4ed8\u6b3e\u65f6\u95f4", "\u4e70\u5bb6\u6635\u79f0", "\u4e70\u5bb6\u7ea7\u522b", "\u4ef7\u683c", "\u4ef6\u6570", "SKU"}, iframe, false);
    }

    @Override
    protected Dimension getOpenTableRowDlgDim() {
        return new Dimension(300, 500);
    }

    @Override
    public Object getValueAt(SoldNote t, int columnIndex) {
        Object value = "";
        switch (columnIndex) {
            case 1: {
                value = C.Y_M_D_DF.format(t.getDate());
                break;
            }
            case 2: {
                Calendar c = Calendar.getInstance();
                c.setTime(t.getDate());
                int dayOfWeek = c.get(7);
                if (dayOfWeek == 1) {
                    value = "\u5468\u65e5";
                }
                if (dayOfWeek == 2) {
                    value = "\u5468\u4e00";
                }
                if (dayOfWeek == 3) {
                    value = "\u5468\u4e8c";
                }
                if (dayOfWeek == 4) {
                    value = "\u5468\u4e09";
                }
                if (dayOfWeek == 5) {
                    value = "\u5468\u56db";
                }
                if (dayOfWeek == 6) {
                    value = "\u5468\u4e94";
                }
                if (dayOfWeek != 7) break;
                value = "\u5468\u516d";
                break;
            }
            case 3: {
                value = C.H_M_S_DF.format(t.getDate());
                break;
            }
            case 4: {
                value = t.getBuyer().getAccount();
                break;
            }
            case 5: {
                String cLevel = ProductParseIframe.LEVEL_MAP.get(t.getBuyer().getcLevel());
                value = String.valueOf(cLevel) + "," + t.getBuyer().getbLevel();
                break;
            }
            case 6: {
                value = t.getPrice();
                break;
            }
            case 7: {
                value = t.getNumber();
                break;
            }
            case 8: {
                value = t.getSku().getSkuName();
            }
        }
        return value;
    }

    @Override
    protected void dealHeader() {
        TableColumn c = this.getColumnModel().getColumn(1);
        c.setPreferredWidth(80);
        c.setMaxWidth(200);
        c.setMinWidth(10);
        c = this.getColumnModel().getColumn(2);
        c.setPreferredWidth(50);
        c.setMaxWidth(200);
        c.setMinWidth(10);
        c = this.getColumnModel().getColumn(3);
        c.setPreferredWidth(80);
        c.setMaxWidth(200);
        c.setMinWidth(10);
        c = this.getColumnModel().getColumn(4);
        c.setPreferredWidth(100);
        c.setMaxWidth(200);
        c.setMinWidth(10);
        c = this.getColumnModel().getColumn(5);
        c.setPreferredWidth(110);
        c.setMaxWidth(200);
        c.setMinWidth(10);
        c = this.getColumnModel().getColumn(6);
        c.setPreferredWidth(80);
        c.setMaxWidth(200);
        c.setMinWidth(10);
        c = this.getColumnModel().getColumn(7);
        c.setPreferredWidth(50);
        c.setMaxWidth(200);
        c.setMinWidth(10);
    }
}

