/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yoxproductparse.gui;

import com.coyousoft.yox.constant.C;
import com.coyousoft.yox.gui.YoxButton;
import com.coyousoft.yox.gui.YoxComboBox;
import com.coyousoft.yox.gui.YoxComboBoxModel;
import com.coyousoft.yox.gui.YoxDialog;
import com.coyousoft.yox.gui.YoxIframe;
import com.coyousoft.yox.gui.YoxInfoTable;
import com.coyousoft.yox.gui.YoxLabel;
import com.coyousoft.yox.gui.YoxMainFace;
import com.coyousoft.yox.gui.YoxPanel;
import com.coyousoft.yox.gui.YoxTextArea;
import com.coyousoft.yox.gui.YoxTextField;
import com.coyousoft.yox.gui.YoxTgButton;
import com.coyousoft.yox.gui.YoxToolBar;
import com.coyousoft.yoxproductparse.datastore.DataStore;
import com.coyousoft.yoxproductparse.datastore.DataStoreTask;
import com.coyousoft.yoxproductparse.entity.Assess;
import com.coyousoft.yoxproductparse.entity.AssessCount;
import com.coyousoft.yoxproductparse.entity.Buyer;
import com.coyousoft.yoxproductparse.entity.BuyerLevelAmount;
import com.coyousoft.yoxproductparse.entity.PathDate;
import com.coyousoft.yoxproductparse.entity.SalesAmount;
import com.coyousoft.yoxproductparse.entity.Sku;
import com.coyousoft.yoxproductparse.entity.SkuAmount;
import com.coyousoft.yoxproductparse.entity.SkuPriceDate;
import com.coyousoft.yoxproductparse.entity.SoldNote;
import com.coyousoft.yoxproductparse.gui.AssessCountTable;
import com.coyousoft.yoxproductparse.gui.SoldNoteTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.sysolar.threadpool.Task;
import org.sysolar.threadpool.ThreadPool;

public class ProductParseIframe
extends YoxIframe {
    private static final long serialVersionUID = 1L;
    private static final Integer CHART_TYPE_SOLD_NOTE = 1;
    private static final Integer CHART_TYPE_SALES_AMOUNT_PATH = 2;
    private static final Integer CHART_TYPE_SALES_VOLUME_PATH = 3;
    private static final Integer CHART_TYPE_PRICE_PATH = 4;
    private static final Integer CHART_TYPE_SKU_SCALE = 5;
    private static final Integer CHART_TYPE_BUYER_SCALE = 6;
    private static final Integer CHART_TYPE_ASSESS_PARSE = 7;
    protected DataStore dataStore;
    private SoldNoteTable<SoldNote> soldNoteTable;
    private YoxButton productNameLabel;
    private YoxPanel chartPanel;
    private YoxTextField productUrlTf;
    private YoxTextField beginDateTf;
    private YoxTextField endDateTf;
    protected YoxDialog beginDateDialog;
    protected YoxDialog endDateDialog;
    private YoxLabel pullOffTimeLabel;
    private int currentChartType = 0;
    private YoxLabel publicTimeLabel;
    private static final Integer[] RED_COLOR_ARR = new Integer[]{0xFFFFFF, 0xFFEEEE, 0xFFDDDD, 0xFFCCCC, 0xFFBBBB, 0xFFAAAA, 0xFF9999, 0xFF8888, 0xFF7777, 0xFF6666, 0xFF5555, 0xFF4444, 0xFF3333, 0xFF2222, 0xFF1111, 0xFF0000, 0xFF0000, 0xFF0000};
    private static final Map<String, DataStore> DATA_STORE_MAP = new HashMap<String, DataStore>();
    public static final Map<String, String> LEVEL_MAP = new HashMap<String, String>();
    private String currentDateRange;
    private YoxLabel totalOrderLabel;
    private YoxLabel currentOrderLabel;
    private YoxLabel totalAmountLabel;
    private YoxLabel currentAmountLabel;
    private YoxLabel rateNumLabel;
    private List<SoldNote> soldNoteList = Collections.synchronizedList(new ArrayList());
    private ThreadPool pool;
    private boolean isLoadingData = false;
    protected List<String> dateList;
    private YoxButton findButton;
    private YoxToolBar toolBar2;
    private YoxTgButton soldNoteBt;
    private YoxTgButton salesAmountPathBt;
    private YoxTgButton salesVolumePathBt;
    private YoxTgButton pricePathBt;
    private YoxTgButton skuScaleBt;
    private YoxTgButton buyerScaleBt;
    private YoxTgButton assessParseBt;

    static {
        LEVEL_MAP.put("red_1", "1\u5fc3");
        LEVEL_MAP.put("red_2", "2\u5fc3");
        LEVEL_MAP.put("red_3", "3\u5fc3");
        LEVEL_MAP.put("red_4", "4\u5fc3");
        LEVEL_MAP.put("red_5", "5\u5fc3");
        LEVEL_MAP.put("blue_1", "1\u94bb");
        LEVEL_MAP.put("blue_2", "2\u94bb");
        LEVEL_MAP.put("blue_3", "3\u94bb");
        LEVEL_MAP.put("blue_4", "4\u94bb");
        LEVEL_MAP.put("blue_5", "5\u94bb");
        LEVEL_MAP.put("cap_1", "1\u7ea2\u51a0");
        LEVEL_MAP.put("cap_2", "2\u7ea2\u51a0");
        LEVEL_MAP.put("cap_3", "3\u7ea2\u51a0");
        LEVEL_MAP.put("cap_4", "4\u7ea2\u51a0");
        LEVEL_MAP.put("cap_5", "5\u7ea2\u51a0");
        LEVEL_MAP.put("\u65e0\u5fc3\u7ea7", "\u65e0\u5fc3\u7ea7");
    }

    public ProductParseIframe(String title, YoxMainFace mainFace, YoxTgButton button) {
        super(title, mainFace, button);
        this.currentChartType = CHART_TYPE_SOLD_NOTE;
        this.pool = new ThreadPool(1);
    }

    @Override
    protected void afterGUI() {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    ChartPanel linePanel;
                    CategoryAxis domainAxis;
                    JFreeChart chart;
                    String day;
                    String month;
                    String[] dateArr;
                    Object pathDate;
                    Object weekStr;
                    SalesAmount amount;
                    String dateStr;
                    String currentYear;
                    Iterator lineName;
                    Object linedataset;
                    String soldDate;
                    ArrayList<SalesAmount> amountList;
                    String currentDate;
                    Date publicTime;
                    if (ProductParseIframe.this.dataStore == null) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    YoxIframe e = ProductParseIframe.this.me;
                    synchronized (e) {
                        if (!ProductParseIframe.this.isLoadingData()) {
                            try {
                                ProductParseIframe.this.setBtFreeze(true);
                                ProductParseIframe.this.me.wait();
                            }
                            catch (InterruptedException e2) {
                                e2.printStackTrace();
                            }
                        }
                    }
                    ProductParseIframe.this.setBtFreeze(false);
                    String name = ProductParseIframe.this.dataStore.getProductName();
                    if (name == null) {
                        name = "";
                    }
                    ArrayList currentSoldNoteList = new ArrayList();
                    currentSoldNoteList.addAll(ProductParseIframe.this.soldNoteList);
                    System.out.println(ProductParseIframe.this.soldNoteList.size());
                    ProductParseIframe.this.productNameLabel.setText("<html><a href=''>" + name + "</a></html>");
                    Integer totalOrder = ProductParseIframe.this.dataStore.getTotalOrder();
                    String totalOrderStr = totalOrder == 0 ? "-" : "" + totalOrder;
                    ProductParseIframe.this.totalOrderLabel.setText("\u603b\u8ba2\u5355\u91cf:[" + totalOrderStr + "]");
                    Integer currentOrder = 0;
                    Float currentAmount = Float.valueOf(0.0f);
                    for (SoldNote soldNote : currentSoldNoteList) {
                        currentOrder = currentOrder + soldNote.getNumber();
                        currentAmount = Float.valueOf(currentAmount.floatValue() + (float)soldNote.getNumber().intValue() * soldNote.getPrice().floatValue());
                    }
                    String overFlag = "";
                    if (ProductParseIframe.this.currentDateRange.indexOf("30\u5929") != -1 && ProductParseIframe.this.dataStore.isSoldNoteOverPage()) {
                        overFlag = "+";
                    }
                    ProductParseIframe.this.currentOrderLabel.setText(String.valueOf(ProductParseIframe.this.currentDateRange) + "\u8ba2\u5355\u91cf:[" + currentOrder + overFlag + "]");
                    Float totalAmount = ProductParseIframe.this.dataStore.getTotalAmount();
                    ProductParseIframe.this.totalAmountLabel.setText("\u603b\u9500\u552e\u989d:[" + totalAmount + "]");
                    ProductParseIframe.this.currentAmountLabel.setText(String.valueOf(ProductParseIframe.this.currentDateRange) + "\u9500\u552e\u989d:[" + currentAmount + overFlag + "]");
                    Date pullOffTime = ProductParseIframe.this.dataStore.getPullOffTime();
                    String week = "";
                    if (pullOffTime != null) {
                        week = ProductParseIframe.this.getWeek(pullOffTime);
                        String time = C.H_M_S_DF.format(pullOffTime);
                        ProductParseIframe.this.pullOffTimeLabel.setText("\u4e0b\u67b6\u65f6\u95f4:[" + C.Y_M_D_DF.format(pullOffTime) + "(" + week + ") " + time + "]");
                    }
                    if ((publicTime = ProductParseIframe.this.dataStore.getPublicTime()) != null) {
                        week = ProductParseIframe.this.getWeek(publicTime);
                        String time = C.H_M_S_DF.format(publicTime);
                        ProductParseIframe.this.publicTimeLabel.setText("\u53d1\u5e03\u65f6\u95f4:[" + C.Y_M_D_DF.format(publicTime) + "(" + week + ") " + time + "]");
                    } else {
                        ProductParseIframe.this.publicTimeLabel.setText("\u53d1\u5e03\u65f6\u95f4:[-]");
                    }
                    if (ProductParseIframe.this.currentChartType == CHART_TYPE_SOLD_NOTE) {
                        YoxLabel label = new YoxLabel();
                        label.setHorizontalAlignment(0);
                        label.setFont(new Font("SansSerif", 1, 18));
                        label.setText(String.valueOf(ProductParseIframe.this.currentDateRange) + "\u9500\u552e\u8bb0\u5f55");
                        ProductParseIframe.this.soldNoteTable = new SoldNoteTable(ProductParseIframe.this.me);
                        TableModel model = ProductParseIframe.this.soldNoteTable.getModel();
                        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(model);
                        ProductParseIframe.this.soldNoteTable.setRowSorter(sorter);
                        ProductParseIframe.this.soldNoteTable.clear();
                        ProductParseIframe.this.soldNoteTable.addRow(currentSoldNoteList, currentSoldNoteList.size());
                        ProductParseIframe.this.chartPanel.removeAll();
                        ProductParseIframe.this.chartPanel.add((Component)label, "North");
                        ProductParseIframe.this.chartPanel.add((Component)ProductParseIframe.this.soldNoteTable.getScPane(), "Center");
                        ProductParseIframe.this.chartPanel.updateUI();
                    } else if (ProductParseIframe.this.currentChartType == CHART_TYPE_SALES_AMOUNT_PATH) {
                        currentDate = "";
                        amountList = new ArrayList<SalesAmount>();
                        for (SoldNote soldNote : currentSoldNoteList) {
                            SalesAmount salesAmount2;
                            soldDate = C.Y_M_D_DF.format(soldNote.getDate());
                            Float amount2 = Float.valueOf(soldNote.getPrice().floatValue() * (float)soldNote.getNumber().intValue());
                            boolean isIn = false;
                            for (SalesAmount salesAmount2 : amountList) {
                                String amountDate = salesAmount2.getSalesDate();
                                if (!amountDate.equals(soldDate)) continue;
                                salesAmount2.setAmount(Float.valueOf(salesAmount2.getAmount().floatValue() + amount2.floatValue()));
                                isIn = true;
                            }
                            if (isIn) continue;
                            salesAmount2 = new SalesAmount();
                            salesAmount2.setAmount(amount2);
                            salesAmount2.setSalesDate(soldDate);
                            amountList.add(salesAmount2);
                        }
                        linedataset = new DefaultCategoryDataset();
                        lineName = "\u9500\u552e\u989d\u8d70\u52bf";
                        currentYear = "";
                        String currentMonth = "";
                        try {
                            Collections.reverse(amountList);
                            int i = 0;
                            while (i < ProductParseIframe.this.dateList.size()) {
                                dateStr = ProductParseIframe.this.dateList.get(i);
                                amount = null;
                                for (SalesAmount tmpAmount : amountList) {
                                    if (!tmpAmount.getSalesDate().equals(dateStr)) continue;
                                    amount = tmpAmount;
                                }
                                Date date = C.Y_M_D_DF.parse(dateStr);
                                weekStr = "(" + ProductParseIframe.this.getWeek(date) + ")";
                                pathDate = new PathDate(dateStr);
                                dateArr = dateStr.split("-");
                                String year = dateArr[0];
                                month = dateArr[1];
                                day = dateArr[2];
                                if (!currentYear.equals(year)) {
                                    currentYear = year;
                                    ((PathDate)pathDate).setDateShow(String.valueOf(((PathDate)pathDate).getDateStr()) + (String)weekStr);
                                } else if (!currentMonth.equals(month)) {
                                    currentMonth = month;
                                    ((PathDate)pathDate).setDateShow(String.valueOf(month) + "-" + day + (String)weekStr);
                                } else {
                                    ((PathDate)pathDate).setDateShow(String.valueOf(day) + (String)weekStr);
                                }
                                ((PathDate)pathDate).setDateShow(day);
                                Float value = Float.valueOf(0.0f);
                                if (amount != null) {
                                    value = amount.getAmount();
                                }
                                linedataset.addValue((Number)value, lineName, (Comparable)pathDate);
                                ++i;
                            }
                        }
                        catch (ParseException e3) {
                            e3.printStackTrace();
                        }
                        chart = ChartFactory.createLineChart((String)(String.valueOf(ProductParseIframe.this.currentDateRange) + "\u9500\u552e\u989d\u8d70\u52bf"), (String)"\u9500\u552e\u65e5\u671f", (String)"\u9500\u552e\u989d(\u5143)", (CategoryDataset)linedataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                        chart.setTextAntiAlias(false);
                        ProductParseIframe.this.setLineChartNode(chart);
                        domainAxis = chart.getCategoryPlot().getDomainAxis();
                        linePanel = new ChartPanel(chart);
                        ProductParseIframe.this.chartPanel.removeAll();
                        ProductParseIframe.this.chartPanel.add((Component)linePanel, "Center");
                        ProductParseIframe.this.chartPanel.updateUI();
                    } else if (ProductParseIframe.this.currentChartType == CHART_TYPE_SALES_VOLUME_PATH) {
                        currentDate = "";
                        amountList = new ArrayList();
                        for (SoldNote soldNote : currentSoldNoteList) {
                            SalesAmount salesAmount3;
                            soldDate = C.Y_M_D_DF.format(soldNote.getDate());
                            boolean isIn = false;
                            for (SalesAmount salesAmount3 : amountList) {
                                String amountDate = salesAmount3.getSalesDate();
                                if (!amountDate.equals(soldDate)) continue;
                                salesAmount3.setNumber(salesAmount3.getNumber() + soldNote.getNumber());
                                isIn = true;
                            }
                            if (isIn) continue;
                            salesAmount3 = new SalesAmount();
                            salesAmount3.setNumber(soldNote.getNumber());
                            salesAmount3.setSalesDate(soldDate);
                            amountList.add(salesAmount3);
                            currentDate = soldDate;
                        }
                        linedataset = new DefaultCategoryDataset();
                        lineName = "\u9500\u91cf\u8d70\u52bf";
                        currentYear = "";
                        String currentMonth = "";
                        try {
                            Collections.reverse(amountList);
                            int i = 0;
                            while (i < ProductParseIframe.this.dateList.size()) {
                                dateStr = ProductParseIframe.this.dateList.get(i);
                                amount = null;
                                for (SalesAmount tmpAmount : amountList) {
                                    if (!tmpAmount.getSalesDate().equals(dateStr)) continue;
                                    amount = tmpAmount;
                                }
                                Date date = C.Y_M_D_DF.parse(dateStr);
                                weekStr = "(" + ProductParseIframe.this.getWeek(date) + ")";
                                pathDate = new PathDate(dateStr);
                                dateArr = dateStr.split("-");
                                String year = dateArr[0];
                                month = dateArr[1];
                                day = dateArr[2];
                                if (!currentYear.equals(year)) {
                                    currentYear = year;
                                    ((PathDate)pathDate).setDateShow(String.valueOf(((PathDate)pathDate).getDateStr()) + (String)weekStr);
                                } else if (!currentMonth.equals(month)) {
                                    currentMonth = month;
                                    ((PathDate)pathDate).setDateShow(String.valueOf(month) + "-" + day + (String)weekStr);
                                } else {
                                    ((PathDate)pathDate).setDateShow(String.valueOf(day) + (String)weekStr);
                                }
                                ((PathDate)pathDate).setDateShow(day);
                                int value = 0;
                                if (amount != null) {
                                    value = amount.getNumber();
                                }
                                linedataset.addValue((double)value, lineName, (Comparable)pathDate);
                                ++i;
                            }
                        }
                        catch (Exception e4) {
                            e4.printStackTrace();
                        }
                        chart = ChartFactory.createLineChart((String)(String.valueOf(ProductParseIframe.this.currentDateRange) + "\u9500\u91cf\u8d70\u52bf"), (String)"\u9500\u552e\u65e5\u671f", (String)"\u9500\u91cf(\u4ef6)", (CategoryDataset)linedataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                        chart.setTextAntiAlias(false);
                        ProductParseIframe.this.setLineChartNode(chart);
                        domainAxis = chart.getCategoryPlot().getDomainAxis();
                        linePanel = new ChartPanel(chart);
                        ProductParseIframe.this.chartPanel.removeAll();
                        ProductParseIframe.this.chartPanel.add((Component)linePanel, "Center");
                        ProductParseIframe.this.chartPanel.updateUI();
                    } else if (ProductParseIframe.this.currentChartType == CHART_TYPE_PRICE_PATH) {
                        HashMap skuPriceMap = new HashMap();
                        ArrayList tmpSoldNoteList = new ArrayList();
                        tmpSoldNoteList.addAll(currentSoldNoteList);
                        Collections.reverse(tmpSoldNoteList);
                        for (SoldNote soldNote : tmpSoldNoteList) {
                            SkuPriceDate skuPriceDate2;
                            String skuName = soldNote.getSku().getSkuName();
                            String currentSoldDate = "";
                            ArrayList<SkuPriceDate> skuPriceDateList = (ArrayList<SkuPriceDate>)skuPriceMap.get(skuName);
                            if (skuPriceDateList == null) {
                                skuPriceDateList = new ArrayList<SkuPriceDate>();
                                skuPriceMap.put(skuName, skuPriceDateList);
                            }
                            Float price = soldNote.getPrice();
                            String soldDate2 = C.Y_M_D_DF.format(soldNote.getDate());
                            boolean isIn = false;
                            for (SkuPriceDate skuPriceDate2 : skuPriceDateList) {
                                String priceDate = skuPriceDate2.getDate();
                                if (!priceDate.equals(soldDate2)) continue;
                                isIn = true;
                                break;
                            }
                            if (isIn) continue;
                            skuPriceDate2 = new SkuPriceDate();
                            skuPriceDate2.setSku(soldNote.getSku());
                            skuPriceDate2.setPrice(price);
                            skuPriceDate2.setDate(soldDate2);
                            skuPriceDateList.add(skuPriceDate2);
                        }
                        ProductParseIframe.this.chartPanel.removeAll();
                        linedataset = new DefaultCategoryDataset();
                        List<Sku> skuList = ProductParseIframe.this.dataStore.getSkuList();
                        if (skuList != null) {
                            YoxToolBar toolBar = new YoxToolBar();
                            toolBar.setPreferredSize(new Dimension(1, 35));
                            toolBar.setLayout(new FlowLayout());
                            YoxComboBoxModel<Sku> model = new YoxComboBoxModel<Sku>(skuList);
                            YoxComboBox skuComboBox = new YoxComboBox((ComboBoxModel)model);
                            toolBar.add(skuComboBox);
                            skuComboBox.addItemListener(new ItemListener((DefaultCategoryDataset)linedataset, skuComboBox, skuPriceMap){
                                private final /* synthetic */ DefaultCategoryDataset val$linedataset;
                                private final /* synthetic */ YoxComboBox val$skuComboBox;
                                private final /* synthetic */ Map val$skuPriceMap;
                                {
                                    this.val$linedataset = defaultCategoryDataset;
                                    this.val$skuComboBox = yoxComboBox;
                                    this.val$skuPriceMap = map;
                                }

                                @Override
                                public void itemStateChanged(ItemEvent e) {
                                    this.val$linedataset.clear();
                                    Sku sku = (Sku)this.val$skuComboBox.getSelectedItem();
                                    String skuName = sku.getSkuName();
                                    List list = (List)this.val$skuPriceMap.get(skuName);
                                    String currentYear = "";
                                    String currentMonth = "";
                                    try {
                                        for (SkuPriceDate skuPriceDate : list) {
                                            String amountDateStr = skuPriceDate.getDate();
                                            Date date = C.Y_M_D_DF.parse(amountDateStr);
                                            String weekStr = "(" + ProductParseIframe.this.getWeek(date) + ")";
                                            PathDate pathDate = new PathDate(amountDateStr);
                                            String dateStr = skuPriceDate.getDate();
                                            String[] dateArr = dateStr.split("-");
                                            String year = dateArr[0];
                                            String month = dateArr[1];
                                            String day = dateArr[2];
                                            if (!currentYear.equals(year)) {
                                                currentYear = year;
                                                pathDate.setDateShow(String.valueOf(pathDate.getDateStr()) + weekStr);
                                            } else if (!currentMonth.equals(month)) {
                                                currentMonth = month;
                                                pathDate.setDateShow(String.valueOf(month) + "-" + day + weekStr);
                                            } else {
                                                pathDate.setDateShow(String.valueOf(day) + weekStr);
                                            }
                                            pathDate.setDateShow(day);
                                            this.val$linedataset.addValue((Number)skuPriceDate.getPrice(), (Comparable)((Object)skuName), (Comparable)pathDate);
                                        }
                                    }
                                    catch (Exception ex) {
                                        ex.printStackTrace();
                                    }
                                }
                            });
                            ProductParseIframe.this.chartPanel.add((Component)toolBar, "North");
                            skuComboBox.setSelectedIndex(0);
                        }
                        JFreeChart chart2 = ChartFactory.createLineChart((String)(String.valueOf(ProductParseIframe.this.currentDateRange) + "\u4ef7\u683c\u8d70\u52bf"), (String)"\u9500\u552e\u65e5\u671f", (String)"\u4ef7\u683c(\u5143)", (CategoryDataset)linedataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
                        chart2.setTextAntiAlias(false);
                        CategoryAxis domainAxis2 = chart2.getCategoryPlot().getDomainAxis();
                        ProductParseIframe.this.setLineChartNode(chart2);
                        ChartPanel linePanel2 = new ChartPanel(chart2);
                        ProductParseIframe.this.chartPanel.add((Component)linePanel2, "Center");
                        ProductParseIframe.this.chartPanel.updateUI();
                    } else if (ProductParseIframe.this.currentChartType == CHART_TYPE_SKU_SCALE) {
                        HashMap<String, Object> skuAmountMap = new HashMap<String, Object>();
                        for (SoldNote soldNote : currentSoldNoteList) {
                            String skuName = soldNote.getSku().getSkuName();
                            Object skuAmount = (SkuAmount)skuAmountMap.get(skuName);
                            Float amount3 = Float.valueOf(soldNote.getPrice().floatValue() * (float)soldNote.getNumber().intValue());
                            if (skuAmount == null) {
                                skuAmount = new SkuAmount(skuName);
                                ((SkuAmount)skuAmount).setAmount(amount3);
                                ((SkuAmount)skuAmount).setNumber(soldNote.getNumber());
                                skuAmountMap.put(skuName, skuAmount);
                                continue;
                            }
                            ((SkuAmount)skuAmount).setAmount(Float.valueOf(((SkuAmount)skuAmount).getAmount().floatValue() + amount3.floatValue()));
                            ((SkuAmount)skuAmount).setNumber(((SkuAmount)skuAmount).getNumber() + soldNote.getNumber());
                        }
                        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
                        Set keySet = skuAmountMap.keySet();
                        for (String key : keySet) {
                            SkuAmount skuAmount = (SkuAmount)skuAmountMap.get(key);
                            dataset.addValue((Number)skuAmount.getNumber(), (Comparable)((Object)skuAmount.getSkuName()), (Comparable)((Object)""));
                        }
                        JFreeChart chart3 = ChartFactory.createBarChart((String)(String.valueOf(ProductParseIframe.this.currentDateRange) + "SKU\u9500\u91cf\u56fe"), (String)"SKU", (String)"\u9500\u91cf", (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                        CategoryPlot categoryPlot = chart3.getCategoryPlot();
                        BarRenderer render = (BarRenderer)categoryPlot.getRenderer();
                        render.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                        render.setBaseItemLabelsVisible(true);
                        ChartPanel charPanel = new ChartPanel(chart3);
                        ProductParseIframe.this.chartPanel.removeAll();
                        ProductParseIframe.this.chartPanel.add((Component)charPanel, "Center");
                        ProductParseIframe.this.chartPanel.updateUI();
                    } else if (ProductParseIframe.this.currentChartType == CHART_TYPE_BUYER_SCALE) {
                        Object buyercLevelAmount;
                        HashMap<String, Object> buyerbLevelAmountMap = new HashMap<String, Object>();
                        HashMap<String, BuyerLevelAmount> buyercLevelAmountMap = new HashMap<String, BuyerLevelAmount>();
                        for (SoldNote soldNote : currentSoldNoteList) {
                            String cLevel;
                            Buyer buyer = soldNote.getBuyer();
                            String buyerAccount = buyer.getAccount();
                            String bLevel = buyer.getbLevel();
                            Object buyerbLevelAmount = (BuyerLevelAmount)buyerbLevelAmountMap.get(bLevel);
                            if (buyerbLevelAmount == null) {
                                buyerbLevelAmount = new BuyerLevelAmount(bLevel);
                                buyerbLevelAmountMap.put(bLevel, buyerbLevelAmount);
                            }
                            List<Buyer> buyerList = ((BuyerLevelAmount)buyerbLevelAmount).getBuyerList();
                            boolean isIn = false;
                            for (Buyer tmpBuyer : buyerList) {
                                String tmpBuyerAccount = tmpBuyer.getAccount();
                                if (!tmpBuyerAccount.equals(buyerAccount)) continue;
                                isIn = true;
                                break;
                            }
                            if (!isIn) {
                                buyerList.add(buyer);
                            }
                            if ((buyercLevelAmount = (BuyerLevelAmount)buyercLevelAmountMap.get(cLevel = buyer.getcLevel())) == null) {
                                buyercLevelAmount = new BuyerLevelAmount(cLevel);
                                buyercLevelAmountMap.put(cLevel, (BuyerLevelAmount)buyercLevelAmount);
                            }
                            buyerList = ((BuyerLevelAmount)buyercLevelAmount).getBuyerList();
                            isIn = false;
                            for (Buyer tmpBuyer : buyerList) {
                                String tmpBuyerAccount = tmpBuyer.getAccount();
                                if (!tmpBuyerAccount.equals(buyerAccount)) continue;
                                isIn = true;
                                break;
                            }
                            if (isIn) continue;
                            buyerList.add(buyer);
                        }
                        DefaultCategoryDataset dpd = new DefaultCategoryDataset();
                        Set keySet = buyercLevelAmountMap.keySet();
                        TreeSet treeSet = new TreeSet();
                        treeSet.addAll(keySet);
                        int totalNum = 0;
                        for (String key : treeSet) {
                            BuyerLevelAmount buyerLevelAmount = (BuyerLevelAmount)buyercLevelAmountMap.get(key);
                            int num = buyerLevelAmount.getBuyerList().size();
                            totalNum += num;
                            String levelName = LEVEL_MAP.get(buyerLevelAmount.getLevel());
                            dpd.addValue((double)num, (Comparable)((Object)""), (Comparable)((Object)levelName));
                        }
                        chart = ChartFactory.createBarChart((String)(String.valueOf(ProductParseIframe.this.currentDateRange) + "\u4e70\u5bb6\u5fc3\u7ea7\u6bd4\u4f8b (\u5171" + totalNum + "\u4e2a)"), (String)"\u7ea7\u522b", (String)"\u4eba\u6570", (CategoryDataset)dpd, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                        ChartPanel bCharPanel = new ChartPanel(chart);
                        CategoryPlot categoryPlot = chart.getCategoryPlot();
                        BarRenderer render = (BarRenderer)categoryPlot.getRenderer();
                        render.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                        render.setBaseItemLabelsVisible(true);
                        dpd = new DefaultCategoryDataset();
                        keySet = buyerbLevelAmountMap.keySet();
                        treeSet = new TreeSet();
                        treeSet.addAll(keySet);
                        totalNum = 0;
                        buyercLevelAmount = treeSet.iterator();
                        while (buyercLevelAmount.hasNext()) {
                            String key = (String)buyercLevelAmount.next();
                            BuyerLevelAmount buyerLevelAmount = (BuyerLevelAmount)buyerbLevelAmountMap.get(key);
                            int num = buyerLevelAmount.getBuyerList().size();
                            totalNum += num;
                            dpd.addValue((double)num, (Comparable)((Object)""), (Comparable)((Object)buyerLevelAmount.getLevel()));
                        }
                        chart = ChartFactory.createBarChart((String)(String.valueOf(ProductParseIframe.this.currentDateRange) + "\u4e70\u5bb6V\u7ea7\u6bd4\u4f8b (\u5171" + totalNum + "\u4e2a)"), (String)"\u7ea7\u522b", (String)"\u4eba\u6570", (CategoryDataset)dpd, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
                        ChartPanel cChartPanel = new ChartPanel(chart);
                        categoryPlot = chart.getCategoryPlot();
                        render = (BarRenderer)categoryPlot.getRenderer();
                        render.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
                        render.setBaseItemLabelsVisible(true);
                        YoxPanel panel = new YoxPanel();
                        panel.setLayout(new GridLayout(1, 2));
                        panel.add((Component)cChartPanel);
                        panel.add((Component)bCharPanel);
                        YoxLabel label = new YoxLabel();
                        label.setHorizontalAlignment(0);
                        label.setFont(new Font("\u9ed1\u4f53", 0, 15));
                        label.setText("\u8bf4\u660e : \u7531\u4e8e\u8d26\u53f7\u52a0\u5bc6\u540e\u53ef\u80fd\u91cd\u540d,\u6545\u53ef\u80fd\u4f1a\u5bfc\u81f4V\u7ea7\u6bd4\u4f8b\u548c\u5fc3\u7ea7\u6bd4\u4f8b\u603b\u6570\u7565\u6709\u51fa\u5165");
                        ProductParseIframe.this.chartPanel.removeAll();
                        ProductParseIframe.this.chartPanel.add((Component)panel, "Center");
                        ProductParseIframe.this.chartPanel.add((Component)label, "South");
                        ProductParseIframe.this.chartPanel.updateUI();
                    } else if (ProductParseIframe.this.currentChartType == CHART_TYPE_ASSESS_PARSE) {
                        YoxPanel panel = new YoxPanel();
                        panel.setLayout(new BorderLayout());
                        YoxToolBar toolBar = new YoxToolBar();
                        toolBar.setLayout(new FlowLayout());
                        YoxLabel label = new YoxLabel("\u8f93\u5165\u5173\u952e\u5b57");
                        toolBar.add(label);
                        final YoxTextField keywordTf = new YoxTextField("");
                        keywordTf.setPreferredSize(new Dimension(500, 28));
                        toolBar.add(keywordTf);
                        label = new YoxLabel("\uff08\u591a\u4e2a\u4ee5\u7a7a\u683c\u5206\u9694\uff09");
                        toolBar.add(label);
                        YoxButton bt = new YoxButton("\u7edf\u8ba1");
                        toolBar.add(bt);
                        ProductParseIframe.this.rateNumLabel = new YoxLabel();
                        ProductParseIframe.this.rateNumLabel.setPreferredSize(new Dimension(100, 25));
                        toolBar.add(ProductParseIframe.this.rateNumLabel);
                        bt.setPreferredSize(new Dimension(70, 28));
                        final AssessCountTable assessCountListTable = new AssessCountTable(ProductParseIframe.this.me);
                        panel.add((Component)toolBar, "North");
                        panel.add((Component)assessCountListTable.getScPane(), "Center");
                        ProductParseIframe.this.chartPanel.removeAll();
                        ProductParseIframe.this.chartPanel.add((Component)panel, "Center");
                        ProductParseIframe.this.chartPanel.updateUI();
                        keywordTf.selectAll();
                        bt.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                String keywords = keywordTf.getText();
                                if (keywords.trim().equals("")) {
                                    return;
                                }
                                String url = ProductParseIframe.this.productUrlTf.getText().trim();
                                if (url.trim().equals("")) {
                                    return;
                                }
                                String beginDateStr = ProductParseIframe.this.beginDateTf.getText();
                                String endDateStr = ProductParseIframe.this.endDateTf.getText();
                                Date beginDate = null;
                                Date endDate = null;
                                List<Assess> assessList = null;
                                try {
                                    beginDate = C.Y_M_D_DF.parse(beginDateStr);
                                    endDate = C.Y_M_D_DF.parse(endDateStr);
                                    assessList = (this).ProductParseIframe.this.dataStore.getAssessList(url, beginDate, endDate);
                                    ProductParseIframe.this.rateNumLabel.setText("\u8bc4\u4ef7\u603b\u6570\uff1a" + assessList.size());
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                                String[] keywordArr = keywords.split(" ");
                                ArrayList<AssessCount> assessCountList = new ArrayList<AssessCount>();
                                String[] stringArray = keywordArr;
                                int n = keywordArr.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String keyword = stringArray[n2];
                                    if (!keyword.trim().equals("")) {
                                        boolean isExist = false;
                                        for (AssessCount count : assessCountList) {
                                            String existKeyword = count.getKeyword();
                                            if (!existKeyword.equals(keyword)) continue;
                                            isExist = true;
                                        }
                                        if (!isExist) {
                                            AssessCount count;
                                            count = new AssessCount();
                                            count.setKeyword(keyword);
                                            assessCountList.add(count);
                                            for (Assess assess : assessList) {
                                                String content = assess.getContent();
                                                int indexofKeyword = content.indexOf(keyword);
                                                int indexofNoKeyword1 = content.indexOf("\u4e0d" + keyword);
                                                int indexofNoKeyword2 = content.indexOf("\u4e0d\u4f1a" + keyword);
                                                int indexofNoKeyword3 = content.indexOf("\u6ca1" + keyword);
                                                int indexofNoKeyword4 = content.indexOf("\u6ca1\u6709" + keyword);
                                                int indexofNoKeyword5 = content.indexOf("\u6ca1\u53d1\u73b0" + keyword);
                                                if (indexofKeyword == -1 || indexofNoKeyword1 != -1 || indexofNoKeyword2 != -1 || indexofNoKeyword3 != -1 || indexofNoKeyword4 != -1 || indexofNoKeyword5 != -1) continue;
                                                count.setCount(count.getCount() + 1);
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                                assessCountListTable.clear();
                                assessCountListTable.addRow(assessCountList, assessCountList.size());
                            }
                        });
                    }
                    try {
                        Thread.sleep(200L);
                        continue;
                    }
                    catch (InterruptedException e5) {
                        e5.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    @Override
    protected void afterImport(int count) {
    }

    @Override
    public void afterPause() {
    }

    @Override
    public void afterSaveConfig() {
    }

    @Override
    protected void beforeClose() {
    }

    @Override
    protected void beforeGUI() {
        this.dateList = new ArrayList<String>();
    }

    @Override
    public Boolean beforeStart() {
        return null;
    }

    @Override
    public void fireComponent(String flag) {
    }

    @Override
    protected String getImportName() {
        return null;
    }

    @Override
    protected String getImportPrompt() {
        return null;
    }

    @Override
    protected String getImportPromptKey() {
        return null;
    }

    @Override
    protected YoxInfoTable getInfoTable() {
        return null;
    }

    @Override
    protected void initEnableCompList() {
    }

    @Override
    public JComponent initRightTopComp() {
        return null;
    }

    @Override
    protected void initSubGUI() {
        this.toolBar.setPreferredSize(new Dimension(1, 40));
        YoxLabel label = new YoxLabel("\u5355\u54c1\u5730\u5740");
        this.toolBar.add(label);
        this.productUrlTf = new YoxTextField("");
        this.productUrlTf.setPreferredSize(new Dimension(250, 28));
        this.productUrlTf.setMaximumSize(new Dimension(500, 28));
        this.toolBar.add(this.productUrlTf);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        label = new YoxLabel("\u8d77\u6b62\u65f6\u95f4");
        this.toolBar.add(label);
        this.beginDateTf = new YoxTextField("");
        this.beginDateTf.setEditable(false);
        this.beginDateTf.setBackground(Color.WHITE);
        this.beginDateTf.setPreferredSize(new Dimension(75, 28));
        this.beginDateTf.setMaximumSize(new Dimension(75, 28));
        this.toolBar.add(this.beginDateTf);
        label = new YoxLabel("-");
        this.toolBar.add(label);
        this.endDateTf = new YoxTextField("");
        this.endDateTf.setEditable(false);
        this.endDateTf.setBackground(Color.WHITE);
        this.endDateTf.setPreferredSize(new Dimension(75, 28));
        this.endDateTf.setMaximumSize(new Dimension(75, 28));
        this.toolBar.add(this.endDateTf);
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        ButtonGroup dateBtGroup = new ButtonGroup();
        YoxTgButton tgButton = new YoxTgButton("\u672c\u5468");
        tgButton.setFocusable(false);
        dateBtGroup.add(tgButton);
        this.toolBar.add(tgButton);
        tgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar now = Calendar.getInstance();
                ProductParseIframe.this.endDateTf.setText(C.Y_M_D_DF.format(now.getTime()));
                now.add(7, -1);
                now.set(7, 2);
                ProductParseIframe.this.beginDateTf.setText(C.Y_M_D_DF.format(now.getTime()));
                ProductParseIframe.this.currentDateRange = "\u672c\u5468";
                ProductParseIframe.this.dateList.clear();
                while (true) {
                    String dateStr = C.Y_M_D_DF.format(now.getTime());
                    ProductParseIframe.this.dateList.add(dateStr);
                    if (dateStr.equals(ProductParseIframe.this.endDateTf.getText())) break;
                    now.set(5, now.get(5) + 1);
                }
            }
        });
        tgButton = new YoxTgButton("\u8fd17\u5929");
        tgButton.setFocusable(false);
        dateBtGroup.add(tgButton);
        this.toolBar.add(tgButton);
        tgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar now = Calendar.getInstance();
                ProductParseIframe.this.endDateTf.setText(C.Y_M_D_DF.format(now.getTime()));
                now.set(5, now.get(5) - 6);
                ProductParseIframe.this.beginDateTf.setText(C.Y_M_D_DF.format(now.getTime()));
                ProductParseIframe.this.currentDateRange = "\u8fd17\u5929";
                ProductParseIframe.this.dateList.clear();
                while (true) {
                    String dateStr = C.Y_M_D_DF.format(now.getTime());
                    ProductParseIframe.this.dateList.add(dateStr);
                    if (dateStr.equals(ProductParseIframe.this.endDateTf.getText())) break;
                    now.set(5, now.get(5) + 1);
                }
            }
        });
        tgButton = new YoxTgButton("\u672c\u6708");
        tgButton.setFocusable(false);
        dateBtGroup.add(tgButton);
        this.toolBar.add(tgButton);
        tgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar now = Calendar.getInstance();
                ProductParseIframe.this.endDateTf.setText(C.Y_M_D_DF.format(now.getTime()));
                now.set(5, 1);
                ProductParseIframe.this.beginDateTf.setText(C.Y_M_D_DF.format(now.getTime()));
                ProductParseIframe.this.currentDateRange = "\u672c\u6708";
                ProductParseIframe.this.dateList.clear();
                while (true) {
                    String dateStr = C.Y_M_D_DF.format(now.getTime());
                    ProductParseIframe.this.dateList.add(dateStr);
                    if (dateStr.equals(ProductParseIframe.this.endDateTf.getText())) break;
                    now.set(5, now.get(5) + 1);
                }
            }
        });
        tgButton = new YoxTgButton("\u8fd130\u5929");
        tgButton.setFocusable(false);
        dateBtGroup.add(tgButton);
        this.toolBar.add(tgButton);
        tgButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Calendar now = Calendar.getInstance();
                ProductParseIframe.this.endDateTf.setText(C.Y_M_D_DF.format(now.getTime()));
                now.set(5, now.get(5) - 29);
                ProductParseIframe.this.beginDateTf.setText(C.Y_M_D_DF.format(now.getTime()));
                ProductParseIframe.this.currentDateRange = "\u8fd130\u5929";
                ProductParseIframe.this.dateList.clear();
                while (true) {
                    String dateStr = C.Y_M_D_DF.format(now.getTime());
                    ProductParseIframe.this.dateList.add(dateStr);
                    if (dateStr.equals(ProductParseIframe.this.endDateTf.getText())) break;
                    now.set(5, now.get(5) + 1);
                }
            }
        });
        tgButton.doClick();
        this.toolBar.addSeparator();
        this.toolBar.addSeparator();
        this.findButton = new YoxButton("\u67e5\u8be2");
        this.toolBar.add(this.findButton);
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductParseIframe.this.fireChart();
            }
        });
        YoxButton button = new YoxButton("\u5237\u65b0");
        this.toolBar2 = new YoxToolBar();
        this.toolBar2.setPreferredSize(new Dimension(1, 40));
        this.toolBar2.setLayout(new FlowLayout());
        this.mainPanel.add((Component)this.toolBar2, "North");
        YoxPanel dataPanel = new YoxPanel();
        dataPanel.setLayout(new BorderLayout());
        this.mainPanel.add((Component)dataPanel, "Center");
        this.chartPanel = new YoxPanel();
        this.chartPanel.setLayout(new BorderLayout());
        ButtonGroup bg = new ButtonGroup();
        this.soldNoteBt = new YoxTgButton("\u9500\u552e\u8bb0\u5f55");
        bg.add(this.soldNoteBt);
        this.soldNoteBt.setFocusable(false);
        this.toolBar2.add(this.soldNoteBt);
        this.toolBar2.addSeparator();
        this.toolBar2.addSeparator();
        this.soldNoteBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductParseIframe.this.currentChartType = CHART_TYPE_SOLD_NOTE;
                ProductParseIframe.this.fireChart();
            }
        });
        this.salesAmountPathBt = new YoxTgButton("\u9500\u552e\u989d\u8d70\u52bf");
        bg.add(this.salesAmountPathBt);
        this.salesAmountPathBt.setFocusable(false);
        this.toolBar2.add(this.salesAmountPathBt);
        this.toolBar2.addSeparator();
        this.toolBar2.addSeparator();
        this.salesAmountPathBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductParseIframe.this.currentChartType = CHART_TYPE_SALES_AMOUNT_PATH;
                ProductParseIframe.this.fireChart();
            }
        });
        this.salesVolumePathBt = new YoxTgButton("\u9500\u91cf\u8d70\u52bf");
        bg.add(this.salesVolumePathBt);
        this.salesVolumePathBt.setFocusable(false);
        this.toolBar2.add(this.salesVolumePathBt);
        this.toolBar2.addSeparator();
        this.toolBar2.addSeparator();
        this.salesVolumePathBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductParseIframe.this.currentChartType = CHART_TYPE_SALES_VOLUME_PATH;
                ProductParseIframe.this.fireChart();
            }
        });
        this.pricePathBt = new YoxTgButton("\u4ef7\u683c\u8d70\u52bf");
        bg.add(this.pricePathBt);
        this.pricePathBt.setFocusable(false);
        this.toolBar2.add(this.pricePathBt);
        this.toolBar2.addSeparator();
        this.toolBar2.addSeparator();
        this.pricePathBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductParseIframe.this.currentChartType = CHART_TYPE_PRICE_PATH;
                ProductParseIframe.this.fireChart();
            }
        });
        this.skuScaleBt = new YoxTgButton("SKU\u5360\u6bd4");
        bg.add(this.skuScaleBt);
        this.skuScaleBt.setFocusable(false);
        this.toolBar2.add(this.skuScaleBt);
        this.toolBar2.addSeparator();
        this.toolBar2.addSeparator();
        this.skuScaleBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductParseIframe.this.currentChartType = CHART_TYPE_SKU_SCALE;
                ProductParseIframe.this.fireChart();
            }
        });
        this.buyerScaleBt = new YoxTgButton("\u4e70\u5bb6\u7ea7\u522b\u5360\u6bd4");
        bg.add(this.buyerScaleBt);
        this.buyerScaleBt.setFocusable(false);
        this.toolBar2.add(this.buyerScaleBt);
        this.toolBar2.addSeparator();
        this.toolBar2.addSeparator();
        this.buyerScaleBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductParseIframe.this.currentChartType = CHART_TYPE_BUYER_SCALE;
                ProductParseIframe.this.fireChart();
            }
        });
        this.assessParseBt = new YoxTgButton("\u8bc4\u4ef7\u5206\u6790");
        bg.add(this.assessParseBt);
        this.assessParseBt.setFocusable(false);
        this.toolBar2.add(this.assessParseBt);
        this.assessParseBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductParseIframe.this.currentChartType = CHART_TYPE_ASSESS_PARSE;
                ProductParseIframe.this.fireChart();
            }
        });
        YoxPanel toolBar34Panel = new YoxPanel();
        YoxToolBar toolBar3 = new YoxToolBar();
        toolBar3.setLayout(new FlowLayout());
        this.productNameLabel = new YoxButton();
        this.productNameLabel.setCursor(Cursor.getPredefinedCursor(12));
        this.productNameLabel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String url = ProductParseIframe.this.productUrlTf.getText();
                    if (url.equals("") || !url.startsWith("http")) {
                        return;
                    }
                    Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.productNameLabel.setBorderPainted(false);
        this.productNameLabel.setFont(new Font("\u9ed1\u4f53", 0, 20));
        this.productNameLabel.setHorizontalAlignment(0);
        toolBar34Panel.setLayout(new GridLayout(2, 1));
        toolBar34Panel.add(this.productNameLabel);
        toolBar34Panel.add(toolBar3);
        dataPanel.add((Component)toolBar34Panel, "North");
        this.totalOrderLabel = new YoxLabel("\u603b\u8ba2\u5355\u91cf:");
        this.totalOrderLabel.setFont(new Font("\u5b8b\u4f53", 0, 12));
        toolBar3.add(this.totalOrderLabel);
        toolBar3.addSeparator();
        this.currentOrderLabel = new YoxLabel(String.valueOf(this.currentDateRange) + "\u8ba2\u5355\u91cf:");
        this.currentOrderLabel.setFont(new Font("\u5b8b\u4f53", 0, 12));
        toolBar3.add(this.currentOrderLabel);
        toolBar3.addSeparator();
        this.totalAmountLabel = new YoxLabel("\u603b\u9500\u552e\u989d:");
        this.totalAmountLabel.setFont(new Font("\u5b8b\u4f53", 0, 12));
        this.currentAmountLabel = new YoxLabel(String.valueOf(this.currentDateRange) + "\u9500\u552e\u989d:");
        this.currentAmountLabel.setFont(new Font("\u5b8b\u4f53", 0, 12));
        toolBar3.add(this.currentAmountLabel);
        toolBar3.addSeparator();
        this.pullOffTimeLabel = new YoxLabel("\u4e0b\u67b6\u65f6\u95f4:[]");
        this.pullOffTimeLabel.setFont(new Font("\u5b8b\u4f53", 0, 12));
        toolBar3.add(this.pullOffTimeLabel);
        toolBar3.addSeparator();
        this.publicTimeLabel = new YoxLabel("\u53d1\u5e03\u65f6\u95f4:[]");
        this.publicTimeLabel.setFont(new Font("\u5b8b\u4f53", 0, 12));
        toolBar3.add(this.publicTimeLabel);
        dataPanel.add((Component)this.chartPanel, "Center");
        this.bottomPane.setVisible(true);
        this.bottomPane.removeAll();
        this.logArea = new YoxTextArea();
        this.logArea.setEditable(false);
        this.logArea.setBackground(new Color(239, 238, 234));
        this.bottomPane.add(this.logArea);
        this.soldNoteBt.doClick();
    }

    @Override
    public void log(String str) {
        this.logArea.setText("");
        this.logArea.setText(str);
    }

    protected void fireChart() {
        String url = this.productUrlTf.getText().trim();
        if (url.equals("")) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        int i = RED_COLOR_ARR.length - 1;
                        while (i >= 0) {
                            ProductParseIframe.this.productUrlTf.setBackground(new Color(RED_COLOR_ARR[i]));
                            Thread.sleep(50L);
                            --i;
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            this.productUrlTf.selectAll();
            return;
        }
        this.dataStore = DATA_STORE_MAP.get(url);
        String beginDateStr = this.beginDateTf.getText();
        String endDateStr = this.endDateTf.getText();
        Date beginDate = null;
        Date endDate = null;
        try {
            beginDate = C.Y_M_D_DF.parse(beginDateStr);
            endDate = C.Y_M_D_DF.parse(endDateStr);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        if (this.dataStore == null) {
            try {
                String s = "com.coyousoft.yoxproductparse.datastore.impl.TaobaoProductDataStore";
                Class<?> clazz = C.loader.loadRemoteClass(s);
                Constructor<?> constructor = clazz.getConstructors()[0];
                this.dataStore = (DataStore)constructor.newInstance(this.me, this.soldNoteList, url, beginDate, endDate);
                DATA_STORE_MAP.put(url, this.dataStore);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.me, "\u52a0\u8f7d\u8d44\u6e90\u5931\u8d25,\u5c1d\u8bd5\u91cd\u542f\u8f6f\u4ef6");
                return;
            }
        } else {
            this.dataStore.setBeginDate(beginDate);
            this.dataStore.setEndDate(endDate);
        }
        this.soldNoteList.clear();
        DataStoreTask task = new DataStoreTask(this.dataStore);
        this.pool.putTask((Task)task);
    }

    @Override
    protected boolean isShowCodeSuite() {
        return false;
    }

    @Override
    protected boolean isShowConfigBt() {
        return false;
    }

    @Override
    protected boolean isShowImportBt() {
        return false;
    }

    @Override
    protected boolean isTaskOver(boolean isInterrupt) {
        return false;
    }

    @Override
    public void removeTask() {
    }

    private String getWeek(Date date) {
        String value = "";
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int dayOfWeek = c.get(7);
        if (dayOfWeek == 1) {
            value = "\u65e5";
        }
        if (dayOfWeek == 2) {
            value = "\u4e00";
        }
        if (dayOfWeek == 3) {
            value = "\u4e8c";
        }
        if (dayOfWeek == 4) {
            value = "\u4e09";
        }
        if (dayOfWeek == 5) {
            value = "\u56db";
        }
        if (dayOfWeek == 6) {
            value = "\u4e94";
        }
        if (dayOfWeek == 7) {
            value = "\u516d";
        }
        return value;
    }

    private void setLineChartNode(JFreeChart chart) {
        CategoryPlot categoryPlot = chart.getCategoryPlot();
        LineAndShapeRenderer lineandshaperenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineandshaperenderer.setBaseShapesVisible(true);
        lineandshaperenderer.setBaseLinesVisible(true);
        lineandshaperenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        lineandshaperenderer.setBaseItemLabelsVisible(true);
    }

    public boolean isLoadingData() {
        return this.isLoadingData;
    }

    public void setIsLoadingData(boolean isLoadingData) {
        this.isLoadingData = isLoadingData;
    }

    private void setBtFreeze(boolean b) {
        this.findButton.setEnabled(b);
        this.toolBar2.setEnabled(b);
        this.soldNoteBt.setEnabled(b);
        this.salesAmountPathBt.setEnabled(b);
        this.salesVolumePathBt.setEnabled(b);
        this.pricePathBt.setEnabled(b);
        this.skuScaleBt.setEnabled(b);
        this.buyerScaleBt.setEnabled(b);
        this.assessParseBt.setEnabled(b);
    }
}

