/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.worker;

import com.coyousoft.yox.gui.YoxIframe;
import com.coyousoft.yox.support.LineNumberConfigReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Maker {
    protected Map<String, Object> paramMap = null;
    protected YoxIframe iframe = null;
    private static final int BATCH_COUNT = 30;
    private static final int CACHE_SIZE = 100;
    protected static final Map<String, List<Object>> CACHE_DATA_LIST_MAP = new HashMap<String, List<Object>>();
    protected static final Map<String, Boolean> ON_LOADING_FLAG_MAP = new HashMap<String, Boolean>();

    public Maker(Map<String, Object> paramMap, YoxIframe iframe) {
        this.paramMap = paramMap;
        this.iframe = iframe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData() throws Exception {
        String className = this.getClass().getName();
        List<Object> cacheDataList = null;
        Boolean isOnLoading = false;
        Map<String, List<Object>> map = CACHE_DATA_LIST_MAP;
        synchronized (map) {
            cacheDataList = CACHE_DATA_LIST_MAP.get(className);
            if (cacheDataList == null) {
                cacheDataList = Collections.synchronizedList(new ArrayList());
                CACHE_DATA_LIST_MAP.put(className, cacheDataList);
            }
        }
        if (cacheDataList.size() <= 50) {
            try {
                ON_LOADING_FLAG_MAP.put(className, isOnLoading);
                List<Object> list = this.loadData();
                if (list != null) {
                    cacheDataList.addAll(list);
                }
            }
            finally {
                ON_LOADING_FLAG_MAP.put(className, isOnLoading);
            }
            if (cacheDataList.size() > 0) {
                return cacheDataList.remove(0);
            }
            this.iframe.log("cacheDataList\u662f\u7a7a\u7684");
            return null;
        }
        return cacheDataList.remove(0);
    }

    protected abstract List<Object> loadData() throws Exception;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Object> loadDataFromFile(String filePath) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        int lastLineNumber = this.iframe.getLastLineNumber();
        if (lastLineNumber == -1) {
            return list;
        }
        int lineCount = 0;
        FileInputStream fileInputStream = null;
        InputStreamReader inReader = null;
        BufferedReader lnReader = null;
        try {
            File file = new File(filePath);
            fileInputStream = new FileInputStream(file);
            inReader = new InputStreamReader((InputStream)fileInputStream, "GBK");
            lnReader = new LineNumberConfigReader(inReader);
            ((LineNumberReader)lnReader).setLineNumber(lastLineNumber);
            String line = null;
            while ((line = ((LineNumberReader)lnReader).readLine()) != null && lineCount < 30) {
                this.iframe.addLineNumber(++lastLineNumber);
                Object o = this.convertString(line);
                if (o == null) {
                    this.iframe.saveLineNumber();
                    continue;
                }
                list.add(o);
            }
        }
        finally {
            lnReader.close();
            inReader.close();
            fileInputStream.close();
        }
        if (this.isReUseData()) {
            this.iframe.setLastLineNumber(0);
        }
        return list;
    }

    protected boolean isReUseData() {
        return false;
    }

    protected abstract Object convertString(String var1);
}

