/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.thread;

import com.coyousoft.yox.gui.YoxIframe;
import com.coyousoft.yox.gui.YoxThreadButton;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.threadpool.ThreadPool;

public abstract class YoxThread
extends Thread {
    protected Log log = LogFactory.getLog(this.getClass());
    private Boolean isWorking = null;
    private Boolean isPause = null;
    protected Boolean isTest = false;
    protected YoxThreadButton yoxThreadButton;
    protected YoxIframe iframe;
    protected Map<String, Object> cfgMap;
    protected Map<String, Object> paramMap;
    protected ThreadPool makePool;
    protected ThreadPool sendPool;
    protected ThreadPool savePool;
    private int i = 0;
    protected long whileTimes = 0L;

    public YoxThread() {
    }

    public YoxThread(Map<String, Object> cfgMap, YoxIframe iframe) {
        this.cfgMap = cfgMap;
        this.iframe = iframe;
        this.makePool = iframe.getMakePool();
        this.sendPool = iframe.getSendPool();
        this.savePool = iframe.getSavePool();
    }

    public abstract void work() throws Exception;

    public abstract void beforeExit();

    public void beforeWork() {
    }

    public void afterPause() {
    }

    @Override
    public void run() {
        this.beforeWork();
        this.isPause = false;
        this.isWorking = true;
        while (this.isWorking != null && this.isWorking().booleanValue()) {
            if (this.cfgMap != null) {
                Integer beginHour = (Integer)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_BEGIN_HOUR");
                Integer endHour = (Integer)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_END_HOUR");
                Calendar systemC = Calendar.getInstance(TimeZone.getTimeZone("GMT+8"));
                int sysHour = systemC.get(11);
                boolean isSleep = false;
                if (beginHour < endHour) {
                    if (sysHour < beginHour || sysHour >= endHour) {
                        isSleep = true;
                    }
                } else if (sysHour < beginHour && sysHour >= endHour) {
                    isSleep = true;
                }
                if (isSleep) {
                    this.iframe.log("\u5f53\u524d\u65f6\u95f4\u4e0d\u5728\u5de5\u4f5c\u65f6\u6bb5(" + beginHour + "-" + endHour + ")\u5185,\u4f11\u7720\u4e2d...");
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
            }
            if (this.whileTimes == Long.MAX_VALUE) {
                this.whileTimes = 0L;
            }
            ++this.whileTimes;
            while (this.isPause().booleanValue()) {
                try {
                    this.afterPause();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            try {
                if (this.iframe != null) {
                    this.iframe.improveThreadNum(this.iframe.getCfgThreadNum());
                    this.paramMap = new HashMap<String, Object>();
                    this.paramMap.putAll(this.cfgMap);
                    this.paramMap.put("IS_INPUT_CODE", this.iframe.isInputCode());
                    this.paramMap.put("CODE_TIME_OUT", 90000);
                }
                this.work();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            while (this.isPause().booleanValue()) {
                try {
                    this.afterPause();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.isWorking != null && !this.isWorking().booleanValue()) break;
            if (this.iframe != null) {
                try {
                    this.reIp();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!this.isTest.booleanValue()) continue;
            this.isWorking = null;
            this.isPause = null;
        }
        this.beforeExit();
    }

    private void reIp() throws Exception {
        int nIp = this.iframe.getNIp();
        if (nIp == 0) {
            return;
        }
        ++this.i;
        if (this.i >= nIp && nIp != 0) {
            this.iframe.log("\u914d\u7f6e\u4e86" + nIp + "\u4e2a\u6362IP,\u7b49\u5f85\u4efb\u52a1\u7ed3\u675f...");
            this.iframe.waitTaskOver(false);
            this.doReIp();
            this.i = 0;
        }
    }

    protected void doReIp() throws Exception {
    }

    public void setWorking(Boolean isWorking) {
        this.isWorking = isWorking;
    }

    public Boolean isWorking() {
        return this.isWorking;
    }

    public void pause() {
        this.setPause(true);
    }

    public void continuee() {
        this.setPause(false);
    }

    public void exit() {
        this.setWorking(false);
    }

    public void setPause(Boolean isPause) {
        this.isPause = isPause;
    }

    public Boolean isPause() {
        return this.isPause;
    }

    public void setButton(YoxThreadButton yoxThreadButton) {
        this.yoxThreadButton = yoxThreadButton;
    }
}

