/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.support;

import com.coyousoft.httputil.HttpUtil;
import com.coyousoft.yox.constant.C;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;

public class YoxClassLoader
extends ClassLoader {
    private static final Object LOCK = new Object();
    private String remoteUrl = null;
    private String classPath = null;

    public YoxClassLoader(String remoteUrl, String classPath) {
        this.remoteUrl = remoteUrl;
        classPath = classPath.replaceAll("\\.", "/");
        if (!classPath.endsWith("/")) {
            classPath = String.valueOf(classPath) + "/";
        }
        this.classPath = classPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> loadRemoteClass(String mmFullName) throws Exception {
        Object object = LOCK;
        synchronized (object) {
            Class<?> mmInMem = this.findLoadedClass(mmFullName);
            if (mmInMem != null) {
                return mmInMem;
            }
            String[] mmNameArr = mmFullName.split("\\.");
            String mmName = mmNameArr[mmNameArr.length - 1];
            byte[] b = null;
            Class<?> clazz = null;
            try {
                b = HttpUtil.getRemoteByteArr(this.remoteUrl, mmName, C.gift);
                clazz = this.defineClass(mmFullName, b, 0, b.length);
            }
            catch (Exception e) {
                try {
                    b = HttpUtil.getRemoteByteArr(this.remoteUrl, mmName, C.gift);
                    clazz = this.defineClass(mmFullName, b, 0, b.length);
                }
                catch (Exception e1) {
                    b = HttpUtil.getRemoteByteArr(this.remoteUrl, mmName, C.gift);
                    clazz = this.defineClass(mmFullName, b, 0, b.length);
                }
            }
            return clazz;
        }
    }

    public Object invokeRemoteMethod(String mmFullName, String methodName, Class<?>[] paramClasses, Object[] params) throws Exception {
        Class<?> clazz = this.loadRemoteClass(mmFullName);
        Method method = clazz.getMethod(methodName, paramClasses);
        return method.invoke(clazz, params);
    }

    public URL getResourceUrl(String resourceName) {
        return ClassLoader.getSystemResource(String.valueOf(this.classPath) + resourceName);
    }

    public URL getResourceUrlByClassPath(String classPath) {
        return ClassLoader.getSystemResource(classPath);
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public static void main(String[] args) throws IOException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getClassPath() {
        return this.classPath;
    }
}

