/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.Document;

public class YoxTextField
extends JTextField
implements MouseListener {
    private static final long serialVersionUID = 1L;
    private JPopupMenu pop = null;
    private JMenuItem copy = null;
    private JMenuItem paste = null;
    private JMenuItem cut = null;

    public YoxTextField(Document document, String text, int column) {
        super(document, text, column);
        this.init();
    }

    public YoxTextField(String text) {
        super(text);
        this.init();
    }

    public YoxTextField() {
        this.init();
    }

    private void init() {
        this.addMouseListener(this);
        this.pop = new JPopupMenu();
        this.copy = new JMenuItem("\u590d\u5236");
        this.pop.add(this.copy);
        this.paste = new JMenuItem("\u7c98\u8d34");
        this.pop.add(this.paste);
        this.cut = new JMenuItem("\u526a\u5207");
        this.pop.add(this.cut);
        this.copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YoxTextField.this.action(e);
            }
        });
        this.paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YoxTextField.this.action(e);
            }
        });
        this.cut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YoxTextField.this.action(e);
            }
        });
        this.add(this.pop);
    }

    public void action(ActionEvent e) {
        String str = e.getActionCommand();
        if (str.equals(this.copy.getText())) {
            this.copy();
        } else if (str.equals(this.paste.getText())) {
            this.paste();
        } else if (str.equals(this.cut.getText())) {
            this.cut();
        }
    }

    public JPopupMenu getPop() {
        return this.pop;
    }

    public void setPop(JPopupMenu pop) {
        this.pop = pop;
    }

    public boolean isClipboardString() {
        boolean b = false;
        Clipboard clipboard = this.getToolkit().getSystemClipboard();
        Transferable content = clipboard.getContents(this);
        try {
            if (content.getTransferData(DataFlavor.stringFlavor) instanceof String) {
                b = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }

    public boolean isCanCopy() {
        int end;
        boolean b = false;
        int start = this.getSelectionStart();
        if (start != (end = this.getSelectionEnd())) {
            b = true;
        }
        return b;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 3) {
            this.copy.setEnabled(this.isCanCopy());
            this.paste.setEnabled(this.isClipboardString());
            this.cut.setEnabled(this.isCanCopy());
            this.pop.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

