/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.gui;

import com.coyousoft.yox.gui.YoxDialog;
import com.coyousoft.yox.gui.YoxIframe;
import com.coyousoft.yox.gui.YoxListTableModel;
import com.coyousoft.yox.gui.YoxPanel;
import com.coyousoft.yox.gui.YoxScrollPane;
import com.coyousoft.yox.gui.YoxTable;
import com.coyousoft.yox.gui.YoxTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableColumn;

public abstract class YoxListTable<T>
extends YoxTable {
    private static final long serialVersionUID = 1L;
    protected List<T> dataList = null;
    private Map<Integer, T> dataMap = null;
    protected YoxScrollPane scPane;
    protected YoxIframe iframe;
    private Boolean isCanBeClean;

    public YoxListTable(String[] columns, YoxIframe iframe, Boolean isCanBeClean) {
        super(new YoxListTableModel(columns));
        this.iframe = iframe;
        this.isCanBeClean = isCanBeClean;
        this.dataList = (List)this.tableModel.getDataStore();
        this.setDataMap(((YoxListTableModel)this.tableModel).getDataMap());
        ((YoxListTableModel)this.tableModel).setTable(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    YoxListTable.this.openTableRow();
                }
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isControlDown() && 67 == e.getKeyCode()) {
                    e.consume();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.scPane = new YoxScrollPane();
        this.scPane.setViewportView(this);
    }

    protected void openTableRow() {
        YoxDialog dlg = new YoxDialog(this.iframe.getMainFace(), "\u67e5\u770b", false);
        dlg.setSize(this.getOpenTableRowDlgDim());
        YoxPanel panel = new YoxPanel();
        List<T> list = this.getSelectedList();
        if (list == null || list.size() <= 0) {
            return;
        }
        String[] arr = list.get(0).toString().split("\u3000\u2460\u3012\u00e5");
        panel.setLayout(new GridLayout(arr.length, 1));
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            YoxTextField tf = new YoxTextField(str);
            tf.setBackground(Color.WHITE);
            tf.setEditable(false);
            panel.add(tf);
            ++n2;
        }
        dlg.setLayout(new BorderLayout());
        dlg.add((Component)panel, "Center");
        dlg.setDefaultCloseOperation(2);
        dlg.setLocationRelativeTo(this.scPane);
        dlg.setVisible(true);
    }

    protected abstract Dimension getOpenTableRowDlgDim();

    @Override
    public void setFirstColumnSize() {
        TableColumn firsetColumn = this.getColumnModel().getColumn(0);
        firsetColumn.setPreferredWidth(55);
        firsetColumn.setMaxWidth(60);
        firsetColumn.setMinWidth(10);
    }

    public void addRow(T t) {
        this.addRow(t, false);
    }

    public void addRow(T t, boolean isAppend) {
        if (isAppend) {
            this.getDataList().add(t);
        } else {
            this.getDataList().add(0, t);
        }
        this.tableModel.addTotalDataCount();
        this.fireTableDataChanged();
        this.afterFire();
    }

    public void addRow(List<T> list, int dataCount) {
        this.getDataList().addAll(0, list);
        this.tableModel.setTotalDataCount(dataCount);
        this.fireTableDataChanged();
        this.afterFire();
    }

    public void clear() {
        this.getDataList().clear();
        this.getDataMap().clear();
        this.fireTableDataChanged();
    }

    private void afterFire() {
        if (!this.isCanBeClean.booleanValue()) {
            return;
        }
        if (this.getDataList().size() > this.getMaxRowCount()) {
            this.getDataList().clear();
            if (this.getDataMap() != null) {
                this.getDataMap().clear();
            }
        }
    }

    protected int getMaxRowCount() {
        return 3000;
    }

    public List<T> getSelectedList() {
        int[] indexes;
        ArrayList<T> selectedList = new ArrayList<T>();
        int[] nArray = indexes = this.getSelectedRows();
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            Integer index = (Integer)this.getValueAt((T)i, 0);
            selectedList.add(this.dataMap.get(index));
            ++n2;
        }
        return selectedList;
    }

    public void hideColumn(int columnIndex) {
        TableColumn tc = this.getColumnModel().getColumn(columnIndex);
        tc.setMinWidth(0);
        tc.setMaxWidth(0);
    }

    public void showColumn(int columnIndex) {
        TableColumn tc = this.getColumnModel().getColumn(columnIndex);
        tc.setMaxWidth(50);
        tc.setMinWidth(50);
    }

    public List<T> getDataList() {
        return this.dataList;
    }

    public abstract Object getValueAt(T var1, int var2);

    public YoxScrollPane getScPane() {
        return this.scPane;
    }

    public void cleanTotalDataCount() {
        this.tableModel.setTotalDataCount(0);
    }

    public void setDataMap(Map<Integer, T> dataMap) {
        this.dataMap = dataMap;
    }

    public Map<Integer, T> getDataMap() {
        return this.dataMap;
    }
}

