/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.gui;

import com.coyousoft.yox.constant.C;
import com.coyousoft.yox.gui.YoxIframe;
import com.coyousoft.yox.gui.YoxInfoTableModel;
import com.coyousoft.yox.gui.YoxTable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Date;
import java.util.Map;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public abstract class YoxInfoTable
extends YoxTable {
    private static final long serialVersionUID = 1L;
    protected int row;
    protected int column;
    protected Map<String, Object> cfgMap = null;
    protected YoxIframe iframe;

    public YoxInfoTable(String[] columns, Map<String, Object> cfgMap, YoxIframe iframe) {
        super(new YoxInfoTableModel(columns));
        ((YoxInfoTableModel)this.tableModel).setTable(this);
        this.iframe = iframe;
        this.cfgMap = cfgMap;
        final YoxInfoTable t = this;
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                Object tip;
                Point point = e.getPoint();
                int x = t.rowAtPoint(point);
                int y = t.columnAtPoint(point);
                if (x != YoxInfoTable.this.row || y != YoxInfoTable.this.column) {
                    YoxInfoTable.this.row = x;
                }
                if ((tip = t.getValueAt(YoxInfoTable.this.row, 1)) != null) {
                    t.setToolTipText(tip.toString());
                }
            }
        });
    }

    @Override
    public void setFirstColumnSize() {
        TableColumn firsetColumn = this.getColumnModel().getColumn(0);
        firsetColumn.setPreferredWidth(83);
        firsetColumn.setMaxWidth(100);
        firsetColumn.setMinWidth(20);
    }

    @Override
    public void dealHeader() {
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setPreferredSize(new Dimension(0, 0));
        this.getTableHeader().setDefaultRenderer(renderer);
        this.setRowHeight(20);
        this.setGridColor(new Color(255, 255, 255));
    }

    public abstract Object getValueAt(int var1);

    public void setCfgMap(Map<String, Object> cfgMap) {
        this.cfgMap = cfgMap;
        this.fireTableDataChanged();
    }

    public Map<String, Object> getCfgMap() {
        return this.cfgMap;
    }

    public String getBeginTime() {
        Date beginTime = (Date)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_" + "BEGIN_TIME");
        if (beginTime == null) {
            return "\u672a\u5f00\u59cb";
        }
        return C.M_DF.format(beginTime);
    }

    public String getRunTimes() {
        Date beginDate = (Date)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_" + "BEGIN_TIME");
        if (beginDate == null) {
            return "0 \u65f6 0 \u5206 0 \u79d2";
        }
        Long now = System.currentTimeMillis();
        Long beginTime = beginDate.getTime();
        Long ms = now - beginTime;
        this.cfgMap.put(String.valueOf(this.iframe.getKeyPrefix()) + "_" + "RUN_MS", ms);
        long hour = ms / 3600000L;
        long min = ms / 60000L - hour * 60L;
        long s = ms / 1000L - hour * 60L * 60L - min * 60L;
        return String.valueOf(hour) + " \u65f6 " + min + " \u5206 " + s + " \u79d2";
    }

    public Long getSucceedSpeed() {
        long speed = 0L;
        Long runMs = (Long)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_" + "RUN_MS");
        if (runMs != null && this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_SUCCEED_NUM") != null) {
            long second = runMs / 1000L;
            if (second == 0L) {
                second = 1L;
            }
            long tmp = (Long)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_SUCCEED_NUM") * 3600L;
            speed = tmp / second;
        }
        return speed;
    }

    public Long getTotalSpeed() {
        Long failedNum;
        long speed = 0L;
        Long runMs = (Long)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_" + "RUN_MS");
        Long succeedNum = (Long)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_SUCCEED_NUM");
        if (succeedNum == null) {
            succeedNum = 0L;
        }
        if ((failedNum = (Long)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_FAILED_NUM")) == null) {
            failedNum = 0L;
        }
        if (runMs != null) {
            long second = runMs / 1000L;
            if (second == 0L) {
                second = 1L;
            }
            long tmp = (succeedNum + failedNum) * 3600L;
            speed = tmp / second;
        }
        return speed;
    }

    public Integer getThreadNum() {
        Integer threadNum = (Integer)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_THREAD_NUM");
        if (threadNum == null) {
            return 0;
        }
        return threadNum;
    }

    public Long getSucceedNum() {
        Long score = (Long)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_SUCCEED_NUM");
        return score == null ? 0L : score;
    }

    public Long getFailedNum() {
        Long score = (Long)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_FAILED_NUM");
        return score == null ? 0L : score;
    }

    public Integer getSpaceTime() {
        return (Integer)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_SPACE_TIME");
    }

    public Integer getNIp() {
        return (Integer)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_N_IP");
    }

    public Boolean isInputCode() {
        return (Boolean)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_IS_INPUT_CODE");
    }

    public Integer getBeginHour() {
        return (Integer)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_BEGIN_HOUR");
    }

    public Integer getEndHour() {
        return (Integer)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_END_HOUR");
    }

    public String getCloudUrl() {
        return (String)this.cfgMap.get(String.valueOf(this.iframe.getKeyPrefix()) + "_CLOUD_URL");
    }
}

