/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.gui;

import com.coyousoft.yox.gui.YoxButton;
import com.coyousoft.yox.gui.YoxDialog;
import com.coyousoft.yox.gui.YoxFrame;
import com.coyousoft.yox.gui.YoxIframe;
import com.coyousoft.yox.gui.YoxPanel;
import com.coyousoft.yox.gui.YoxTextField;
import com.coyousoft.yox.gui.YoxToolBar;
import com.coyousoft.yox.support.NumberOnlyDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;

public abstract class YoxConfigDialog
extends YoxDialog {
    private static final long serialVersionUID = 1L;
    protected YoxConfigDialog me;
    protected YoxFrame mainFace;
    protected YoxIframe iframe;
    protected YoxPanel mainPanel;
    protected Map<String, Object> cfgMap;
    protected YoxTextField cloudUrlTf;
    protected YoxTextField nIpTf;
    protected YoxTextField threadNumTf;
    protected YoxTextField spaceTimeTf;
    protected JCheckBox isInputCodeCbx;
    protected YoxTextField beginHourTf;
    protected YoxTextField endHourTf;
    protected Integer threadNum;
    protected Integer spaceTime;
    protected Integer nIp;
    protected Boolean isInputCode;
    protected Integer beginHour;
    protected Integer endHour;
    protected String cloudUrl;

    public YoxConfigDialog(YoxFrame frame, String title, boolean modal, YoxIframe iframe, Map<String, Object> cfgMap) {
        super(frame, title, modal);
        this.mainFace = frame;
        this.me = this;
        this.iframe = iframe;
        this.cfgMap = cfgMap;
        this.cloudUrl = (String)cfgMap.get(String.valueOf(iframe.getKeyPrefix()) + "_CLOUD_URL");
        this.threadNum = (Integer)cfgMap.get(String.valueOf(iframe.getKeyPrefix()) + "_THREAD_NUM");
        this.spaceTime = (Integer)cfgMap.get(String.valueOf(iframe.getKeyPrefix()) + "_SPACE_TIME");
        this.nIp = (Integer)cfgMap.get(String.valueOf(iframe.getKeyPrefix()) + "_N_IP");
        this.isInputCode = (Boolean)cfgMap.get(String.valueOf(iframe.getKeyPrefix()) + "_IS_INPUT_CODE");
        this.beginHour = (Integer)cfgMap.get(String.valueOf(iframe.getKeyPrefix()) + "_BEGIN_HOUR");
        this.endHour = (Integer)cfgMap.get(String.valueOf(iframe.getKeyPrefix()) + "_END_HOUR");
        this.cloudUrlTf = new YoxTextField(this.cloudUrl);
        this.cloudUrlTf.setPreferredSize(new Dimension(50, 25));
        this.cloudUrlTf.setMaximumSize(new Dimension(50, 25));
        this.threadNumTf = new YoxTextField(new NumberOnlyDocument(), "" + this.threadNum, 0);
        this.threadNumTf.setPreferredSize(new Dimension(50, 25));
        this.threadNumTf.setMaximumSize(new Dimension(50, 25));
        this.spaceTimeTf = new YoxTextField(new NumberOnlyDocument(), "" + this.spaceTime, 0);
        this.spaceTimeTf.setPreferredSize(new Dimension(50, 25));
        this.spaceTimeTf.setMaximumSize(new Dimension(50, 25));
        this.nIpTf = new YoxTextField(new NumberOnlyDocument(), "" + this.nIp, 0);
        this.nIpTf.setPreferredSize(new Dimension(50, 25));
        this.nIpTf.setMaximumSize(new Dimension(50, 25));
        this.isInputCodeCbx = new JCheckBox("\u6253\u7801");
        this.isInputCodeCbx.setSelected(this.isInputCode);
        this.isInputCodeCbx.setPreferredSize(new Dimension(50, 25));
        this.isInputCodeCbx.setMaximumSize(new Dimension(50, 25));
        this.beginHourTf = new YoxTextField(new NumberOnlyDocument(), "" + this.beginHour, 0);
        this.beginHourTf.setPreferredSize(new Dimension(50, 25));
        this.beginHourTf.setMaximumSize(new Dimension(50, 25));
        this.endHourTf = new YoxTextField(new NumberOnlyDocument(), "" + this.endHour, 0);
        this.endHourTf.setPreferredSize(new Dimension(50, 25));
        this.endHourTf.setMaximumSize(new Dimension(50, 25));
        this.beforeGUI();
        this.initGUI();
        this.setDefaultCloseOperation(2);
    }

    protected abstract void beforeGUI();

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.mainPanel = new YoxPanel();
        this.mainPanel.setBackground(Color.WHITE);
        this.add((Component)this.mainPanel, "Center");
        YoxToolBar toolbar = new YoxToolBar();
        toolbar.setBackground(Color.WHITE);
        toolbar.setSize(new Dimension(100, 32));
        toolbar.setLayout(new FlowLayout());
        this.add((Component)toolbar, "South");
        YoxButton okBt = new YoxButton("\u786e\u5b9a");
        toolbar.add(okBt);
        toolbar.addSeparator(new Dimension(50, 1));
        YoxButton closeBt = new YoxButton("\u5173\u95ed");
        toolbar.add(closeBt);
        okBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!YoxConfigDialog.this.saveConfig()) {
                    return;
                }
                YoxConfigDialog.this.iframe.afterSaveConfig();
                YoxConfigDialog.this.me.dispose();
            }
        });
        closeBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                YoxConfigDialog.this.me.dispose();
            }
        });
        this.initSubGUI();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                YoxConfigDialog.this.afterGUI();
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }
        });
        this.setSize(this.getDim());
        this.setLocationRelativeTo(this.mainFace);
        this.setVisible(true);
    }

    protected boolean saveThreadNum() {
        String threadNum = this.threadNumTf.getText().trim();
        if (threadNum.equals("")) {
            this.threadNumTf.requestFocus();
            JOptionPane.showMessageDialog(this.me, "\u8bf7\u8f93\u5165\u7ebf\u7a0b\u6570");
            return false;
        }
        this.threadNum = Integer.parseInt(threadNum);
        this.iframe.setCfgInteger(String.valueOf(this.iframe.getKeyPrefix()) + "_THREAD_NUM", this.threadNum);
        return true;
    }

    protected boolean saveSpaceTime() {
        String spaceTime = this.spaceTimeTf.getText().trim();
        if (spaceTime.equals("")) {
            this.spaceTimeTf.requestFocus();
            JOptionPane.showMessageDialog(this.me, "\u8bf7\u8f93\u5165\u4efb\u52a1\u95f4\u9694\u65f6\u95f4");
            return false;
        }
        this.spaceTime = Integer.parseInt(spaceTime);
        this.iframe.setCfgInteger(String.valueOf(this.iframe.getKeyPrefix()) + "_SPACE_TIME", this.spaceTime);
        return true;
    }

    protected boolean saveNIp() {
        String nIp = this.nIpTf.getText().trim();
        if (nIp.equals("")) {
            this.nIpTf.requestFocus();
            JOptionPane.showMessageDialog(this.me, "\u8bf7\u8f93\u5165\u6362IP\u4e2a\u6570");
            return false;
        }
        this.nIp = Integer.parseInt(nIp);
        this.iframe.setCfgInteger(String.valueOf(this.iframe.getKeyPrefix()) + "_N_IP", this.nIp);
        return true;
    }

    protected void saveIsInputCode() {
        this.isInputCode = this.isInputCodeCbx.isSelected();
        this.iframe.setCfgBoolean(String.valueOf(this.iframe.getKeyPrefix()) + "_IS_INPUT_CODE", this.isInputCode);
    }

    protected boolean saveBeginHour() {
        String beginHour = this.beginHourTf.getText().trim();
        if (beginHour.equals("")) {
            this.beginHourTf.requestFocus();
            JOptionPane.showMessageDialog(this.me, "\u8bf7\u8f93\u5165\u5f00\u59cb\u65f6\u95f4");
            return false;
        }
        this.beginHour = Integer.parseInt(beginHour);
        this.iframe.setCfgInteger(String.valueOf(this.iframe.getKeyPrefix()) + "_BEGIN_HOUR", this.beginHour);
        return true;
    }

    protected boolean saveEndHour() {
        String endHour = this.endHourTf.getText().trim();
        if (endHour.equals("")) {
            this.endHourTf.requestFocus();
            JOptionPane.showMessageDialog(this.me, "\u8bf7\u8f93\u5165\u7ed3\u675f\u65f6\u95f4");
            return false;
        }
        this.endHour = Integer.parseInt(endHour);
        this.iframe.setCfgInteger(String.valueOf(this.iframe.getKeyPrefix()) + "_END_HOUR", this.endHour);
        return true;
    }

    protected boolean saveCloudUrl() {
        this.cloudUrl = this.cloudUrlTf.getText().trim();
        this.iframe.setCfgString(String.valueOf(this.iframe.getKeyPrefix()) + "_CLOUD_URL", this.cloudUrl);
        return true;
    }

    protected abstract void afterGUI();

    protected abstract boolean saveConfig();

    protected abstract void initSubGUI();

    protected Dimension getDim() {
        return new Dimension(300, 400);
    }
}

