/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.gui;

import java.awt.Component;
import java.awt.Label;
import java.awt.List;
import java.awt.TextComponent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class ComponentAppender
extends AppenderSkeleton {
    protected Component comp;
    protected int entries;
    protected int maxEntries;

    public ComponentAppender(Component comp, int maxEntries) {
        this.setComponent(comp);
        this.setMaxEntries(maxEntries);
    }

    private void setComponent(Component comp) {
        this.layout = comp instanceof JTextArea || comp instanceof JTextPane ? new PatternLayout("%d{MM-dd HH:mm:ss}  %m%n") : new PatternLayout("%m");
        this.comp = comp;
    }

    private void setMaxEntries(int value) {
        if (this.entries > value) {
            int toomuch = this.entries - value;
            if (this.comp instanceof JTextPane) {
                JTextPane textPane = (JTextPane)this.comp;
                try {
                    StyledDocument doc = textPane.getStyledDocument();
                    if (this.entries == this.maxEntries) {
                        Element element = doc.getParagraphElement(0);
                        int startOfs = element.getStartOffset();
                        element = doc.getParagraphElement(toomuch - 1);
                        int endOfs = element.getEndOffset();
                        doc.remove(startOfs, endOfs - startOfs);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            } else if (this.comp instanceof JTextArea) {
                JTextArea textArea = (JTextArea)this.comp;
                try {
                    Document doc = textArea.getDocument();
                    int endOfs = textArea.getLineEndOffset(toomuch - 1);
                    int docLen = doc.getLength();
                    if (docLen < endOfs) {
                        doc.remove(0, docLen);
                    } else {
                        doc.remove(0, endOfs);
                    }
                    textArea.setCaretPosition(doc.getLength());
                }
                catch (Exception doc) {}
            } else if (this.comp instanceof JComboBox) {
                DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)this.comp).getModel();
                int i = 0;
                while (i < toomuch) {
                    model.removeElementAt(0);
                    ++i;
                }
            } else if (this.comp instanceof List) {
                int i = 0;
                while (i < toomuch) {
                    ((List)this.comp).remove(0);
                    ++i;
                }
            }
            this.entries = value;
        }
        this.maxEntries = value;
    }

    public boolean requiresLayout() {
        return true;
    }

    public void append(LoggingEvent event) {
        String text = this.layout.format(event);
        if (this.comp instanceof JLabel) {
            ((JLabel)this.comp).setText(text);
        } else if (this.comp instanceof JTextArea) {
            JTextArea textArea = (JTextArea)this.comp;
            try {
                Document doc = textArea.getDocument();
                if (this.entries == this.maxEntries) {
                    int endOfs = textArea.getLineEndOffset(0);
                    int docLen = doc.getLength();
                    if (docLen < endOfs) {
                        doc.remove(0, docLen);
                    } else {
                        doc.remove(0, endOfs);
                    }
                    --this.entries;
                }
                textArea.append(text);
                if (this.entries == 0) {
                    doc.remove(1, 1);
                }
                textArea.setCaretPosition(doc.getLength());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++this.entries;
        } else if (this.comp instanceof JTextComponent) {
            ((JTextComponent)this.comp).setText(text);
        } else if (this.comp instanceof JComboBox) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)this.comp).getModel();
            if (this.entries == this.maxEntries) {
                model.removeElementAt(0);
                --this.entries;
            }
            model.addElement(text);
            ++this.entries;
            ((JComboBox)this.comp).setSelectedIndex(this.entries - 1);
        } else if (this.comp instanceof Label) {
            ((Label)this.comp).setText(text);
        } else if (this.comp instanceof List) {
            if (this.entries == this.maxEntries) {
                ((List)this.comp).remove(0);
                --this.entries;
            }
            ((List)this.comp).add(text);
            ++this.entries;
        } else if (this.comp instanceof TextComponent) {
            ((TextComponent)this.comp).setText(text);
        }
    }

    public void reset() {
        if (this.comp instanceof JLabel) {
            ((JLabel)this.comp).setText("");
        } else if (this.comp instanceof JTextComponent) {
            ((JTextComponent)this.comp).setText("");
        } else if (this.comp instanceof JComboBox) {
            DefaultComboBoxModel model = (DefaultComboBoxModel)((JComboBox)this.comp).getModel();
            model.removeAllElements();
        } else if (this.comp instanceof Label) {
            ((Label)this.comp).setText("");
        } else if (this.comp instanceof List) {
            ((List)this.comp).removeAll();
        } else if (this.comp instanceof TextComponent) {
            ((TextComponent)this.comp).setText("");
        }
        this.entries = 0;
    }

    public void close() {
        this.reset();
    }
}

