/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.code.worker;

import com.coyousoft.httputil.HttpUtil;
import com.coyousoft.yox.code.component.CodeLabel;
import com.coyousoft.yox.code.component.CodeList;
import com.coyousoft.yox.code.component.CodeTextField;
import com.coyousoft.yox.code.worker.CodeGetter;
import com.coyousoft.yundama.entity.DayCode;
import com.coyousoft.yundama.entity.Master;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.threadpool.NoTsTask;
import org.sysolar.threadpool.Task;
import org.sysolar.threadpool.ThreadPool;

public class RemoteCodeGetter
extends CodeGetter {
    private String getCodeUrl = null;
    private ThreadPool getCodePool = null;
    private Master master = null;

    public RemoteCodeGetter(CodeLabel contentLabel, CodeLabel codeLabel, CodeTextField codeTf, CodeList codeList, String getCodeUrl, ThreadPool getCodePool, Master master) {
        super(contentLabel, codeLabel, codeTf, codeList);
        this.getCodeUrl = getCodeUrl;
        this.getCodePool = getCodePool;
        this.master = master;
    }

    @Override
    public void getCode() throws Exception {
        RemoteGetCodeTask task = new RemoteGetCodeTask(this.getCodePool);
        this.getCodePool.putTask((Task)task);
        Thread.sleep(1000L);
        this.getCodePool.poolValue();
    }

    class RemoteGetCodeTask
    extends NoTsTask {
        public RemoteGetCodeTask(ThreadPool pool) {
            this.pool = pool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void work() throws Exception {
            List<DayCode> serveredCodeList = RemoteCodeGetter.this.codeList.getServeredCodeList();
            if (serveredCodeList == null || serveredCodeList.size() == 0) {
                return;
            }
            DefaultHttpClient client = HttpUtil.getBindClient();
            String url = RemoteCodeGetter.this.getCodeUrl;
            for (DayCode code : serveredCodeList) {
                url = String.valueOf(url) + "&codeId=" + code.getCodeId();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("masterAccount", RemoteCodeGetter.this.master.getMasterAccount());
            map.put("masterPassword", RemoteCodeGetter.this.master.getMasterPassword());
            Long t1 = System.currentTimeMillis();
            System.out.println("\u63d0\u4ea4\u53d6\u7801\u8bf7\u6c42:" + t1);
            String content = null;
            int errorTimes = 0;
            while (content == null && errorTimes < 5) {
                try {
                    content = HttpUtil.doPost((HttpClient)client, url, map, "UTF-8");
                }
                catch (Exception e) {
                    ++errorTimes;
                    Thread.sleep(1000L);
                }
            }
            Long t2 = System.currentTimeMillis();
            System.out.println("\u53d6\u5230\u9a8c\u8bc1\u7801\u7ed3\u679c\u96c6:" + content + ", \u8017\u65f6:" + (t2 - t1));
            List remoteCodeList = Json.toJavaList((String)content);
            if (remoteCodeList == null) {
                throw new Exception(content);
            }
            for (Object obj : remoteCodeList) {
                DayCode serverCode = new DayCode().fillJson((Map)obj);
                DayCode localCode = RemoteCodeGetter.this.codeList.removeByCodeId(serverCode.getCodeId());
                Integer codeStatus = serverCode.getCodeStatus();
                if (codeStatus != null && codeStatus.equals(4)) {
                    localCode.setCodeText("disc");
                } else {
                    localCode.setCodeText(serverCode.getCodeText()).setTableName(serverCode.getTableName());
                }
                DayCode dayCode = localCode;
                synchronized (dayCode) {
                    localCode.notifyAll();
                }
            }
            for (DayCode code : serveredCodeList) {
                code.setCodeStatus(0);
            }
        }
    }
}

