/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.code.worker;

import com.coyousoft.util.ImageUtil;
import com.coyousoft.yox.code.component.CodeLabel;
import com.coyousoft.yox.code.component.CodeList;
import com.coyousoft.yox.code.component.CodeTextField;
import com.coyousoft.yox.code.worker.CodeSetter;
import com.coyousoft.yox.gui.YoxIframe;
import com.coyousoft.yox.gui.YoxLabel;
import com.coyousoft.yox.task.ReportCodeTask;
import com.coyousoft.yundama.entity.DayCode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.sysolar.threadpool.Task;
import org.sysolar.threadpool.ThreadPool;

public class LocalCodeSetter
extends CodeSetter {
    private boolean isReportLocalCode = false;
    private YoxIframe iframe = null;
    private YoxLabel tipLabel1 = null;
    private YoxLabel tipLabel2 = null;

    public LocalCodeSetter(CodeLabel contentLabel, CodeLabel codeLabel, CodeTextField codeTf, CodeList codeList, YoxIframe iframe, String reportCodeUrl, ThreadPool reportCodePool, boolean isReportLocalCode, YoxLabel tipLabel1, YoxLabel tipLabel2) {
        super(contentLabel, codeLabel, codeTf, codeList, reportCodeUrl, reportCodePool);
        this.isReportLocalCode = isReportLocalCode;
        this.iframe = iframe;
        this.tipLabel1 = tipLabel1;
        this.tipLabel2 = tipLabel2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCode() throws InterruptedException {
        CodeLabel codeLabel = this.codeLabel;
        synchronized (codeLabel) {
            byte[] bytes;
            while (this.codeLabel.getIcon() != null || this.codeLabel.getText().startsWith("<html>") || this.contentLabel.getText() != null && !this.contentLabel.getText().trim().equals("")) {
                this.codeLabel.wait();
            }
            DayCode code = this.codeList.remove();
            if (this.isReportLocalCode && code.getCodeId() == null) {
                this.reportCodePool.putTask((Task)new ReportCodeTask(this.reportCodePool, code, this.reportCodeUrl, this.iframe));
            }
            if (code.getCodeLength() != null) {
                this.tipLabel1.setText("\u81ea\u52a8\u63d0\u4ea4");
            } else {
                this.tipLabel1.setText("");
            }
            if (code.getCodeId() != null) {
                this.tipLabel2.setText("\u4e91\u7801");
            } else {
                this.tipLabel2.setText("\u672c\u5730\u7801");
            }
            this.codeLabel.setCode(code);
            this.codeTf.setCode(code);
            this.codeLabel.setText("");
            String codeContent = code.getCodeContent();
            if (codeContent != null && !codeContent.trim().equals("")) {
                this.contentLabel.setText(codeContent);
            }
            if ((bytes = code.getCodeImage()) != null) {
                Image image;
                ImageIcon icon = new ImageIcon(bytes);
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                Dimension maxDim = this.codeLabel.getMaximumSize();
                int maxWidth = (int)maxDim.getWidth();
                int maxHeight = (int)maxDim.getHeight();
                if (iconWidth > maxWidth || iconHeight > maxHeight) {
                    image = icon.getImage();
                    image = image.getScaledInstance(maxWidth, maxHeight, 1);
                    icon = new ImageIcon(image);
                }
                this.codeLabel.setIcon(icon);
                if (code.getCodeType().equals(302)) {
                    this.codeLabel.setIcon(new ImageIcon());
                    image = null;
                    try {
                        image = ImageUtil.toBufferedImage(bytes);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    int subImageWidth = 80;
                    int subImageHeight = 80;
                    ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
                    int x = 0;
                    int y = 0;
                    final JDialog dialog = new JDialog(this.iframe.getMainFace(), "\u770b\u56fe\u89e3\u9650", false){
                        private static final long serialVersionUID = 1L;

                        @Override
                        protected void processWindowEvent(WindowEvent e) {
                            String codeText = LocalCodeSetter.this.codeTf.getText();
                            if (codeText.equals("")) {
                                return;
                            }
                            super.processWindowEvent(e);
                        }
                    };
                    dialog.setLayout(new BorderLayout());
                    JLabel label = new JLabel();
                    label.setPreferredSize(new Dimension(1, 30));
                    label.setBackground(Color.WHITE);
                    dialog.add((Component)label, "North");
                    label.setText(code.getCodeContent());
                    final JPanel panel = new JPanel();
                    panel.setPreferredSize(new Dimension(240, 240));
                    dialog.add((Component)panel, "Center");
                    JPanel btPanel = new JPanel();
                    dialog.add((Component)btPanel, "South");
                    JButton bt = new JButton("\u63d0\u4ea4");
                    btPanel.add(bt);
                    final ArrayList<2> cbxList = new ArrayList<2>();
                    int subImageNum = ((BufferedImage)image).getHeight() / subImageHeight;
                    panel.setLayout(new GridLayout(3, 3));
                    int i = 0;
                    while (i < subImageNum) {
                        final BufferedImage subImage = ((BufferedImage)image).getSubimage(x, y, subImageWidth, subImageHeight);
                        y += subImageHeight;
                        list.add(subImage);
                        final JCheckBox cbx = new JCheckBox(){
                            private static final long serialVersionUID = 1L;

                            @Override
                            public void paintComponent(Graphics g) {
                                ImageIcon icon = new ImageIcon(subImage);
                                g.drawImage(icon.getImage(), 0, 0, icon.getIconWidth(), icon.getIconHeight(), panel);
                            }
                        };
                        cbxList.add(cbx);
                        cbx.addItemListener(new ItemListener(){

                            @Override
                            public void itemStateChanged(ItemEvent e) {
                                if (cbx.isSelected()) {
                                    cbx.setBorder(BorderFactory.createLineBorder(Color.RED));
                                    cbx.setBorderPainted(true);
                                } else {
                                    cbx.setBorderPainted(false);
                                }
                                LocalCodeSetter.this.codeTf.setText("");
                                int i = 0;
                                while (i < cbxList.size()) {
                                    JCheckBox cbx2 = (JCheckBox)cbxList.get(i);
                                    if (cbx2.isSelected()) {
                                        LocalCodeSetter.this.codeTf.setText(String.valueOf(LocalCodeSetter.this.codeTf.getText()) + i + ",");
                                    }
                                    ++i;
                                }
                            }
                        });
                        panel.add(cbx);
                        ++i;
                    }
                    dialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent arg0) {
                            String text = LocalCodeSetter.this.codeTf.getText();
                            if (text.equals("")) {
                                return;
                            }
                        }

                        @Override
                        public void windowClosed(WindowEvent arg0) {
                            String text = LocalCodeSetter.this.codeTf.getText();
                            if (text.equals("")) {
                                return;
                            }
                            LocalCodeSetter.this.codeTf.postResult();
                            super.windowClosed(arg0);
                        }
                    });
                    bt.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent arg0) {
                            String codeText = LocalCodeSetter.this.codeTf.getText();
                            if (codeText.equals("")) {
                                return;
                            }
                            dialog.dispose();
                        }
                    });
                    dialog.setDefaultCloseOperation(2);
                    dialog.setResizable(false);
                    dialog.pack();
                    dialog.setLocationRelativeTo(this.iframe.getMainFace());
                    dialog.setVisible(true);
                }
            } else if (code.getImgUrl() != null) {
                String imageUrl = code.getImgUrl();
                this.codeLabel.setText("<html><img src='" + imageUrl + "'></img></html>");
            } else if (codeContent == null || codeContent.trim().equals("")) {
                return;
            }
            Container c = this.codeLabel.getParent();
            while (!((c = c.getParent()) instanceof JInternalFrame)) {
            }
            ((JInternalFrame)c).updateUI();
            c.repaint();
            this.codeTf.requestFocus();
        }
    }
}

