/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.yox.code.component;

import com.coyousoft.yox.code.component.CodeStatusUtil;
import com.coyousoft.yox.code.exception.CodeTimeOutException;
import com.coyousoft.yundama.entity.DayCode;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class CodeList {
    private List<DayCode> list = new ArrayList<DayCode>();
    protected static final Logger l = Logger.getLogger(CodeList.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DayCode code, Integer index) throws Exception {
        Integer timeout = code.getCodeTimeout();
        if (timeout == null || timeout.equals(0)) {
            timeout = 90000;
        }
        String senderUserName = code.getByteString();
        l.info((Object)(String.valueOf(senderUserName) + " timeout " + timeout));
        Object object = this;
        synchronized (object) {
            if (timeout.equals(-1)) {
                throw new CodeTimeOutException("\u914d\u7f6e\u4e86\u4e0d\u6253\u7801, \u5f03\u7801");
            }
            l.info((Object)(String.valueOf(senderUserName) + " \u8fdblist"));
            if (index == null) {
                if (code.getCodeId() != null) {
                    this.list.add(0, code);
                } else {
                    this.list.add(code);
                }
            } else {
                this.list.add(index, code);
            }
            l.info((Object)(String.valueOf(senderUserName) + " this.notifyAll"));
            this.notifyAll();
        }
        l.info((Object)(String.valueOf(senderUserName) + " synchronized(code)"));
        object = code;
        synchronized (object) {
            long beginWaitTime = System.currentTimeMillis();
            l.info((Object)(String.valueOf(senderUserName) + " code.getCodeText()"));
            while (code.getCodeText() == null) {
                if (timeout.equals(0)) {
                    l.info((Object)(String.valueOf(senderUserName) + " code.wait()"));
                    code.wait();
                    continue;
                }
                l.info((Object)(String.valueOf(senderUserName) + " code.wait(timeout)"));
                code.wait(timeout.intValue());
                long endWaitTime = System.currentTimeMillis();
                if (endWaitTime - beginWaitTime < (long)timeout.intValue()) continue;
                l.info((Object)(String.valueOf(senderUserName) + " before CodeStatusUtil.setCodeStatus(code, DayCode.CODE_STATUS_WRONG)"));
                CodeStatusUtil.setCodeStatus(code, 3);
                l.info((Object)(String.valueOf(senderUserName) + " after CodeStatusUtil.setCodeStatus(code, DayCode.CODE_STATUS_WRONG)"));
                this.removeCode(code);
                throw new CodeTimeOutException("\u961f\u5217\u4e2d\u7684\u7801\u8d85\u65f6:" + code);
            }
        }
    }

    public synchronized DayCode get() throws InterruptedException {
        while (this.list.size() == 0) {
            this.wait();
        }
        while (true) {
            for (DayCode code : this.list) {
                Integer codeStatus = code.getCodeStatus();
                if (codeStatus != null) continue;
                code.setCodeStatus(0);
                code.setCodeStatus(0);
                return code;
            }
            this.wait();
        }
    }

    public synchronized DayCode remove() throws InterruptedException {
        while (this.list.size() == 0) {
            this.wait();
        }
        DayCode code = this.list.remove(0);
        code.setCodeStatus(0);
        return code;
    }

    public void removeAll() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public synchronized void removeCode(DayCode code) {
        this.list.remove(code);
    }

    public synchronized DayCode removeByCodeId(Integer codeId) throws Exception {
        for (DayCode code : this.list) {
            Integer tmpCodeId = code.getCodeId();
            if (tmpCodeId == null || !tmpCodeId.equals(codeId)) continue;
            this.list.remove(code);
            return code;
        }
        throw new Exception("\u5f02\u5e38:" + codeId + "\u53f7code\u5728codeList\u4e2d\u4e0d\u5b58\u5728");
    }

    public synchronized List<DayCode> getServeredCodeList() throws Exception {
        ArrayList<DayCode> codeList = new ArrayList<DayCode>();
        for (DayCode code : this.list) {
            Integer codeId;
            Integer codeStatus = code.getCodeStatus();
            if (codeStatus == null || !codeStatus.equals(0) || (codeId = code.getCodeId()) == null) continue;
            code.setCodeStatus(1);
            codeList.add(code);
        }
        return codeList;
    }
}

