/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.util;

import com.coyousoft.util.Rect;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;
import java.awt.Color;
import java.awt.Image;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class KbUtil {
    public static final int WM_LBUTTONDOWN = 513;
    public static final int WM_LBUTTONUP = 514;
    public static final int WM_RBUTTONUP = 517;
    public static final int WM_RBUTTONDOWN = 516;
    public static final int WM_MOUSEHWHEEL = 526;
    public static final int WM_MOUSEWHEEL = 522;
    public static final int WM_MOUSEMOVE = 512;
    public static final Long VK_ENTER = 13L;
    public static final Long VK_BACK = 8L;
    private static final Map<Integer, Integer> KEY_CODE_MAP = new HashMap<Integer, Integer>();
    private static User32 u32 = User32.INSTANCE;

    static {
        KEY_CODE_MAP.put(97, 65);
        KEY_CODE_MAP.put(98, 66);
        KEY_CODE_MAP.put(99, 67);
        KEY_CODE_MAP.put(100, 68);
        KEY_CODE_MAP.put(101, 69);
        KEY_CODE_MAP.put(102, 70);
        KEY_CODE_MAP.put(103, 71);
        KEY_CODE_MAP.put(104, 72);
        KEY_CODE_MAP.put(105, 73);
        KEY_CODE_MAP.put(106, 74);
        KEY_CODE_MAP.put(107, 75);
        KEY_CODE_MAP.put(108, 76);
        KEY_CODE_MAP.put(109, 77);
        KEY_CODE_MAP.put(110, 78);
        KEY_CODE_MAP.put(111, 79);
        KEY_CODE_MAP.put(112, 80);
        KEY_CODE_MAP.put(113, 81);
        KEY_CODE_MAP.put(114, 82);
        KEY_CODE_MAP.put(115, 83);
        KEY_CODE_MAP.put(116, 84);
        KEY_CODE_MAP.put(117, 85);
        KEY_CODE_MAP.put(118, 86);
        KEY_CODE_MAP.put(119, 87);
        KEY_CODE_MAP.put(120, 88);
        KEY_CODE_MAP.put(121, 89);
        KEY_CODE_MAP.put(122, 90);
        KEY_CODE_MAP.put(48, 48);
        KEY_CODE_MAP.put(49, 49);
        KEY_CODE_MAP.put(50, 50);
        KEY_CODE_MAP.put(51, 51);
        KEY_CODE_MAP.put(52, 52);
        KEY_CODE_MAP.put(53, 53);
        KEY_CODE_MAP.put(54, 54);
        KEY_CODE_MAP.put(55, 55);
        KEY_CODE_MAP.put(56, 56);
        KEY_CODE_MAP.put(57, 57);
        KEY_CODE_MAP.put(42, 106);
        KEY_CODE_MAP.put(43, 107);
        KEY_CODE_MAP.put(45, 109);
        KEY_CODE_MAP.put(46, 110);
        KEY_CODE_MAP.put(47, 111);
        KEY_CODE_MAP.put(61, 61);
        KEY_CODE_MAP.put(59, 59);
        KEY_CODE_MAP.put(44, 44);
        KEY_CODE_MAP.put(92, 92);
        KEY_CODE_MAP.put(91, 91);
        KEY_CODE_MAP.put(93, 93);
        KEY_CODE_MAP.put(96, 192);
        KEY_CODE_MAP.put(39, 222);
    }

    public static void fire(Robot r, char c) {
        if (c >= 'A' && c <= 'Z') {
            r.keyPress(16);
            r.keyPress(c);
            r.keyRelease(16);
        } else if (c == '~') {
            r.keyPress(16);
            r.keyPress(192);
            r.keyRelease(16);
        } else if (c == '!') {
            r.keyPress(16);
            r.keyPress(49);
            r.keyRelease(16);
        } else if (c == '@') {
            r.keyPress(16);
            r.keyPress(50);
            r.keyRelease(16);
        } else if (c == '#') {
            r.keyPress(16);
            r.keyPress(51);
            r.keyRelease(16);
        } else if (c == '$') {
            r.keyPress(16);
            r.keyPress(52);
            r.keyRelease(16);
        } else if (c == '%') {
            r.keyPress(16);
            r.keyPress(53);
            r.keyRelease(16);
        } else if (c == '^') {
            r.keyPress(16);
            r.keyPress(54);
            r.keyRelease(16);
        } else if (c == '&') {
            r.keyPress(16);
            r.keyPress(55);
            r.keyRelease(16);
        } else if (c == '(') {
            r.keyPress(16);
            r.keyPress(57);
            r.keyRelease(16);
        } else if (c == ')') {
            r.keyPress(16);
            r.keyPress(48);
            r.keyRelease(16);
        } else if (c == '_') {
            r.keyPress(16);
            r.keyPress(45);
            r.keyRelease(16);
        } else if (c == '\"') {
            r.keyPress(16);
            r.keyPress(222);
            r.keyRelease(16);
        } else if (c == '|') {
            r.keyPress(16);
            r.keyPress(92);
            r.keyRelease(16);
        } else if (c == '{') {
            r.keyPress(16);
            r.keyPress(91);
            r.keyRelease(16);
        } else if (c == '}') {
            r.keyPress(16);
            r.keyPress(93);
            r.keyRelease(16);
        } else if (c == '<') {
            r.keyPress(16);
            r.keyPress(44);
            r.keyRelease(16);
        } else if (c == '>') {
            r.keyPress(16);
            r.keyPress(46);
            r.keyRelease(16);
        } else if (c == '?') {
            r.keyPress(16);
            r.keyPress(47);
            r.keyRelease(16);
        } else if (c == ':') {
            r.keyPress(16);
            r.keyPress(59);
            r.keyRelease(16);
        } else {
            r.keyPress(KEY_CODE_MAP.get(c));
            r.keyRelease(KEY_CODE_MAP.get(c));
        }
    }

    public static void input(Robot robot, WinDef.HWND hwnd, Integer x, Integer y, String text, boolean isPaste) {
        if (x != null && y != null) {
            if (hwnd == null) {
                robot.mouseMove(x, y);
                robot.mousePress(16);
                robot.mouseRelease(16);
            } else {
                KbUtil.mouseClick(hwnd, 513, x, y);
                KbUtil.mouseClick(hwnd, 514, x, y);
            }
            robot.delay(700);
        }
        if (isPaste) {
            if (text != null) {
                StringSelection tText = new StringSelection(text);
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(tText, null);
            }
            KbUtil.paste(robot);
        } else {
            char[] cArray = text.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray[n2];
                KbUtil.fire(robot, c);
                robot.delay(100);
                ++n2;
            }
        }
    }

    public static void pasteImage(Robot robot, WinDef.HWND hwnd, Integer x, Integer y, Image image) {
        if (x != null && y != null) {
            if (hwnd == null) {
                robot.mouseMove(x, y);
                robot.mousePress(16);
                robot.mouseRelease(16);
            } else {
                KbUtil.mouseClick(hwnd, 513, x, y);
                KbUtil.mouseClick(hwnd, 514, x, y);
            }
            robot.delay(700);
        }
        if (image != null) {
            KbUtil.setClipboardImage(image);
        }
        KbUtil.paste(robot);
    }

    public static void paste(Robot robot) {
        robot.keyPress(17);
        robot.delay(10);
        robot.keyPress(86);
        robot.delay(10);
        robot.keyRelease(86);
        robot.keyRelease(17);
    }

    public static void enter(Robot r) {
        KbUtil.keyPress(r, 10);
    }

    public static void setClipboardImage(final Image image) {
        Transferable trans = new Transferable(){

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                return new DataFlavor[]{DataFlavor.imageFlavor};
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return DataFlavor.imageFlavor.equals(flavor);
            }

            @Override
            public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(flavor)) {
                    return image;
                }
                throw new UnsupportedFlavorException(flavor);
            }
        };
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(trans, null);
    }

    public static void setClipboard(String text) {
        StringSelection tText = new StringSelection(text);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(tText, null);
    }

    public static void mouseLeftPress(Robot r, int x, int y) {
        r.mouseMove(x, y);
        r.mousePress(16);
        r.mouseRelease(16);
    }

    public static void keyPress(Robot r, int ... keys) {
        int delayTime = 0;
        if (keys.length > 2) {
            delayTime = 100;
        }
        int i = 0;
        while (i < keys.length) {
            r.keyPress(keys[i]);
            r.delay(delayTime);
            ++i;
        }
        r.delay(delayTime);
        i = keys.length - 1;
        while (i >= 0) {
            r.keyRelease(keys[i]);
            --i;
        }
    }

    public static boolean colorBetween(Color c, int from, int to) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return r >= from && r <= to && g >= from && g <= to && b >= from && b <= to;
    }

    public static boolean colorIs(Color c, int rgbValue) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return r == rgbValue && g == rgbValue && b == rgbValue;
    }

    public static boolean colorNot(Color c, int rgbValue) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return r != rgbValue && g != rgbValue && b != rgbValue;
    }

    public static boolean colorOver(Color c, int value) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return r > value && g > value && b > value;
    }

    public static boolean colorUnder(Color c, int value) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        return r < value && g < value && b < value;
    }

    public static Rect getWinRect(WinDef.HWND hwnd) {
        WinDef.RECT r = new WinDef.RECT();
        u32.GetWindowRect(hwnd, r);
        Rect rect = new Rect(r.left, r.top, r.right, r.bottom);
        return rect;
    }

    public static String getWinTitle(WinDef.HWND hwnd) {
        char[] textArr = new char[100];
        u32.GetWindowText(hwnd, textArr, 1000);
        String str = new String(textArr);
        return str;
    }

    public static String getWinClass(WinDef.HWND hwnd) {
        char[] textArr = new char[100];
        u32.GetClassName(hwnd, textArr, 1000);
        String str = new String(textArr);
        return str;
    }

    private static void mouseClick(WinDef.HWND hwnd, int msg, int x, int y) {
        WinDef.WPARAM wParam = new WinDef.WPARAM(0L);
        int temp = y << 16 | x << 16 >> 16;
        WinDef.LPARAM lParam = new WinDef.LPARAM((long)temp);
        u32.PostMessage(hwnd, msg, wParam, lParam);
    }

    public static void vClick(WinDef.HWND hwnd, int x, int y) {
        WinDef.WPARAM wParam = new WinDef.WPARAM(0L);
        int temp = y << 16 | x << 16 >> 16;
        WinDef.LPARAM lParam = new WinDef.LPARAM((long)temp);
        u32.PostMessage(hwnd, 513, wParam, lParam);
        u32.PostMessage(hwnd, 514, wParam, lParam);
    }

    public static void gc(WinDef.HWND hd) {
        String title = KbUtil.getWinTitle(hd).trim();
        if (title.indexOf("QQ\u5ba0\u7269\u767b\u5f55") != -1 || title.indexOf("\u817e\u8baf\u7f51\u8ff7\u4f60\u7248") != -1 || title.indexOf("\u70ed\u952e\u51b2\u7a81") != -1 || title.indexOf("\u7fa4\u7cfb\u7edf\u6d88\u606f") != -1 || title.indexOf("Q+") != -1 && title.indexOf("\u5927\u5723") == -1 || title.indexOf("\u5e94\u7528\u7a0b\u5e8f\u9519\u8bef") != -1) {
            KbUtil.close(hd);
        }
    }

    public static void gc(String title) {
        WinDef.HWND hwnd = u32.FindWindow(null, title);
        String t = KbUtil.getWinTitle(hwnd);
        if (t != null && t.indexOf(title) != -1) {
            KbUtil.close(hwnd);
        }
    }

    public static void gc() {
        u32.EnumWindows(new WinUser.WNDENUMPROC(){

            public boolean callback(WinDef.HWND hd, Pointer arg1) {
                KbUtil.gc(hd);
                return true;
            }
        }, null);
    }

    public static void close(WinDef.HWND hwnd) {
        u32.PostMessage(hwnd, 16, new WinDef.WPARAM(), new WinDef.LPARAM());
    }

    private static void backKeyPress(WinDef.HWND hwnd, int keyNum) {
        WinDef.WPARAM wParam = new WinDef.WPARAM((long)(keyNum << 16 >> 16));
        WinDef.LPARAM lParam = new WinDef.LPARAM(0L);
        u32.PostMessage(hwnd, 256, wParam, lParam);
    }

    private static void backKeyRelease(WinDef.HWND hwnd, int keyNum) {
        WinDef.WPARAM wParam = new WinDef.WPARAM((long)(keyNum << 16 >> 16));
        WinDef.LPARAM lParam = new WinDef.LPARAM(0L);
        u32.PostMessage(hwnd, 257, wParam, lParam);
    }

    public static void vKey(WinDef.HWND hwnd, Long keyCode) {
        u32.PostMessage(hwnd, 256, new WinDef.WPARAM(keyCode.longValue()), new WinDef.LPARAM());
        u32.PostMessage(hwnd, 257, new WinDef.WPARAM(keyCode.longValue()), new WinDef.LPARAM());
    }
}

