/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sysolar.util.WinExecutor;

public class IpUtil {
    public static final String RE_IP_USERNAME = "RE_IP_USERNAME";
    public static final String RE_IP_PASSWORD = "RE_IP_PASSWORD";
    public static final String RE_IP_CYCLE = "RE_IP_CYCLE";
    public static final String ADSL_NAME = "ADSL_NAME";
    public static final String CUT_CONNECT_SLEPP_SECOND = "CUT_CONNECT_SLEPP_SECOND";
    public static final String FILTER_SAME_IP = "FILTER_SAME_IP";
    private static final Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");

    public static boolean isInnerIP(long a_ip) {
        return a_ip >> 24 == 10L || a_ip >> 16 == 49320L || a_ip >> 22 == 688L;
    }

    public static long ipToLong(String strIP) {
        long[] ip = new long[4];
        int position1 = strIP.indexOf(".");
        int position2 = strIP.indexOf(".", position1 + 1);
        int position3 = strIP.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIP.substring(0, position1));
        ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIP.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    public static String getIp() throws UnknownHostException {
        String ip = null;
        InetAddress in = InetAddress.getLocalHost();
        InetAddress[] all = InetAddress.getAllByName(in.getHostName());
        int i = 0;
        while (i < all.length) {
            String tmp = null;
            tmp = ip = all[i].getHostAddress().toString();
            if (!ip.startsWith("169.254") && ip.indexOf(":") == -1 && !IpUtil.isInnerIP(IpUtil.ipToLong(tmp))) {
                return ip;
            }
            ++i;
        }
        return null;
    }

    public static String disconnect(String adslName) throws InterruptedException, Exception {
        if (adslName == null || "".equals(adslName)) {
            return "\u672a\u914d\u7f6eADSL\u540d\u79f0, \u65e0\u6cd5\u5207\u6362IP";
        }
        int code = WinExecutor.exe((String)("Rasdial " + adslName + " /disconnect"));
        if (code == 0 || code == 1) {
            return "\u65ad\u5f00\u7f51\u7edc\u6210\u529f! ";
        }
        throw new Exception("\u65ad\u7f51\u5931\u8d25");
    }

    public static String connect(String adslName, String reIpUserName, String reIpPassword) throws IOException, InterruptedException {
        if (adslName == null || "".equals(adslName)) {
            return "\u672a\u914d\u7f6eADSL\u540d\u79f0, \u65e0\u6cd5\u5207\u6362IP";
        }
        if (reIpUserName == null || reIpUserName.equals("")) {
            return "\u672a\u914d\u7f6eADSL\u7528\u6237\u540d, \u65e0\u6cd5\u5207\u6362IP";
        }
        if (reIpPassword == null || reIpPassword.equals("")) {
            return "\u672a\u914d\u7f6eADSL\u5bc6\u7801, \u65e0\u6cd5\u5207\u6362IP";
        }
        int code = WinExecutor.exe((String)("Rasdial " + adslName + " " + reIpUserName + " " + reIpPassword));
        if (code == 0 || code == 1) {
            return "\u8fde\u63a5\u7f51\u7edc\u6210\u529f! \u5f53\u524dIP:" + IpUtil.getIp();
        }
        return "\u8fde\u63a5\u7f51\u7edc\u5931\u8d25,\u8bf7\u68c0\u67e5\u62e8\u53f7\u7528\u6237\u540d\u548c\u62e8\u53f7\u5bc6\u7801\u662f\u5426\u6b63\u786e.";
    }

    public static byte stringToByte(String string) {
        int ipInt = Integer.parseInt(string);
        if (ipInt <= 127) {
            return (byte)ipInt;
        }
        String hexString = Integer.toHexString(ipInt);
        int length = hexString.length();
        if (length == 1) {
            hexString = "0" + hexString;
        }
        hexString = hexString.toUpperCase();
        char[] hexChars = hexString.toCharArray();
        Byte b = null;
        b = (byte)(IpUtil.charToByte(hexChars[0]) << 4 | IpUtil.charToByte(hexChars[1]));
        return b;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static byte[] ip2bytes(String ip) {
        String[] ips = ip.split("[.]");
        byte[] ipbs = new byte[4];
        int i = 0;
        while (i < 4) {
            int m = Integer.parseInt(ips[i]);
            byte b = (byte)m;
            if (m > 127) {
                b = (byte)(127 - m);
            }
            ipbs[i] = b;
            ++i;
        }
        return ipbs;
    }

    public static String getNearIp(String srcIp) {
        Random r = new Random();
        int ip3 = r.nextInt(253) + 1;
        int ip4 = r.nextInt(253) + 1;
        String prefixIp = "";
        String localIp = srcIp;
        if (localIp == null) {
            try {
                localIp = IpUtil.getIp();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (localIp == null) {
            localIp = IpUtil.getRandomIp();
        } else {
            String[] subIpArr = localIp.split("\\.");
            prefixIp = String.valueOf(subIpArr[0]) + "." + subIpArr[1] + ".";
        }
        return String.valueOf(prefixIp) + ip3 + "." + ip4;
    }

    public static String getRandomIp() {
        Random r = new Random();
        int ip1 = r.nextInt(200) + 1;
        while (ip1 == 10 || ip1 == 127 || ip1 == 192 || ip1 == 172 || ip1 == 169) {
            ip1 = r.nextInt(200) + 1;
        }
        int ip2 = r.nextInt(253) + 1;
        int ip3 = r.nextInt(253) + 1;
        int ip4 = r.nextInt(253) + 1;
        String ip = String.valueOf(ip1) + "." + ip2 + "." + ip3 + "." + ip4;
        return ip;
    }

    public static String incrementIp(String ip) throws Exception {
        String[] subIpArr = ip.split("\\.");
        Integer subIp3 = Integer.parseInt(subIpArr[3]);
        if (subIp3 < 255) {
            subIp3 = subIp3 + 1;
            return String.valueOf(subIpArr[0]) + "." + subIpArr[1] + "." + subIpArr[2] + "." + subIp3;
        }
        Integer subIp2 = Integer.parseInt(subIpArr[2]);
        if (subIp2 < 255) {
            subIp2 = subIp2 + 1;
            subIp3 = 0;
            return String.valueOf(subIpArr[0]) + "." + subIpArr[1] + "." + subIp2 + "." + subIp3;
        }
        Integer subIp1 = Integer.parseInt(subIpArr[1]);
        if (subIp1 < 255) {
            subIp1 = subIp1 + 1;
            subIp2 = 0;
            subIp3 = 0;
            return String.valueOf(subIpArr[0]) + "." + subIp1 + "." + subIp2 + "." + subIp3;
        }
        Integer subIp0 = Integer.parseInt(subIpArr[0]);
        if (subIp0 < 255) {
            subIp0 = subIp0 + 1;
            subIp1 = 0;
            subIp2 = 0;
            subIp3 = 0;
            return subIp0 + "." + subIp1 + "." + subIp2 + "." + subIp3;
        }
        throw new Exception("IP\u6ea2\u51fa");
    }

    public static boolean verifyIp(String ip) {
        Matcher matcher = pattern.matcher(ip);
        return matcher.matches();
    }

    public static void main(String[] args) throws Exception {
        String ip = "0.0.0.0";
        int i = 0;
        while (true) {
            ip = IpUtil.incrementIp(ip);
            System.out.println(String.valueOf(i++) + ":" + ip);
        }
    }
}

