/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.support;

import com.coyousoft.tugui.constant.Logic;
import com.coyousoft.tugui.entity.LeimailUser;
import com.coyousoft.tugui.entity.OpenLog;
import com.coyousoft.tugui.entity.TinyUrl;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.config.FileConfig;
import org.sysolar.sun.jdbc.core.Transactions;

public final class MainFilter
implements Filter {
    private static final Log log = LogFactory.getLog(MainFilter.class);
    public static final Random r = new Random();
    private static Pattern pUrlId;
    private static Pattern pUrlIdNum;
    private static Pattern pParam;
    private static Pattern pServerName;
    private static final String defaultUrl = "http://dns.5i56.com/t129/x10x11x11x11x.htm";
    private static final Pattern pDomain;
    Integer[] defaultIds = null;

    static {
        pDomain = Pattern.compile("\\.");
        pServerName = Pattern.compile("localhost|leimail\\.com|www\\.leimail\\.com|tugui\\.net|www\\.tugui\\.net|tugui\\.5i56\\.com|t\\d*\\.5i56\\.com|192\\.168\\.1\\.\\d+", 2);
        pUrlId = Pattern.compile("/(\\w+)(/\\w+)*", 2);
        pUrlIdNum = Pattern.compile("\\d+", 2);
        pParam = Pattern.compile("[/=][a-z]+(\\d+)[a-z]+(\\d+)[a-z]+(\\d+)[a-z]+(\\d+)[a-z]+", 2);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        Integer urlId;
        HttpServletResponse response;
        block34: {
            block35: {
                HttpServletRequest request = (HttpServletRequest)req;
                response = (HttpServletResponse)resp;
                String serverName = request.getServerName();
                String servletPath = request.getServletPath().trim();
                String queryString = request.getQueryString();
                if (pServerName.matcher(serverName).matches()) {
                    LeimailUser user;
                    if (servletPath.indexOf(".class") > 0) {
                        log.warn(servletPath);
                        return;
                    }
                    if (servletPath.indexOf("/email/") >= 0 && ((user = (LeimailUser)request.getSession().getAttribute("KEY_USER")) == null || user.getUserType() < 200)) {
                        return;
                    }
                    chain.doFilter(req, resp);
                    return;
                }
                String allRedirect = FileConfig.getString((String)"all-redirect");
                if (allRedirect != null && allRedirect.trim().startsWith("http://")) {
                    response.sendRedirect(allRedirect);
                    return;
                }
                String ip = request.getRemoteAddr();
                int index = ip.lastIndexOf(46);
                String ipGroup = ip.substring(0, index);
                if (FileConfig.getString((String)ip) != null || FileConfig.getString((String)ipGroup) != null) {
                    response.sendRedirect(FileConfig.getString((String)"DEFAULT-URL"));
                    return;
                }
                String domain = request.getParameter("domain");
                if (domain == null) {
                    domain = serverName;
                }
                String referer = request.getHeader("referer");
                if (domain != null) {
                    referer = domain;
                }
                urlId = null;
                Matcher m = pUrlId.matcher(servletPath);
                StringBuilder buffer = new StringBuilder(128);
                if (m.find()) {
                    Matcher mNum = pUrlIdNum.matcher(m.group(1));
                    while (mNum.find()) {
                        buffer.append(mNum.group());
                    }
                    if (buffer.length() > 0) {
                        urlId = Integer.valueOf(buffer.toString());
                    }
                }
                if (urlId == null) {
                    urlId = FileConfig.getInteger((String)domain);
                }
                if (urlId == null) {
                    String[] arr = pDomain.split(domain);
                    buffer.delete(0, buffer.length());
                    try {
                        buffer.append("*").append('.').append(arr[arr.length - 2]).append('.').append(arr[arr.length - 1]);
                        urlId = FileConfig.getInteger((String)buffer.toString());
                    }
                    catch (Exception e) {
                        log.error(String.valueOf(domain) + ",arr.length=" + arr.length, e);
                    }
                }
                if (urlId == null) {
                    String str;
                    String[] arr;
                    if (this.defaultIds == null && (arr = (str = AppContext.getValue((String)"defaultIds")).split("[\\s\\,]+")).length > 0) {
                        this.defaultIds = new Integer[arr.length];
                        int i = 0;
                        while (i < arr.length) {
                            this.defaultIds[i] = Integer.valueOf(arr[i]);
                            ++i;
                        }
                    }
                    if (this.defaultIds != null) {
                        urlId = this.defaultIds[r.nextInt(this.defaultIds.length)];
                    }
                }
                TinyUrl tinyUrl = Logic.tinyUrlLogic.fetch(urlId);
                if (tinyUrl == null) break block34;
                if (tinyUrl.getStatType() != 0) {
                    OpenLog openLog = new OpenLog();
                    openLog.setUrlId(urlId).setOpenDate(new Date()).setFromIp(request.getRemoteAddr()).setFromReferer(referer);
                    m = pParam.matcher(String.valueOf(servletPath) + " " + queryString);
                    if (m.find()) {
                        Calendar c = Calendar.getInstance();
                        int year = c.get(1);
                        c.clear();
                        c.set(1, year);
                        c.set(2, Integer.valueOf(m.group(1)));
                        c.set(5, Integer.valueOf(m.group(2)));
                        c.set(11, Integer.valueOf(m.group(3)));
                        c.set(12, Integer.valueOf(m.group(4)));
                        openLog.setSendDate(c.getTime());
                    }
                    Logic.openLogLogic.create(openLog);
                }
                if (tinyUrl.getStatType() == 11) {
                    tinyUrl.setUrlHref(tinyUrl.getUrlHref().replace(":", "%3A"));
                    request.setAttribute("tinyUrl", (Object)tinyUrl);
                    request.getRequestDispatcher("/goIndex.jsp").forward((ServletRequest)request, (ServletResponse)response);
                    break block35;
                }
                response.sendRedirect(tinyUrl.getUrlHref());
            }
            try {
                Transactions.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return;
        }
        try {
            try {
                log.error("Invalid id:" + urlId);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                try {
                    Transactions.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        catch (Throwable throwable) {
            try {
                Transactions.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            Transactions.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        response.sendRedirect(FileConfig.getString((String)"DEFAULT-URL"));
    }

    public void destroy() {
    }

    public static void main(String[] args) {
        String domain = "www.baidu.com.22127.com";
        StringBuilder buffer = new StringBuilder(128);
        Integer urlId = null;
        String[] arr = pDomain.split(domain);
        if (arr.length >= 2) {
            buffer.delete(0, buffer.length());
            buffer.append(arr[arr.length - 2]).append('.').append(arr[arr.length - 1]);
            urlId = FileConfig.getInteger((String)buffer.toString());
        }
        if (urlId == null && arr.length >= 3) {
            buffer.delete(0, buffer.length());
            buffer.append(arr[arr.length - 3]).append('.').append(arr[arr.length - 2]).append('.').append(arr[arr.length - 1]);
            urlId = FileConfig.getInteger((String)buffer.toString());
        }
        if (urlId == null && arr.length >= 4) {
            buffer.delete(0, buffer.length());
            buffer.append(arr[arr.length - 4]).append('.').append(arr[arr.length - 3]).append('.').append(arr[arr.length - 2]).append('.').append(arr[arr.length - 1]);
            urlId = FileConfig.getInteger((String)buffer.toString());
        }
        System.out.println(urlId);
    }
}

