/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.logicimpl;

import com.coyousoft.tugui.constant.Dao;
import com.coyousoft.tugui.entity.TinyUrl;
import com.coyousoft.tugui.logic.TinyUrlLogic;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.sun.config.FileConfig;
import org.sysolar.sun.jdbc.core.Transactions;

public final class TinyUrlLogicImpl
implements TinyUrlLogic {
    private static final Log log = LogFactory.getLog(TinyUrlLogic.class);
    private static Map<Integer, TinyUrl> fetch$cache = Collections.synchronizedMap(new HashMap(120));
    private static Map<String, TinyUrl> fetchByUrlHref$cache = Collections.synchronizedMap(new HashMap(120));

    @Override
    public void create(TinyUrl tinyUrl) throws Exception {
        Dao.tinyUrlDao.create(tinyUrl);
    }

    @Override
    public void create(List<TinyUrl> tinyUrlList) throws Exception {
        Dao.tinyUrlDao.create(tinyUrlList);
    }

    @Override
    public int remove(Integer urlId) throws Exception {
        return Dao.tinyUrlDao.remove(urlId);
    }

    @Override
    public int update(TinyUrl tinyUrl) throws Exception {
        int affectedRow = Dao.tinyUrlDao.update(tinyUrl);
        if (affectedRow >= 1) {
            tinyUrl = Dao.tinyUrlDao.fetch(tinyUrl.getUrlId());
            fetch$cache.put(tinyUrl.getUrlId(), tinyUrl);
        }
        return affectedRow;
    }

    @Override
    public TinyUrl fetch(Integer urlId) throws Exception {
        TinyUrl tinyUrl = fetch$cache.get(urlId);
        if (tinyUrl == null) {
            tinyUrl = Dao.tinyUrlDao.fetch(urlId);
            if (tinyUrl == null) {
                tinyUrl = new TinyUrl();
                tinyUrl.setUrlHref(FileConfig.getString((String)"DEFAULT-URL"));
                tinyUrl.setStatType(0);
                tinyUrl.setUrlId(urlId);
                log.error("Invalid ID : " + urlId);
            }
            fetch$cache.put(urlId, tinyUrl);
        }
        return tinyUrl;
    }

    @Override
    public TinyUrl fetch(String urlHref, Integer statType) throws Exception {
        TinyUrl tinyUrl = fetchByUrlHref$cache.get(urlHref);
        if (tinyUrl != null) {
            return tinyUrl;
        }
        try {
            tinyUrl = Dao.tinyUrlDao.fetchByUrlHref(urlHref);
            if (tinyUrl == null) {
                tinyUrl = new TinyUrl().setUrlHref(urlHref).setStatType(statType);
                Dao.tinyUrlDao.create(tinyUrl, true);
            }
        }
        finally {
            Transactions.close();
        }
        fetchByUrlHref$cache.put(urlHref, tinyUrl);
        return tinyUrl;
    }

    @Override
    public List<TinyUrl> export(int offset, int limit) throws Exception {
        return Dao.tinyUrlDao.export(offset, limit);
    }

    @Override
    public void flush() throws Exception {
        fetch$cache.clear();
    }

    @Override
    public List<TinyUrl> fetchStatList(Integer recentDayNum, String urlTag) throws Exception {
        return Dao.tinyUrlDao.fetchStatList(recentDayNum, urlTag);
    }

    @Override
    public List<TinyUrl> fetchListByUserId(Integer userId) throws Exception {
        return Dao.tinyUrlDao.fetchListByUserId(userId);
    }
}

