/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.logicimpl;

import com.coyousoft.tugui.constant.Dao;
import com.coyousoft.tugui.entity.OpenLog;
import com.coyousoft.tugui.logic.OpenLogLogic;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class OpenLogLogicImpl
implements OpenLogLogic {
    private static final List<OpenLog> create$cache = Collections.synchronizedList(new ArrayList(1200));

    @Override
    public void create(OpenLog openLog) throws Exception {
        create$cache.add(openLog);
    }

    @Override
    public void create(List<OpenLog> openLogList) throws Exception {
        Dao.openLogDao.create(openLogList);
    }

    @Override
    public int remove(Integer logId) throws Exception {
        return Dao.openLogDao.remove(logId);
    }

    @Override
    public int update(OpenLog openLog) throws Exception {
        return Dao.openLogDao.update(openLog);
    }

    @Override
    public OpenLog fetch(Integer logId) throws Exception {
        return Dao.openLogDao.fetch(logId);
    }

    @Override
    public List<OpenLog> export(int offset, int limit) throws Exception {
        return Dao.openLogDao.export(offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws Exception {
        ArrayList<OpenLog> list = new ArrayList<OpenLog>(create$cache.size() + 100);
        List<OpenLog> list2 = create$cache;
        synchronized (list2) {
            try {
                list.addAll(create$cache);
            }
            finally {
                create$cache.clear();
            }
        }
        this.create(list);
    }

    @Override
    public List<OpenLog> fetchListByUrlId(int urlId) throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        c.add(5, -1);
        Date beginDate = c.getTime();
        c.add(5, 3);
        Date endDate = c.getTime();
        return Dao.openLogDao.fetchListByUrlId(urlId, beginDate, endDate, 600);
    }
}

