/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.logicimpl;

import com.coyousoft.tugui.constant.Dao;
import com.coyousoft.tugui.entity.LeimailClient;
import com.coyousoft.tugui.entity.LeimailUser;
import com.coyousoft.tugui.exception.SwapClientIdCountException;
import com.coyousoft.tugui.exception.SwapClientTypeException;
import com.coyousoft.tugui.logic.LeimailClientLogic;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sysolar.util.MD5;

public final class LeimailClientLogicImpl
implements LeimailClientLogic {
    private static Map<String, LeimailClient> fetchByClientKey$cacheMap = new HashMap<String, LeimailClient>(120);

    static {
        fetchByClientKey$cacheMap = Collections.synchronizedMap(fetchByClientKey$cacheMap);
    }

    @Override
    public void create(LeimailClient leimailClient) throws Exception {
        Dao.leimailClientDao.create(leimailClient);
    }

    @Override
    public void create(List<LeimailClient> leimailClientList) throws Exception {
        Dao.leimailClientDao.create(leimailClientList);
    }

    @Override
    public int remove(Integer clientId) throws Exception {
        return Dao.leimailClientDao.remove(clientId);
    }

    @Override
    public int update(LeimailClient leimailClient) throws Exception {
        return Dao.leimailClientDao.update(leimailClient);
    }

    @Override
    public LeimailClient fetch(Integer clientId) throws Exception {
        return Dao.leimailClientDao.fetch(clientId);
    }

    @Override
    public List<LeimailClient> export(int offset, int limit) throws Exception {
        return Dao.leimailClientDao.export(offset, limit);
    }

    @Override
    public void flush() throws Exception {
        fetchByClientKey$cacheMap.clear();
    }

    @Override
    public LeimailClient fetchByClientKey(String clientKey) throws Exception {
        LeimailClient client = fetchByClientKey$cacheMap.get(clientKey);
        if (client == null) {
            client = Dao.leimailClientDao.fetchByClientKey(clientKey);
            LeimailUser user = client.getLeimailUser();
            if (user != null && user.getUserPassword() != null) {
                user.setUserPassword(MD5.encoder((String)user.getUserPassword()));
            }
            fetchByClientKey$cacheMap.put(clientKey, client);
        } else {
            client.setClientId(client.getClientId() - 10000);
        }
        if (client != null) {
            this.computeRemainMs(client);
            client = this.prepareReturn(client);
        }
        return client;
    }

    private LeimailClient create(String clientKey, String hdSn) throws Exception {
        Calendar c = Calendar.getInstance();
        LeimailClient client = new LeimailClient().setClientKey(clientKey).setHdSn(hdSn).setClientType(0).setBeginDate(c.getTime());
        c.add(5, 7);
        client.setEndDate(c.getTime());
        client.setRemainDay(604800000L);
        Dao.leimailClientDao.create(client, true);
        return client;
    }

    private void computeRemainMs(LeimailClient client) {
        long remainMs = client.getEndDate().getTime() - System.currentTimeMillis();
        client.setRemainDay(remainMs);
    }

    private LeimailClient prepareReturn(LeimailClient client) {
        LeimailUser user = client.getLeimailUser();
        if (user == null || user.getUserAccount() == null) {
            client.setLeimailUser(null);
        }
        client.setClientId(10000 + client.getClientId());
        client.setSystemDate(new Date());
        return client;
    }

    @Override
    public boolean checkClientKey(String clientKey) {
        if (clientKey == null) {
            return false;
        }
        return (clientKey = clientKey.trim()).length() == 32 || clientKey.length() == 35;
    }

    @Override
    public synchronized LeimailClient shakeHands(String clientKey, String hdSn, String pcCode, Integer clientId) throws Exception {
        if (!this.checkClientKey(clientKey = clientKey.trim())) {
            return new LeimailClient().setErrorCode("ERROR_MACHINE");
        }
        LeimailClient client = Dao.leimailClientDao.fetchByClientKey(clientKey);
        if (client != null) {
            this.computeRemainMs(client);
        } else {
            if (hdSn != null && ("".equals(hdSn = hdSn.trim()) || "0".equals(hdSn))) {
                hdSn = null;
            }
            client = this.create(clientKey, hdSn);
        }
        LeimailUser user = client.getLeimailUser();
        if (user != null && user.getUserPassword() != null) {
            user.setUserPassword(MD5.encoder((String)user.getUserPassword()));
        }
        return this.prepareReturn(client);
    }

    @Override
    public List<LeimailClient> fetchListByUserId(Integer userId) throws Exception {
        return Dao.leimailClientDao.fetchListByUserId(userId);
    }

    @Override
    public void swap(Integer[] clientIdArr, String userAccount, Integer userId) throws Exception {
        if (clientIdArr == null || clientIdArr.length != 2) {
            throw new SwapClientIdCountException("\u5fc5\u987b\u9009\u62e9\u4e14\u53ea\u80fd\u9009\u62e92\u6761\u8bb0\u5f55\u4ea4\u6362\u7ed1\u5b9a");
        }
        List<LeimailClient> clientList = null;
        clientList = userAccount != null && !"".equals(userAccount.trim()) ? this.fetchListByUserAccount(userAccount) : this.fetchListByUserId(userId);
        LeimailClient sourceClient = null;
        LeimailClient targetClient = null;
        for (LeimailClient client : clientList) {
            Integer clientId = client.getClientId();
            if (clientId.equals(clientIdArr[0])) {
                sourceClient = client;
                continue;
            }
            if (clientId.equals(clientIdArr[1])) {
                targetClient = client;
                continue;
            }
            if (sourceClient != null && targetClient != null) break;
        }
        if (sourceClient == null || targetClient == null) {
            throw new SwapClientTypeException("\u6570\u636e\u4e0d\u5339\u914d,\u4ea4\u6362\u7ed1\u5b9a\u5931\u8d25");
        }
        Dao.leimailClientDao.updateClientByClient(sourceClient.getClientId(), targetClient);
        Dao.leimailClientDao.updateClientByClient(targetClient.getClientId(), sourceClient);
        this.flush();
    }

    @Override
    public LeimailClient fetchClientById$Account(Integer clientId, String account) throws Exception {
        clientId = clientId - 10000;
        List<LeimailClient> clientList = Dao.leimailClientDao.fetchListByUserAccount(account);
        for (LeimailClient client : clientList) {
            if (!clientId.equals(client.getClientId())) continue;
            return client;
        }
        return null;
    }

    @Override
    public int grant(LeimailClient client, LeimailUser user) throws Exception {
        long validGrantTime = 172800000L;
        Date endDate = new Date();
        endDate.setTime(endDate.getTime() + validGrantTime);
        client.setClientId(client.getClientId() - 10000).setAgencyId(user.getUserId()).setGrantDate(new Date()).setEndDate(endDate);
        int result = Dao.leimailClientDao.updateClientType$EndDate$AgencyIdByClientId(client);
        client = Dao.leimailClientDao.fetch(client.getClientId());
        if (client.getClientType() == 400) {
            Dao.leimailClientDao.batchGrant(client.getAdminId(), client.getClientType(), 0, 1, 2);
        }
        this.flush();
        return result;
    }

    @Override
    public int agencyBack(LeimailClient client, LeimailUser user) throws Exception {
        client.setClientId(client.getClientId() - 10000).setAgencyId(user.getUserId()).setGrantDate(new Date());
        int result = Dao.leimailClientDao.updateClientType$EndDateByAgencyId$ClientId(client);
        this.flush();
        return result;
    }

    @Override
    public List<LeimailClient> fetchListByAgencyId(Integer userId) throws Exception {
        return Dao.leimailClientDao.fetchListByAgencyId(userId);
    }

    @Override
    public int confirmGrant(LeimailClient client, LeimailUser user, Integer days) throws Exception {
        client.setClientId(client.getClientId() - 10000).setAdminId(user.getUserId());
        int result = Dao.leimailClientDao.updateClientStatus$EndDate$adminIdByClientId$ClientStatus(client, days);
        client = Dao.leimailClientDao.fetch(client.getClientId());
        if (client.getClientType() == 400) {
            Dao.leimailClientDao.batchGrant(client.getAdminId(), client.getClientType(), 1, 2, days);
        }
        this.flush();
        return result;
    }

    @Override
    public int closeGrant(LeimailClient client, LeimailUser user) throws Exception {
        client.setClientId(client.getClientId() - 10000).setAdminId(user.getUserId());
        int result = Dao.leimailClientDao.updateEndDate$adminIdByClientId(client);
        this.flush();
        return result;
    }

    @Override
    public int updateClientType(LeimailClient client, LeimailUser user) throws Exception {
        client.setClientId(client.getClientId() - 10000).setAdminId(user.getUserId());
        int result = Dao.leimailClientDao.updateClientType$adminIdByClinetId(client);
        LeimailClient clientInCache = fetchByClientKey$cacheMap.get(client.getClientKey());
        if (clientInCache != null) {
            clientInCache.setClientType(client.getClientType());
        }
        return result;
    }

    @Override
    public int extension(LeimailClient client, LeimailUser user, Integer days) throws Exception {
        client.setClientId(client.getClientId() - 10000).setAdminId(user.getUserId());
        int result = Dao.leimailClientDao.extensionEndDate(client, days);
        this.flush();
        return result;
    }

    @Override
    public List<LeimailClient> fetchListByClientStatus(int clientStatus) throws Exception {
        return Dao.leimailClientDao.fetchListByClientStatus(clientStatus);
    }

    @Override
    public List<LeimailClient> fetchListByUserAccount(String userAccount) throws Exception {
        return Dao.leimailClientDao.fetchListByUserAccount(userAccount);
    }

    @Override
    public int unBind(LeimailClient client) throws Exception {
        client.setClientId(client.getClientId() - 10000);
        int result = Dao.userClientDao.removeByClientId(client);
        client.setClientType(0);
        Dao.leimailClientDao.updateClientType$adminIdByClinetId(client);
        this.flush();
        return result;
    }

    @Override
    public LeimailClient checkHeartbeatCycle(String clientKey, Integer standCycle) throws Exception {
        LeimailClient client = fetchByClientKey$cacheMap.get(clientKey);
        if (client == null) {
            return null;
        }
        if (client.getClientType().equals(400) || client.getClientType().equals(1000) || client.getClientType().equals(99)) {
            return client;
        }
        Long lastHeartBeatTime = client.getLastHeartBeatTime();
        long currentTime = System.currentTimeMillis();
        if (lastHeartBeatTime == null || currentTime - lastHeartBeatTime > (long)(standCycle * 30 * 1000)) {
            client.setLastHeartBeatTime(currentTime);
        } else {
            client.setSystemDate(new Date());
            client.setRemainDay(-1L);
        }
        return client;
    }
}

