/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.logicimpl;

import com.coyousoft.tugui.constant.Dao;
import com.coyousoft.tugui.entity.Fun;
import com.coyousoft.tugui.logic.FunLogic;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.jdbc.core.Transactions;

public final class FunLogicImpl
implements FunLogic {
    private static List<Fun> list = null;
    private static Map<Integer, Fun> map = new HashMap<Integer, Fun>(128);

    @Override
    public void create(Fun fun) throws Exception {
        Dao.funDao.create(fun);
    }

    @Override
    public void create(List<Fun> funList) throws Exception {
        Dao.funDao.create(funList);
    }

    @Override
    public int remove(Integer funId) throws Exception {
        return Dao.funDao.remove(funId);
    }

    @Override
    public int update(Fun fun) throws Exception {
        return Dao.funDao.update(fun);
    }

    @Override
    public Fun fetch(Integer funId) throws Exception {
        Fun fun;
        if (list == null) {
            this.flush();
        }
        if ((fun = map.get(funId)) != null) {
            return fun.clone().setFunName(URLEncoder.encode(fun.getFunName(), "UTF-8"));
        }
        return null;
    }

    @Override
    public List<Fun> export(int offset, int limit) throws Exception {
        return Dao.funDao.export(offset, limit);
    }

    @Override
    public void flush() throws Exception {
        try {
            list = Dao.funDao.fetchList();
        }
        finally {
            Transactions.close();
        }
        for (Fun fun : list) {
            if (fun.getUseType() == 1) {
                fun.setUseRole(1);
            } else {
                fun.setUseRole(0);
            }
            map.put(fun.getFunId(), fun);
        }
    }
}

