/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.logicimpl;

import com.coyousoft.tugui.constant.Dao;
import com.coyousoft.tugui.entity.ClientLog;
import com.coyousoft.tugui.logic.ClientLogLogic;
import java.util.Calendar;
import java.util.List;
import org.sysolar.sun.cache.CacheMap;

public final class ClientLogLogicImpl
implements ClientLogLogic {
    private static final CacheMap<String, ClientLog> create$cacheMap = new CacheMap(1000, Integer.valueOf(1200));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(ClientLog clientLog) throws Exception {
        CacheMap<String, ClientLog> cacheMap = create$cacheMap;
        synchronized (cacheMap) {
            StringBuilder buffer = new StringBuilder(256);
            buffer.append(clientLog.getClientId()).append("-").append(clientLog.getClientIp());
            create$cacheMap.put((Object)buffer.toString(), (Object)clientLog);
        }
        if (create$cacheMap.isExpired()) {
            this.flush();
        }
    }

    @Override
    public void create(List<ClientLog> clientLogList) throws Exception {
        Dao.clientLogDao.create(clientLogList);
    }

    @Override
    public int remove(Integer logId) throws Exception {
        return Dao.clientLogDao.remove(logId);
    }

    @Override
    public int update(ClientLog clientLog) throws Exception {
        return Dao.clientLogDao.update(clientLog);
    }

    @Override
    public ClientLog fetch(Integer logId) throws Exception {
        return Dao.clientLogDao.fetch(logId);
    }

    @Override
    public List<ClientLog> export(int offset, int limit) throws Exception {
        return Dao.clientLogDao.export(offset, limit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws Exception {
        Calendar c = Calendar.getInstance();
        c.set(c.get(1), c.get(2), c.get(5), 0, 0, 0);
        CacheMap<String, ClientLog> cacheMap = create$cacheMap;
        synchronized (cacheMap) {
            try {
                for (ClientLog log : create$cacheMap.values()) {
                    if (Dao.clientLogDao.fetchByClientIp(log.getClientId(), log.getClientIp(), c.getTime()) != null) continue;
                    Dao.clientLogDao.create(log);
                }
            }
            finally {
                create$cacheMap.clear();
            }
        }
    }
}

