/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.UserClientDao;
import com.coyousoft.tugui.entity.LeimailClient;
import com.coyousoft.tugui.entity.UserClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class UserClientDaoImpl
implements UserClientDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(UserClientDao.class);

    @Override
    public void create(UserClient userClient) throws Exception {
        this.create(userClient, false);
    }

    @Override
    public void create(UserClient userClient, boolean setId) throws Exception {
        this.dao.update("insert into USER_CLIENT ( SHIP_ID,USER_ID,CLIENT_ID,SHIP_CDATE ) values ( ?,?,?,? )", userClient.setDefault().toArray());
        if (setId) {
            userClient.setShipId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<UserClient> userClientList) throws Exception {
        if (userClientList == null || userClientList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(userClientList.size());
        for (UserClient userClient : userClientList) {
            params.add(userClient.setDefault().toArray());
        }
        this.dao.update("insert into USER_CLIENT ( SHIP_ID,USER_ID,CLIENT_ID,SHIP_CDATE ) values ( ?,?,?,? )", params);
    }

    @Override
    public int remove(Integer shipId) throws Exception {
        return this.dao.update("delete from USER_CLIENT where SHIP_ID=?", new Object[]{shipId});
    }

    @Override
    public int update(UserClient userClient) throws Exception {
        ArrayList<Comparable<Integer>> params = new ArrayList<Comparable<Integer>>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update USER_CLIENT set ");
        if (userClient.getUserId() != null) {
            buffer.append("USER_ID=?,");
            params.add(userClient.getUserId());
        }
        if (userClient.getClientId() != null) {
            buffer.append("CLIENT_ID=?,");
            params.add(userClient.getClientId());
        }
        if (userClient.getShipCdate() != null) {
            buffer.append("SHIP_CDATE=?,");
            params.add(userClient.getShipCdate());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where SHIP_ID = ?");
        params.add(userClient.getShipId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public UserClient fetch(Integer shipId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from USER_CLIENT where SHIP_ID=?", new Object[]{shipId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new UserClient().fill(row);
        }
        return null;
    }

    @Override
    public List<UserClient> export(int offset, int limit) throws Exception {
        ArrayList<UserClient> list = new ArrayList<UserClient>(limit);
        for (Map row : this.dao.queryForList("select * from USER_CLIENT order by SHIP_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new UserClient().fill(row));
        }
        return list;
    }

    @Override
    public int removeByClientId(LeimailClient client) throws Exception {
        return this.dao.update("delete from USER_CLIENT where CLIENT_ID=?", new Object[]{client.getClientId()});
    }
}

