/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.constant.Sql;
import com.coyousoft.tugui.dao.TinyUrlDao;
import com.coyousoft.tugui.entity.OpenLog;
import com.coyousoft.tugui.entity.TinyUrl;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;
import org.sysolar.sun.jdbc.support.Sqler;

public final class TinyUrlDaoImpl
implements TinyUrlDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(TinyUrlDao.class);

    @Override
    public void create(TinyUrl tinyUrl) throws Exception {
        this.create(tinyUrl, false);
    }

    @Override
    public void create(TinyUrl tinyUrl, boolean setId) throws Exception {
        this.dao.update("insert into TINY_URL ( URL_ID,USER_ID,URL_HREF,STAT_TYPE,URL_NAME,URL_CDATE ) values ( ?,?,?,?,?,? )", tinyUrl.setDefault().toArray());
        if (setId) {
            tinyUrl.setUrlId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<TinyUrl> tinyUrlList) throws Exception {
        if (tinyUrlList == null || tinyUrlList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(tinyUrlList.size());
        for (TinyUrl tinyUrl : tinyUrlList) {
            params.add(tinyUrl.setDefault().toArray());
        }
        this.dao.update("insert into TINY_URL ( URL_ID,USER_ID,URL_HREF,STAT_TYPE,URL_NAME,URL_CDATE ) values ( ?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer urlId) throws Exception {
        return this.dao.update("delete from TINY_URL where URL_ID=?", new Object[]{urlId});
    }

    @Override
    public int update(TinyUrl tinyUrl) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update TINY_URL set ");
        if (tinyUrl.getUrlHref() != null) {
            buffer.append("URL_HREF=?,");
            params.add(tinyUrl.getUrlHref());
        }
        if (tinyUrl.getUrlName() != null) {
            buffer.append("URL_NAME=?,");
            params.add(tinyUrl.getUrlName());
        }
        if (tinyUrl.getUrlCdate() != null) {
            buffer.append("URL_CDATE=?,");
            params.add(tinyUrl.getUrlCdate());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where URL_ID = ?");
        params.add(tinyUrl.getUrlId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public TinyUrl fetch(Integer urlId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from TINY_URL where URL_ID=?", new Object[]{urlId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new TinyUrl().fill(row);
        }
        return null;
    }

    @Override
    public List<TinyUrl> export(int offset, int limit) throws Exception {
        ArrayList<TinyUrl> list = new ArrayList<TinyUrl>(limit);
        for (Map row : this.dao.queryForList("select * from TINY_URL order by URL_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new TinyUrl().fill(row));
        }
        return list;
    }

    @Override
    public List<TinyUrl> fetchStatList(Integer recentDayNum, String urlTag) throws Exception {
        Calendar c = Calendar.getInstance();
        c.add(5, -1 * (recentDayNum - 1));
        c.set(10, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        LinkedHashMap<Integer, TinyUrl> tinyUrlMap = new LinkedHashMap<Integer, TinyUrl>(48);
        TinyUrl tinyUrl = null;
        OpenLog openLog = null;
        Date maxDate = null;
        Date minDate = null;
        String sql = Sql.TinyUrlSql.fetchStatList;
        List list = null;
        if ("all".equals(urlTag)) {
            sql = Sqler.remove((String)sql, (int[])new int[]{1});
            list = this.dao.queryForList(sql, new Object[]{c.getTime()});
        } else {
            list = this.dao.queryForList(sql, new Object[]{c.getTime(), urlTag});
        }
        for (Map row : list) {
            tinyUrl = new TinyUrl().fill(row);
            if (!tinyUrlMap.containsKey(tinyUrl.getUrlId())) {
                tinyUrlMap.put(tinyUrl.getUrlId(), tinyUrl);
            } else {
                tinyUrl = (TinyUrl)tinyUrlMap.get(tinyUrl.getUrlId());
            }
            openLog = new OpenLog().fill(row);
            tinyUrl.add(openLog);
            openLog.setIpNum(((Number)row.get("IP_NUM")).intValue());
            openLog.setIpTime(((Number)row.get("IP_TIME")).intValue());
            if (minDate == null) {
                minDate = openLog.getOpenDate();
                maxDate = openLog.getOpenDate();
                continue;
            }
            if (minDate.compareTo(openLog.getOpenDate()) > 0) {
                minDate = openLog.getOpenDate();
            }
            if (maxDate.compareTo(openLog.getOpenDate()) >= 0) continue;
            maxDate = openLog.getOpenDate();
        }
        if (maxDate == null) {
            return new ArrayList<TinyUrl>(0);
        }
        int day = 86400000;
        Long[] dateArr = new Long[(int)((maxDate.getTime() - minDate.getTime()) / (long)day) + 1];
        int i = 0;
        while (i < dateArr.length) {
            dateArr[i] = minDate.getTime() + (long)(i * day);
            ++i;
        }
        ArrayList<TinyUrl> tinyUrlList = new ArrayList<TinyUrl>(tinyUrlMap.values());
        for (TinyUrl url : tinyUrlList) {
            TreeMap<Long, OpenLog> tinyMap = new TreeMap<Long, OpenLog>();
            for (OpenLog log : url.getOpenLogList()) {
                tinyMap.put(log.getOpenDate().getTime(), log);
            }
            int i2 = 0;
            while (i2 < dateArr.length) {
                OpenLog temp = (OpenLog)tinyMap.get(dateArr[i2]);
                if (temp == null) {
                    tinyMap.put(dateArr[i2], new OpenLog().setIpNum(0).setIpTime(0).setOpenDate(new Date(dateArr[i2])));
                }
                ++i2;
            }
            url.getOpenLogList().clear();
            url.getOpenLogList().addAll(tinyMap.values());
        }
        return tinyUrlList;
    }

    @Override
    public TinyUrl fetchByUrlHref(String urlHref) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from TINY_URL where URL_HREF=?", new Object[]{urlHref}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new TinyUrl().fill(row);
        }
        return null;
    }

    @Override
    public List<TinyUrl> fetchListByUserId(Integer userId) throws Exception {
        ArrayList<TinyUrl> list = new ArrayList<TinyUrl>(12);
        for (Map row : this.dao.queryForList("select * from TINY_URL where USER_ID=? order by URL_NAME asc,URL_ID asc", new Object[]{userId})) {
            list.add(new TinyUrl().fill(row));
        }
        return list;
    }
}

