/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.SaleRecordDao;
import com.coyousoft.tugui.entity.SaleRecord;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class SaleRecordDaoImpl
implements SaleRecordDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(SaleRecordDao.class);

    @Override
    public void create(SaleRecord saleRecord) throws Exception {
        this.create(saleRecord, false);
    }

    @Override
    public void create(SaleRecord saleRecord, boolean setId) throws Exception {
        this.dao.update("insert into SALE_RECORD ( RECORD_ID,CLIENT_ID,CLIENT_TYPE,USER_ID,CDATE,AGENCY_ID,SALE_TYPE,SALE_PRICE,SALE_MEMO,CONFIRM_STATUS,CONFIRM_DATE,ADMIN_ID ) values ( ?,?,?,?,?,?,?,?,?,?,?,? )", saleRecord.setDefault().toArray());
        if (setId) {
            saleRecord.setRecordId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<SaleRecord> saleRecordList) throws Exception {
        if (saleRecordList == null || saleRecordList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(saleRecordList.size());
        for (SaleRecord saleRecord : saleRecordList) {
            params.add(saleRecord.setDefault().toArray());
        }
        this.dao.update("insert into SALE_RECORD ( RECORD_ID,CLIENT_ID,CLIENT_TYPE,USER_ID,CDATE,AGENCY_ID,SALE_TYPE,SALE_PRICE,SALE_MEMO,CONFIRM_STATUS,CONFIRM_DATE,ADMIN_ID ) values ( ?,?,?,?,?,?,?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer recordId) throws Exception {
        return this.dao.update("delete from SALE_RECORD where RECORD_ID=?", new Object[]{recordId});
    }

    @Override
    public int update(SaleRecord saleRecord) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update SALE_RECORD set ");
        if (saleRecord.getClientId() != null) {
            buffer.append("CLIENT_ID=?,");
            params.add(saleRecord.getClientId());
        }
        if (saleRecord.getClientType() != null) {
            buffer.append("CLIENT_TYPE=?,");
            params.add(saleRecord.getClientType());
        }
        if (saleRecord.getUserId() != null) {
            buffer.append("USER_ID=?,");
            params.add(saleRecord.getUserId());
        }
        if (saleRecord.getCdate() != null) {
            buffer.append("CDATE=?,");
            params.add(saleRecord.getCdate());
        }
        if (saleRecord.getAgencyId() != null) {
            buffer.append("AGENCY_ID=?,");
            params.add(saleRecord.getAgencyId());
        }
        if (saleRecord.getSaleType() != null) {
            buffer.append("SALE_TYPE=?,");
            params.add(saleRecord.getSaleType());
        }
        if (saleRecord.getSalePrice() != null) {
            buffer.append("SALE_PRICE=?,");
            params.add(saleRecord.getSalePrice());
        }
        if (saleRecord.getSaleMemo() != null) {
            buffer.append("SALE_MEMO=?,");
            params.add(saleRecord.getSaleMemo());
        }
        if (saleRecord.getConfirmStatus() != null) {
            buffer.append("CONFIRM_STATUS=?,");
            params.add(saleRecord.getConfirmStatus());
        }
        if (saleRecord.getConfirmDate() != null) {
            buffer.append("CONFIRM_DATE=?,");
            params.add(saleRecord.getConfirmDate());
        }
        if (saleRecord.getAdminId() != null) {
            buffer.append("ADMIN_ID=?,");
            params.add(saleRecord.getAdminId());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where RECORD_ID = ?");
        params.add(saleRecord.getRecordId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public SaleRecord fetch(Integer recordId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from SALE_RECORD where RECORD_ID=?", new Object[]{recordId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new SaleRecord().fill(row);
        }
        return null;
    }

    @Override
    public List<SaleRecord> export(int offset, int limit) throws Exception {
        ArrayList<SaleRecord> list = new ArrayList<SaleRecord>(limit);
        for (Map row : this.dao.queryForList("select * from SALE_RECORD order by RECORD_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new SaleRecord().fill(row));
        }
        return list;
    }
}

