/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.OpenLogDao;
import com.coyousoft.tugui.entity.OpenLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class OpenLogDaoImpl
implements OpenLogDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(OpenLogDao.class);

    @Override
    public void create(OpenLog openLog) throws Exception {
        this.create(openLog, false);
    }

    @Override
    public void create(OpenLog openLog, boolean setId) throws Exception {
        this.dao.update("insert into OPEN_LOG ( LOG_ID,URL_ID,OPEN_DATE,SEND_DATE,FROM_IP,FROM_REFERER ) values ( ?,?,?,?,?,? )", openLog.setDefault().toArray());
        if (setId) {
            openLog.setLogId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<OpenLog> openLogList) throws Exception {
        if (openLogList == null || openLogList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(openLogList.size());
        for (OpenLog openLog : openLogList) {
            params.add(openLog.setDefault().toArray());
        }
        this.dao.update("insert into OPEN_LOG ( LOG_ID,URL_ID,OPEN_DATE,SEND_DATE,FROM_IP,FROM_REFERER ) values ( ?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer logId) throws Exception {
        return this.dao.update("delete from OPEN_LOG where LOG_ID=?", new Object[]{logId});
    }

    @Override
    public int update(OpenLog openLog) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update OPEN_LOG set ");
        if (openLog.getUrlId() != null) {
            buffer.append("URL_ID=?,");
            params.add(openLog.getUrlId());
        }
        if (openLog.getOpenDate() != null) {
            buffer.append("OPEN_DATE=?,");
            params.add(openLog.getOpenDate());
        }
        if (openLog.getSendDate() != null) {
            buffer.append("SEND_DATE=?,");
            params.add(openLog.getSendDate());
        }
        if (openLog.getFromIp() != null) {
            buffer.append("FROM_IP=?,");
            params.add(openLog.getFromIp());
        }
        if (openLog.getFromReferer() != null) {
            buffer.append("FROM_REFERER=?,");
            params.add(openLog.getFromReferer());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where LOG_ID = ?");
        params.add(openLog.getLogId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public OpenLog fetch(Integer logId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from OPEN_LOG where LOG_ID=?", new Object[]{logId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new OpenLog().fill(row);
        }
        return null;
    }

    @Override
    public List<OpenLog> export(int offset, int limit) throws Exception {
        ArrayList<OpenLog> list = new ArrayList<OpenLog>(limit);
        for (Map row : this.dao.queryForList("select * from OPEN_LOG order by LOG_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new OpenLog().fill(row));
        }
        return list;
    }

    @Override
    public List<OpenLog> fetchListByUrlId(int urlId, Date beginDate, Date endDate, int limit) throws Exception {
        ArrayList<OpenLog> list = new ArrayList<OpenLog>(limit);
        for (Map row : this.dao.queryForList("select T.* from ( select FROM_IP,count(LOG_ID) IP_NUM,min(OPEN_DATE) OPEN_DATE,max(OPEN_DATE) LAST_OPEN_DATE,min(SEND_DATE) SEND_DATE,min(FROM_REFERER) FROM_REFERER from OPEN_LOG where URL_ID=? and OPEN_DATE >=? and OPEN_DATE < ? group by FROM_IP) T order by T.LAST_OPEN_DATE desc limit ?", new Object[]{urlId, beginDate, endDate, limit})) {
            list.add(new OpenLog().fill(row));
        }
        return list;
    }
}

