/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.LeimailUserDao;
import com.coyousoft.tugui.entity.LeimailUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class LeimailUserDaoImpl
implements LeimailUserDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(LeimailUserDao.class);

    @Override
    public void create(LeimailUser leimailUser) throws Exception {
        this.create(leimailUser, false);
    }

    @Override
    public void create(LeimailUser leimailUser, boolean setId) throws Exception {
        this.dao.update("insert into LEIMAIL_USER ( USER_ID,USER_ACCOUNT,USER_PASSWORD,USER_TYPE,REGISTER_DATE,LOGIN_DATE,LOGIN_TIME,USER_NICKNAME,USER_MEMO ) values ( ?,?,?,?,?,?,?,?,? )", leimailUser.setDefault().toArray());
        if (setId) {
            leimailUser.setUserId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<LeimailUser> leimailUserList) throws Exception {
        if (leimailUserList == null || leimailUserList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(leimailUserList.size());
        for (LeimailUser leimailUser : leimailUserList) {
            params.add(leimailUser.setDefault().toArray());
        }
        this.dao.update("insert into LEIMAIL_USER ( USER_ID,USER_ACCOUNT,USER_PASSWORD,USER_TYPE,REGISTER_DATE,LOGIN_DATE,LOGIN_TIME,USER_NICKNAME,USER_MEMO ) values ( ?,?,?,?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer userId) throws Exception {
        return this.dao.update("delete from LEIMAIL_USER where USER_ID=?", new Object[]{userId});
    }

    @Override
    public int update(LeimailUser leimailUser) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update LEIMAIL_USER set ");
        if (leimailUser.getUserAccount() != null) {
            buffer.append("USER_ACCOUNT=?,");
            params.add(leimailUser.getUserAccount());
        }
        if (leimailUser.getUserPassword() != null) {
            buffer.append("USER_PASSWORD=?,");
            params.add(leimailUser.getUserPassword());
        }
        if (leimailUser.getRegisterDate() != null) {
            buffer.append("REGISTER_DATE=?,");
            params.add(leimailUser.getRegisterDate());
        }
        if (leimailUser.getLoginDate() != null) {
            buffer.append("LOGIN_DATE=?,");
            params.add(leimailUser.getLoginDate());
        }
        if (leimailUser.getLoginTime() != null) {
            buffer.append("LOGIN_TIME=?,");
            params.add(leimailUser.getLoginTime());
        }
        if (leimailUser.getUserNickname() != null) {
            buffer.append("USER_NICKNAME=?,");
            params.add(leimailUser.getUserNickname());
        }
        if (leimailUser.getUserMemo() != null) {
            buffer.append("USER_MEMO=?,");
            params.add(leimailUser.getUserMemo());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where USER_ID = ?");
        params.add(leimailUser.getUserId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public LeimailUser fetch(Integer userId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from LEIMAIL_USER where USER_ID=?", new Object[]{userId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new LeimailUser().fill(row);
        }
        return null;
    }

    @Override
    public List<LeimailUser> export(int offset, int limit) throws Exception {
        ArrayList<LeimailUser> list = new ArrayList<LeimailUser>(limit);
        for (Map row : this.dao.queryForList("select * from LEIMAIL_USER order by USER_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new LeimailUser().fill(row));
        }
        return list;
    }

    @Override
    public LeimailUser fetchByUserAccount(String userAccount) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from LEIMAIL_USER where USER_ACCOUNT=?", new Object[]{userAccount}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new LeimailUser().fill(row);
        }
        return null;
    }

    @Override
    public LeimailUser fetchBy$userAccount$clientId(String userAccount, Integer clientId) throws Exception {
        String sql = "select T1.* from LEIMAIL_USER T1 inner join USER_CLIENT T2 on T1.USER_ID=T2.USER_ID where T1.USER_ACCOUNT=? and T2.CLIENT_ID=?";
        Iterator iterator = this.dao.queryForList(sql, new Object[]{userAccount, clientId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new LeimailUser().fill(row);
        }
        return null;
    }

    @Override
    public LeimailUser fetchBy$userAccount$password(LeimailUser user) throws Exception {
        String sql = "select * from LEIMAIL_USER where USER_ACCOUNT=? and USER_PASSWORD=?";
        String userAccount = user.getUserAccount();
        String password = user.getUserPassword();
        Iterator iterator = this.dao.queryForList(sql, new Object[]{userAccount, password}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new LeimailUser().fill(row);
        }
        return null;
    }

    @Override
    public int updateUserTypeByUserAccount(LeimailUser agency) throws Exception {
        return this.dao.update("update LEIMAIL_USER set USER_TYPE=? where USER_ACCOUNT=?", new Object[]{agency.getUserType(), agency.getUserAccount()});
    }
}

