/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.LeimailClientDao;
import com.coyousoft.tugui.entity.LeimailClient;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class LeimailClientDaoImpl
implements LeimailClientDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(LeimailClientDao.class);

    @Override
    public void create(LeimailClient leimailClient) throws Exception {
        this.create(leimailClient, false);
    }

    @Override
    public void create(LeimailClient leimailClient, boolean setId) throws Exception {
        this.dao.update("insert into LEIMAIL_CLIENT ( CLIENT_ID,CLIENT_KEY,CLIENT_TYPE,CLIENT_STATUS,BEGIN_DATE,GRANT_DATE,AGENCY_ID,CONFIRM_DATE,ADMIN_ID,END_DATE,THREAD_NUM,HD_SN,CLIENT_MEMO ) values ( ?,?,?,?,?,?,?,?,?,?,?,?,? )", leimailClient.setDefault().toArray());
        if (setId) {
            leimailClient.setClientId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<LeimailClient> leimailClientList) throws Exception {
        if (leimailClientList == null || leimailClientList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(leimailClientList.size());
        for (LeimailClient leimailClient : leimailClientList) {
            params.add(leimailClient.setDefault().toArray());
        }
        this.dao.update("insert into LEIMAIL_CLIENT ( CLIENT_ID,CLIENT_KEY,CLIENT_TYPE,CLIENT_STATUS,BEGIN_DATE,GRANT_DATE,AGENCY_ID,CONFIRM_DATE,ADMIN_ID,END_DATE,THREAD_NUM,HD_SN,CLIENT_MEMO ) values ( ?,?,?,?,?,?,?,?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer clientId) throws Exception {
        return this.dao.update("delete from LEIMAIL_CLIENT where CLIENT_ID=?", new Object[]{clientId});
    }

    @Override
    public int update(LeimailClient leimailClient) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update LEIMAIL_CLIENT set ");
        if (leimailClient.getClientKey() != null) {
            buffer.append("CLIENT_KEY=?,");
            params.add(leimailClient.getClientKey());
        }
        if (leimailClient.getClientType() != null) {
            buffer.append("CLIENT_TYPE=?,");
            params.add(leimailClient.getClientType());
        }
        if (leimailClient.getBeginDate() != null) {
            buffer.append("BEGIN_DATE=?,");
            params.add(leimailClient.getBeginDate());
        }
        if (leimailClient.getEndDate() != null) {
            buffer.append("END_DATE=?,");
            params.add(leimailClient.getEndDate());
        }
        if (leimailClient.getClientMemo() != null) {
            buffer.append("CLIENT_MEMO=?,");
            params.add(leimailClient.getClientMemo());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where CLIENT_ID = ?");
        params.add(leimailClient.getClientId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public LeimailClient fetch(Integer clientId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from LEIMAIL_CLIENT where CLIENT_ID=?", new Object[]{clientId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new LeimailClient().fill(row);
        }
        return null;
    }

    @Override
    public List<LeimailClient> export(int offset, int limit) throws Exception {
        ArrayList<LeimailClient> list = new ArrayList<LeimailClient>(limit);
        for (Map row : this.dao.queryForList("select * from LEIMAIL_CLIENT order by CLIENT_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new LeimailClient().fill(row));
        }
        return list;
    }

    @Override
    public LeimailClient fetchByClientKey(String clientKey) throws Exception {
        Iterator iterator = this.dao.queryForList("select T1.CLIENT_ID,T1.CLIENT_KEY,T1.CLIENT_TYPE,T1.THREAD_NUM,T1.BEGIN_DATE,T1.END_DATE,T3.USER_ID,T3.USER_ACCOUNT,T3.USER_PASSWORD from LEIMAIL_CLIENT T1 left join USER_CLIENT T2 on T1.CLIENT_ID=T2.CLIENT_ID left join LEIMAIL_USER T3 on T3.USER_ID=T2.USER_ID where T1.CLIENT_KEY=?", new Object[]{clientKey}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new LeimailClient().fill(row, true, false);
        }
        return null;
    }

    @Override
    public List<LeimailClient> fetchByHdSn(String hdSn) throws Exception {
        ArrayList<LeimailClient> clientList = new ArrayList<LeimailClient>(12);
        for (Map row : this.dao.queryForList("select T1.CLIENT_ID,T1.CLIENT_KEY,T1.CLIENT_TYPE,T1.BEGIN_DATE,T1.END_DATE,T3.USER_ID,T3.USER_ACCOUNT,T3.USER_PASSWORD from LEIMAIL_CLIENT T1 left join USER_CLIENT T2 on T1.CLIENT_ID=T2.CLIENT_ID left join LEIMAIL_USER T3 on T3.USER_ID=T2.USER_ID where T1.HD_SN=?", new Object[]{hdSn})) {
            clientList.add(new LeimailClient().fill(row, true, false));
        }
        return clientList;
    }

    @Override
    public int updateClientKeyByClientId(String clientKey, Integer clientId) throws Exception {
        return this.dao.update("update LEIMAIL_CLIENT set CLIENT_KEY=? where CLIENT_ID=?", new Object[]{clientKey, clientId});
    }

    @Override
    public int updateClientKeyByHdSn(String clientKey, String hdSn) throws Exception {
        return this.dao.update("update LEIMAIL_CLIENT set CLIENT_KEY=? where HD_SN=?", new Object[]{clientKey, hdSn});
    }

    @Override
    public List<LeimailClient> fetchListByUserId(Integer userId) throws Exception {
        ArrayList<LeimailClient> list = new ArrayList<LeimailClient>(3);
        for (Map row : this.dao.queryForList("select T1.*,T2.*,T3.* from LEIMAIL_CLIENT T1 inner join USER_CLIENT T2 on T1.CLIENT_ID=T2.CLIENT_ID inner join LEIMAIL_USER T3 on T2.USER_ID=T3.USER_ID where T2.USER_ID=? order by T1.CLIENT_TYPE desc", new Object[]{userId})) {
            list.add(new LeimailClient().fill(row, false, true));
        }
        return list;
    }

    @Override
    public void updateClientByClient(Integer clientId, LeimailClient client) throws Exception {
        this.dao.update("update LEIMAIL_CLIENT set CLIENT_TYPE=?,CLIENT_STATUS=?,GRANT_DATE=?,AGENCY_ID=?,CONFIRM_DATE=?,ADMIN_ID=?,END_DATE=?,THREAD_NUM=? where CLIENT_ID=?", new Object[]{client.getClientType(), client.getClientStatus(), client.getGrantDate(), client.getAgencyId(), client.getConfirmDate(), client.getAdminId(), client.getEndDate(), client.getThreadNum(), clientId});
    }

    @Override
    public List<LeimailClient> fetchListByUserAccount(String account) throws Exception {
        ArrayList<LeimailClient> list = new ArrayList<LeimailClient>(3);
        for (Map row : this.dao.queryForList("select T1.*,T3.* from LEIMAIL_CLIENT T1 inner join USER_CLIENT T2 on T1.CLIENT_ID=T2.CLIENT_ID inner join LEIMAIL_USER T3 on T2.USER_ID=T3.USER_ID where T3.USER_ACCOUNT=? order by T1.CLIENT_TYPE desc,T1.CLIENT_ID desc", new Object[]{account})) {
            list.add(new LeimailClient().fill(row, false, true));
        }
        return list;
    }

    @Override
    public int updateClientType$EndDate$AgencyIdByClientId(LeimailClient client) throws Exception {
        return this.dao.update("update LEIMAIL_CLIENT set CLIENT_TYPE=?,END_DATE=?,GRANT_DATE=?,AGENCY_ID=?,CLIENT_STATUS=? where CLIENT_ID=? and CLIENT_TYPE=?", new Object[]{client.getClientType(), client.getEndDate(), client.getGrantDate(), client.getAgencyId(), 1, client.getClientId(), 0});
    }

    @Override
    public int updateClientType$EndDateByAgencyId$ClientId(LeimailClient client) throws Exception {
        return this.dao.update("update LEIMAIL_CLIENT set CLIENT_TYPE=?,END_DATE=ADDDATE(BEGIN_DATE,7),GRANT_DATE=?,CLIENT_STATUS=? where CLIENT_ID=? and CLIENT_TYPE !=? and AGENCY_ID=? and CLIENT_STATUS=?", new Object[]{0, client.getGrantDate(), 0, client.getClientId(), 0, client.getAgencyId(), 1});
    }

    @Override
    public List<LeimailClient> fetchListByAgencyId(Integer userId) throws Exception {
        ArrayList<LeimailClient> list = new ArrayList<LeimailClient>(20);
        for (Map row : this.dao.queryForList("select T1.*,T3.* from LEIMAIL_CLIENT T1 inner join USER_CLIENT T2 on T1.CLIENT_ID=T2.CLIENT_ID inner join LEIMAIL_USER T3 on T2.USER_ID=T3.USER_ID where T1.AGENCY_ID=?", new Object[]{userId})) {
            list.add(new LeimailClient().fill(row, true, false));
        }
        return list;
    }

    @Override
    public int updateClientStatus$EndDate$adminIdByClientId$ClientStatus(LeimailClient client, Integer days) throws Exception {
        String sql = "update LEIMAIL_CLIENT set CLIENT_STATUS=?,END_DATE=ADDDATE(GRANT_DATE,?),ADMIN_ID=? where CLIENT_ID=? and CLIENT_STATUS=?";
        return this.dao.update(sql, new Object[]{2, days, client.getAdminId(), client.getClientId(), 1});
    }

    @Override
    public int updateEndDate$adminIdByClientId(LeimailClient client) throws Exception {
        return this.dao.update("update LEIMAIL_CLIENT set END_DATE=BEGIN_DATE,CLIENT_TYPE=?,CLIENT_STATUS=?,ADMIN_ID=? where CLIENT_ID=?", new Object[]{0, 0, client.getAdminId(), client.getClientId()});
    }

    @Override
    public int updateClientType$adminIdByClinetId(LeimailClient client) throws Exception {
        return this.dao.update("update LEIMAIL_CLIENT set CLIENT_TYPE=?,ADMIN_ID=? where CLIENT_ID=?", new Object[]{client.getClientType(), client.getAdminId(), client.getClientId()});
    }

    @Override
    public int extensionEndDate(LeimailClient client, Integer days) throws Exception {
        return this.dao.update("update LEIMAIL_CLIENT set END_DATE=ADDDATE(END_DATE,?),ADMIN_ID=? where CLIENT_ID=?", new Object[]{days, client.getAdminId(), client.getClientId()});
    }

    @Override
    public List<LeimailClient> fetchListByClientStatus(int clientStatus) throws Exception {
        ArrayList<LeimailClient> list = new ArrayList<LeimailClient>(20);
        String sql = "select T1.*,T2.* from LEIMAIL_CLIENT T1 inner join LEIMAIL_USER T2 on T1.AGENCY_ID=T2.USER_ID where T1.CLIENT_STATUS=? order by T1.CLIENT_TYPE desc";
        for (Map row : this.dao.queryForList(sql, new Object[]{clientStatus})) {
            list.add(new LeimailClient().fill(row, true, false));
        }
        return list;
    }

    @Override
    public int removeByClientId(LeimailClient client) throws Exception {
        return this.dao.update("delete from LEIMAIL_CLIENT where CLIENT_ID=?", new Object[]{client.getClientId()});
    }

    @Override
    public int batchGrant(Integer adminId, Integer clientType, Integer oldClientStatus, Integer newClientStatus, Integer days) throws Exception {
        return this.dao.update("update LEIMAIL_CLIENT set CLIENT_STATUS=?,END_DATE=ADDDATE(now(),?),ADMIN_ID=? where CLIENT_STATUS=? and CLIENT_TYPE=?", new Object[]{newClientStatus, days, adminId, oldClientStatus, clientType});
    }
}

