/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.FunDao;
import com.coyousoft.tugui.entity.Fun;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class FunDaoImpl
implements FunDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(FunDao.class);

    @Override
    public void create(Fun fun) throws Exception {
        this.create(fun, false);
    }

    @Override
    public void create(Fun fun, boolean setId) throws Exception {
        this.dao.update("insert into FUN ( FUN_ID,CAT_ID,FUN_NAME,FUN_CLASS,USE_TYPE,USE_ROLE ) values ( ?,?,?,?,?,? )", fun.setDefault().toArray());
        if (setId) {
            fun.setFunId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<Fun> funList) throws Exception {
        if (funList == null || funList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(funList.size());
        for (Fun fun : funList) {
            params.add(fun.setDefault().toArray());
        }
        this.dao.update("insert into FUN ( FUN_ID,CAT_ID,FUN_NAME,FUN_CLASS,USE_TYPE,USE_ROLE ) values ( ?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer funId) throws Exception {
        return this.dao.update("delete from FUN where FUN_ID=?", new Object[]{funId});
    }

    @Override
    public int update(Fun fun) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update FUN set ");
        if (fun.getCatId() != null) {
            buffer.append("CAT_ID=?,");
            params.add(fun.getCatId());
        }
        if (fun.getFunName() != null) {
            buffer.append("FUN_NAME=?,");
            params.add(fun.getFunName());
        }
        if (fun.getFunClass() != null) {
            buffer.append("FUN_CLASS=?,");
            params.add(fun.getFunClass());
        }
        if (fun.getUseType() != null) {
            buffer.append("USE_TYPE=?,");
            params.add(fun.getUseType());
        }
        if (fun.getUseRole() != null) {
            buffer.append("USE_ROLE=?,");
            params.add(fun.getUseRole());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where FUN_ID = ?");
        params.add(fun.getFunId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public Fun fetch(Integer funId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from FUN where FUN_ID=?", new Object[]{funId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new Fun().fill(row);
        }
        return null;
    }

    @Override
    public List<Fun> export(int offset, int limit) throws Exception {
        ArrayList<Fun> list = new ArrayList<Fun>(limit);
        for (Map row : this.dao.queryForList("select * from FUN order by FUN_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new Fun().fill(row));
        }
        return list;
    }

    @Override
    public List<Fun> fetchList() throws Exception {
        ArrayList<Fun> list = new ArrayList<Fun>(120);
        for (Map row : this.dao.queryForList("select * from FUN order by FUN_ID asc", new Object[0])) {
            list.add(new Fun().fill(row));
        }
        return list;
    }
}

