/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.FunCatDao;
import com.coyousoft.tugui.entity.Fun;
import com.coyousoft.tugui.entity.FunCat;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class FunCatDaoImpl
implements FunCatDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(FunCatDao.class);

    @Override
    public void create(FunCat funCat) throws Exception {
        this.create(funCat, false);
    }

    @Override
    public void create(FunCat funCat, boolean setId) throws Exception {
        this.dao.update("insert into FUN_CAT ( CAT_ID,CLIENT_ID,CAT_NAME ) values ( ?,?,? )", funCat.setDefault().toArray());
        if (setId) {
            funCat.setCatId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<FunCat> funCatList) throws Exception {
        if (funCatList == null || funCatList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(funCatList.size());
        for (FunCat funCat : funCatList) {
            params.add(funCat.setDefault().toArray());
        }
        this.dao.update("insert into FUN_CAT ( CAT_ID,CLIENT_ID,CAT_NAME ) values ( ?,?,? )", params);
    }

    @Override
    public int remove(Integer catId) throws Exception {
        return this.dao.update("delete from FUN_CAT where CAT_ID=?", new Object[]{catId});
    }

    @Override
    public int update(FunCat funCat) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update FUN_CAT set ");
        if (funCat.getClientId() != null) {
            buffer.append("CLIENT_ID=?,");
            params.add(funCat.getClientId());
        }
        if (funCat.getCatName() != null) {
            buffer.append("CAT_NAME=?,");
            params.add(funCat.getCatName());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where CAT_ID = ?");
        params.add(funCat.getCatId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public FunCat fetch(Integer catId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from FUN_CAT where CAT_ID=?", new Object[]{catId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new FunCat().fill(row);
        }
        return null;
    }

    @Override
    public List<FunCat> export(int offset, int limit) throws Exception {
        ArrayList<FunCat> list = new ArrayList<FunCat>(limit);
        for (Map row : this.dao.queryForList("select * from FUN_CAT order by CAT_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new FunCat().fill(row));
        }
        return list;
    }

    @Override
    public List<FunCat> fetchList() throws Exception {
        ArrayList<FunCat> list = new ArrayList<FunCat>(36);
        HashMap<Integer, FunCat> map = new HashMap<Integer, FunCat>(36);
        FunCat cat = null;
        Fun fun = null;
        for (Map row : this.dao.queryForList("select T2.CAT_NAME,T1.* from FUN T1 inner join FUN_CAT T2 on T1.CAT_ID=T2.CAT_ID order by T2.CAT_ID asc,T1.FUN_ID asc", new Object[0])) {
            fun = new Fun().fill(row);
            fun.setFunName(URLEncoder.encode(fun.getFunName(), "UTF-8"));
            cat = (FunCat)map.get(fun.getCatId());
            if (cat == null) {
                cat = new FunCat().fill(row);
                cat.setCatName(URLEncoder.encode(cat.getCatName(), "UTF-8"));
                map.put(cat.getCatId(), cat);
                list.add(cat);
            }
            cat.add(fun);
            if (fun.getUseType() == 1) {
                fun.setUseRole(1);
                continue;
            }
            fun.setUseRole(0);
        }
        return list;
    }
}

