/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.EmailDao;
import com.coyousoft.tugui.entity.Email;
import com.coyousoft.tugui.entity.LeimailUser;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class EmailDaoImpl
implements EmailDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(EmailDao.class);

    @Override
    public void create(Email email) throws Exception {
        this.create(email, false);
    }

    @Override
    public void create(Email email, boolean setId) throws Exception {
        this.dao.update("insert into EMAIL ( EMAIL_ID,EMAIL_TITLE,CLIENT_EMAIL_ID,CLIENT_ID,VERIFY_USER_ID,SENDED_NUM,SENDED_DATE,EMAIL_CDATE,REPORT_DATE,REPORT_NUM,EMAIL_STATUS,VERIFY_DATE ) values ( ?,?,?,?,?,?,?,?,?,?,?,? )", email.setDefault().toArray());
        if (setId) {
            email.setEmailId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<Email> emailList) throws Exception {
        if (emailList == null || emailList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(emailList.size());
        for (Email email : emailList) {
            params.add(email.setDefault().toArray());
        }
        this.dao.update("insert into EMAIL ( EMAIL_ID,EMAIL_TITLE,CLIENT_EMAIL_ID,CLIENT_ID,VERIFY_USER_ID,SENDED_NUM,SENDED_DATE,EMAIL_CDATE,REPORT_DATE,REPORT_NUM,EMAIL_STATUS,VERIFY_DATE ) values ( ?,?,?,?,?,?,?,?,?,?,?,? )", params);
    }

    @Override
    public int remove(Integer emailId) throws Exception {
        return this.dao.update("delete from EMAIL where EMAIL_ID=?", new Object[]{emailId});
    }

    @Override
    public int update(Email email) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update EMAIL set ");
        if (email.getEmailTitle() != null) {
            buffer.append("EMAIL_TITLE=?,");
            params.add(email.getEmailTitle());
        }
        if (email.getClientEmailId() != null) {
            buffer.append("CLIENT_EMAIL_ID=?,");
            params.add(email.getClientEmailId());
        }
        if (email.getClientId() != null) {
            buffer.append("CLIENT_ID=?,");
            params.add(email.getClientId());
        }
        if (email.getSendedNum() != null) {
            buffer.append("SENDED_NUM=?,");
            params.add(email.getSendedNum());
        }
        if (email.getSendedDate() != null) {
            buffer.append("SENDED_DATE=?,");
            params.add(email.getSendedDate());
        }
        if (email.getEmailCdate() != null) {
            buffer.append("EMAIL_CDATE=?,");
            params.add(email.getEmailCdate());
        }
        if (email.getReportDate() != null) {
            buffer.append("REPORT_DATE=?,");
            params.add(email.getReportDate());
        }
        if (email.getReportNum() != null) {
            buffer.append("REPORT_NUM=?,");
            params.add(email.getReportNum());
        }
        if (email.getEmailStatus() != null) {
            buffer.append("EMAIL_STATUS=?,");
            params.add(email.getEmailStatus());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where EMAIL_ID = ?");
        params.add(email.getEmailId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public Email fetch(Integer emailId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from EMAIL where EMAIL_ID=?", new Object[]{emailId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new Email().fill(row);
        }
        return null;
    }

    @Override
    public List<Email> export(int offset, int limit) throws Exception {
        ArrayList<Email> list = new ArrayList<Email>(limit);
        for (Map row : this.dao.queryForList("select * from EMAIL order by EMAIL_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new Email().fill(row));
        }
        return list;
    }

    @Override
    public int updateByClientId$ClientEmailId(Email email) throws Exception {
        String sql = "update EMAIL set EMAIL_TITLE=?,SENDED_NUM=?,SENDED_DATE=?,REPORT_DATE=?,REPORT_NUM=REPORT_NUM + 1,EMAIL_STATUS=0 where CLIENT_ID=? and CLIENT_EMAIL_ID=?";
        String title = email.getEmailTitle();
        Integer sendedNum = email.getSendedNum();
        Date sendedDate = email.getSendedDate();
        Date reportDate = new Date();
        Integer clientId = email.getClientId();
        Integer clientEmailId = email.getClientEmailId();
        return this.dao.update(sql, new Object[]{title, sendedNum, sendedDate, reportDate, clientId, clientEmailId});
    }

    @Override
    public List<Email> fetchListByStatus(Integer emailStatus) throws Exception {
        String sql = "select T1.*,T2.CLIENT_KEY,T4.USER_ID BELONG_USER_ID,T4.USER_ACCOUNT BELONG_USER_ACCOUNT,T4.USER_NICKNAME BELONG_USER_NICKNAME,T4.USER_TYPE BELONG_USER_TYPE,T4.USER_MEMO BELONG_USER_MEMO,T5.USER_ID AGENCY_USER_ID,T5.USER_ACCOUNT AGENCY_USER_ACCOUNT,T5.USER_NICKNAME AGENCY_USER_NICKNAME,T5.USER_TYPE AGENCY_USER_TYPE,T5.USER_MEMO AGENCY_USER_MEMO,T6.USER_ACCOUNT VERIFY_USER_ACCOUNT,T6.USER_NICKNAME VERIFY_USER_NICKNAME,T6.USER_TYPE VERIFY_USER_TYPE,T6.USER_MEMO VERIFY_USER_MEMO from EMAIL T1 inner join LEIMAIL_CLIENT T2 on T1.CLIENT_ID=T2.CLIENT_ID inner join USER_CLIENT T3 on T1.CLIENT_ID=T3.CLIENT_ID inner join LEIMAIL_USER T4 on T3.USER_ID=T4.USER_ID inner join LEIMAIL_USER T5 on T2.AGENCY_ID=T5.USER_ID left join LEIMAIL_USER T6 on T1.VERIFY_USER_ID=T6.USER_ID where T1.EMAIL_STATUS=? order by T1.SENDED_NUM desc limit 0,?";
        Email email = null;
        LeimailUser belongUser = null;
        LeimailUser agencyUser = null;
        LeimailUser verifyUser = null;
        ArrayList<Email> list = new ArrayList<Email>();
        for (Map row : this.dao.queryForList(sql, new Object[]{emailStatus, 10})) {
            email = new Email().fill(row);
            belongUser = new LeimailUser();
            belongUser.setUserId((Integer)row.get("BELONG_USER_ID")).setUserAccount((String)row.get("BELONG_USER_ACCOUNT")).setUserNickname((String)row.get("BELONG_USER_NICKNAME")).setUserType((Integer)row.get("BELONG_USER_TYPE")).setUserMemo((String)row.get("BELONG_USER_MEMO"));
            agencyUser = new LeimailUser();
            agencyUser.setUserId((Integer)row.get("AGENCY_USER_ID")).setUserAccount((String)row.get("AGENCY_USER_ACCOUNT")).setUserNickname((String)row.get("AGENCY_USER_NICKNAME")).setUserType((Integer)row.get("AGENCY_USER_TYPE")).setUserMemo((String)row.get("AGENCY_USER_MEMO"));
            verifyUser = new LeimailUser();
            verifyUser.setUserId((Integer)row.get("VERIFY_USER_ID")).setUserAccount((String)row.get("VERIFY_USER_ACCOUNT")).setUserNickname((String)row.get("VERIFY_USER_NICKNAME")).setUserType((Integer)row.get("VERIFY_USER_TYPE")).setUserMemo((String)row.get("VERIFY_USER_MEMO"));
            String clientKey = (String)row.get("CLIENT_KEY");
            String oemName = null;
            if (clientKey.length() == 32) {
                oemName = "\u90ae\u4fa0";
            } else if (clientKey.endsWith("020")) {
                oemName = "\u6613\u4e9a";
            }
            email.setBelongUser(belongUser).setAgencyUser(agencyUser).setLeimailUser(verifyUser).setVerifyUserId(verifyUser.getUserId()).setOemName(oemName);
            list.add(email);
        }
        return list;
    }

    @Override
    public void updateEmailStatus(Email email) throws Exception {
        String sql = "update EMAIL set EMAIL_STATUS=?,VERIFY_USER_ID=?,VERIFY_DATE=? where EMAIL_ID=?";
        Integer emailId = email.getEmailId();
        Integer emailStatus = email.getEmailStatus();
        Integer verifyUserId = email.getVerifyUserId();
        Date verifyDate = new Date();
        this.dao.update(sql, new Object[]{emailStatus, verifyUserId, verifyDate, emailId});
    }
}

