/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.ClientTypeDao;
import com.coyousoft.tugui.entity.ClientType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class ClientTypeDaoImpl
implements ClientTypeDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(ClientTypeDao.class);

    @Override
    public void create(ClientType clientType) throws Exception {
        this.create(clientType, false);
    }

    @Override
    public void create(ClientType clientType, boolean setId) throws Exception {
        this.dao.update("insert into CLIENT_TYPE ( TYPE_ID,TYPE_NAME ) values ( ?,? )", clientType.setDefault().toArray());
        if (setId) {
            clientType.setTypeId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<ClientType> clientTypeList) throws Exception {
        if (clientTypeList == null || clientTypeList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(clientTypeList.size());
        for (ClientType clientType : clientTypeList) {
            params.add(clientType.setDefault().toArray());
        }
        this.dao.update("insert into CLIENT_TYPE ( TYPE_ID,TYPE_NAME ) values ( ?,? )", params);
    }

    @Override
    public int remove(Integer typeId) throws Exception {
        return this.dao.update("delete from CLIENT_TYPE where TYPE_ID=?", new Object[]{typeId});
    }

    @Override
    public int update(ClientType clientType) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update CLIENT_TYPE set ");
        if (clientType.getTypeName() != null) {
            buffer.append("TYPE_NAME=?,");
            params.add(clientType.getTypeName());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where TYPE_ID = ?");
        params.add(clientType.getTypeId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public ClientType fetch(Integer typeId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from CLIENT_TYPE where TYPE_ID=?", new Object[]{typeId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new ClientType().fill(row);
        }
        return null;
    }

    @Override
    public List<ClientType> export(int offset, int limit) throws Exception {
        ArrayList<ClientType> list = new ArrayList<ClientType>(limit);
        for (Map row : this.dao.queryForList("select * from CLIENT_TYPE order by TYPE_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new ClientType().fill(row));
        }
        return list;
    }

    @Override
    public List<ClientType> fetchList() throws Exception {
        ArrayList<ClientType> list = new ArrayList<ClientType>(12);
        for (Map row : this.dao.queryForList("select * from CLIENT_TYPE order by TYPE_ID asc", new Object[0])) {
            list.add(new ClientType().fill(row));
        }
        return list;
    }
}

