/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.daoimpl;

import com.coyousoft.tugui.dao.ClientLogDao;
import com.coyousoft.tugui.entity.ClientLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sysolar.sun.config.AppContext;
import org.sysolar.sun.jdbc.core.JdbcOperations;

public final class ClientLogDaoImpl
implements ClientLogDao {
    private final JdbcOperations dao = AppContext.getJdbcOperations(ClientLogDao.class);

    @Override
    public void create(ClientLog clientLog) throws Exception {
        this.create(clientLog, false);
    }

    @Override
    public void create(ClientLog clientLog, boolean setId) throws Exception {
        this.dao.update("insert into CLIENT_LOG ( LOG_ID,CLIENT_ID,CLIENT_IP,LOG_CDATE ) values ( ?,?,?,? )", clientLog.setDefault().toArray());
        if (setId) {
            clientLog.setLogId(this.dao.queryForInt("select @@IDENTITY", new Object[0]));
        }
    }

    @Override
    public void create(List<ClientLog> clientLogList) throws Exception {
        if (clientLogList == null || clientLogList.size() == 0) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(clientLogList.size());
        for (ClientLog clientLog : clientLogList) {
            params.add(clientLog.setDefault().toArray());
        }
        this.dao.update("insert into CLIENT_LOG ( LOG_ID,CLIENT_ID,CLIENT_IP,LOG_CDATE ) values ( ?,?,?,? )", params);
    }

    @Override
    public int remove(Integer logId) throws Exception {
        return this.dao.update("delete from CLIENT_LOG where LOG_ID=?", new Object[]{logId});
    }

    @Override
    public int update(ClientLog clientLog) throws Exception {
        ArrayList<Object> params = new ArrayList<Object>(10);
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("update CLIENT_LOG set ");
        if (clientLog.getClientId() != null) {
            buffer.append("CLIENT_ID=?,");
            params.add(clientLog.getClientId());
        }
        if (clientLog.getClientIp() != null) {
            buffer.append("CLIENT_IP=?,");
            params.add(clientLog.getClientIp());
        }
        if (clientLog.getLogCdate() != null) {
            buffer.append("LOG_CDATE=?,");
            params.add(clientLog.getLogCdate());
        }
        buffer.deleteCharAt(buffer.length() - 1);
        buffer.append(" where LOG_ID = ?");
        params.add(clientLog.getLogId());
        return this.dao.update(buffer.toString(), params.toArray());
    }

    @Override
    public ClientLog fetch(Integer logId) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from CLIENT_LOG where LOG_ID=?", new Object[]{logId}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new ClientLog().fill(row);
        }
        return null;
    }

    @Override
    public List<ClientLog> export(int offset, int limit) throws Exception {
        ArrayList<ClientLog> list = new ArrayList<ClientLog>(limit);
        for (Map row : this.dao.queryForList("select * from CLIENT_LOG order by LOG_ID desc limit ?,?", new Object[]{offset, limit})) {
            list.add(new ClientLog().fill(row));
        }
        return list;
    }

    @Override
    public ClientLog fetchByClientIp(Integer clientId, String clientIp, Date date) throws Exception {
        Iterator iterator = this.dao.queryForList("select * from CLIENT_LOG where CLIENT_ID=? and CLIENT_IP=? and LOG_CDATE >=?", new Object[]{clientId, clientIp, date}).iterator();
        if (iterator.hasNext()) {
            Map row = (Map)iterator.next();
            return new ClientLog().fill(row);
        }
        return null;
    }
}

