/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.action;

import com.coyousoft.tugui.constant.Logic;
import com.coyousoft.tugui.entity.LeimailClient;
import com.coyousoft.tugui.entity.LeimailUser;
import com.coyousoft.tugui.entity.OpenLog;
import com.coyousoft.tugui.entity.TinyUrl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.BaseAction;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.sun.mvc.support.RequestWrapper;

public class TinyUrlAction
extends BaseAction {
    public ActionForward execute(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper, String dispatch) throws Exception {
        if (dispatch == null) {
            return this.fetchStatList(request, response, session, wrapper);
        }
        if ("create".equals(dispatch)) {
            return this.create(request, response, session, wrapper);
        }
        if ("jsonCreate".equals(dispatch)) {
            return this.jsonCreate(request, response, session, wrapper);
        }
        if ("remove".equals(dispatch)) {
            return this.remove(request, response, session, wrapper);
        }
        if ("update".equals(dispatch)) {
            return this.update(request, response, session, wrapper);
        }
        if ("fetch".equals(dispatch)) {
            return this.fetch(request, response, session, wrapper);
        }
        if ("export".equals(dispatch)) {
            return this.export(request, response, session, wrapper);
        }
        return null;
    }

    private ActionForward create(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Logic.tinyUrlLogic.create(new TinyUrl().fill(wrapper));
        return new ActionForward(1, 1);
    }

    private ActionForward jsonCreate(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Object jsonData = Json.toJavaObject((String)wrapper.getString("jsonData"));
        if (jsonData instanceof Map) {
            Logic.tinyUrlLogic.create(new TinyUrl().fillJson((Map)jsonData));
        } else {
            List list = (List)jsonData;
            ArrayList<TinyUrl> tinyUrlList = new ArrayList<TinyUrl>(list.size());
            for (Object obj : list) {
                tinyUrlList.add(new TinyUrl().fillJson((Map)obj));
            }
            Logic.tinyUrlLogic.create(tinyUrlList);
        }
        return new ActionForward(1, 1);
    }

    private ActionForward remove(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.tinyUrlLogic.remove(wrapper.getInteger("urlId"));
        return new ActionForward(resp, 1);
    }

    private ActionForward update(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        LeimailUser user = (LeimailUser)session.getAttribute("KEY_USER");
        if (user != null) {
            List<TinyUrl> urlList;
            TinyUrl tinyUrl = new TinyUrl().fill(wrapper);
            if (tinyUrl.getUserId().equals(user.getUserId())) {
                Logic.tinyUrlLogic.update(tinyUrl);
            }
            if ((urlList = Logic.tinyUrlLogic.fetchListByUserId(user.getUserId())).size() > 0) {
                user.setTinyUrlList(urlList);
            } else {
                user.setTinyUrlList(null);
            }
            Integer userType = user.getUserType();
            if (userType.equals(0)) {
                Integer userId = user.getUserId();
                List<LeimailClient> clientList = Logic.leimailClientLogic.fetchListByUserId(userId);
                request.setAttribute("clientList", clientList);
                return new ActionForward("/jsp/normal.jsp", 2);
            }
            if (userType >= 100 && userType < 1000) {
                return new ActionForward("/jsp/agency.jsp", 2);
            }
            if (userType.equals(1000)) {
                return new ActionForward("/jsp/super.jsp", 2);
            }
        }
        return new ActionForward("/login.jsp", 2);
    }

    private ActionForward fetch(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        TinyUrl tinyUrl = Logic.tinyUrlLogic.fetch(wrapper.getInteger("urlId"));
        String resp = Json.toJs((String)"urlId", (Object)tinyUrl);
        return new ActionForward(resp, 1);
    }

    private ActionForward export(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        List<TinyUrl> tinyUrlList = Logic.tinyUrlLogic.export(wrapper.getInteger("offset"), wrapper.getInteger("limit"));
        String resp = Json.toJs((String)"tinyUrlList", tinyUrlList);
        return new ActionForward(resp, 1);
    }

    private ActionForward fetchStatList(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        String urlTag = wrapper.getString("urlTag");
        if (urlTag == null || "".equals(urlTag.trim())) {
            return new ActionForward("contact admin please ^_^ ", 1);
        }
        List<TinyUrl> tinyUrlList = Logic.tinyUrlLogic.fetchStatList(9, urlTag);
        List<OpenLog> openLogList = null;
        for (TinyUrl tinyUrl : tinyUrlList) {
            if (openLogList == null) {
                openLogList = tinyUrl.getOpenLogList();
                continue;
            }
            if (openLogList.size() >= tinyUrl.getOpenLogList().size()) continue;
            openLogList = tinyUrl.getOpenLogList();
        }
        request.setAttribute("openLogList", openLogList);
        request.setAttribute("tinyUrlList", tinyUrlList);
        return new ActionForward("/stat.jsp", 2);
    }
}

