/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.tugui.action;

import com.coyousoft.tugui.constant.Logic;
import com.coyousoft.tugui.entity.LeimailClient;
import com.coyousoft.tugui.entity.LeimailUser;
import com.coyousoft.tugui.entity.TinyUrl;
import com.coyousoft.tugui.entity.UserClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.sysolar.sun.mvc.core.ActionForward;
import org.sysolar.sun.mvc.core.TransAction;
import org.sysolar.sun.mvc.support.Json;
import org.sysolar.sun.mvc.support.RequestWrapper;

public class LeimailUserAction
extends TransAction {
    private static String regExp = "\\w+[\\.\\w]*@\\w+[\\w\\.]*\\.\\w{2,}";
    private static Pattern pUserAccount = Pattern.compile(regExp);

    public ActionForward execute(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper, String dispatch) throws Exception {
        if ("create".equals(dispatch)) {
            return this.create(request, response, session, wrapper);
        }
        if ("bind".equals(dispatch)) {
            return this.bind(request, response, session, wrapper);
        }
        if ("jsonCreate".equals(dispatch)) {
            return this.jsonCreate(request, response, session, wrapper);
        }
        if ("remove".equals(dispatch)) {
            return this.remove(request, response, session, wrapper);
        }
        if ("update".equals(dispatch)) {
            return this.update(request, response, session, wrapper);
        }
        if ("fetch".equals(dispatch)) {
            return this.fetch(request, response, session, wrapper);
        }
        if ("export".equals(dispatch)) {
            return this.export(request, response, session, wrapper);
        }
        if ("login".equals(dispatch)) {
            return this.login(request, response, session, wrapper);
        }
        if ("logout".equals(dispatch)) {
            return this.logout(request, response, session, wrapper);
        }
        if ("setAgency".equals(dispatch)) {
            return this.setAgency(request, response, session, wrapper);
        }
        if ("showPwd".equals(dispatch)) {
            return this.showPwd(request, response, session, wrapper);
        }
        return null;
    }

    private ActionForward setAgency(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        LeimailUser user = (LeimailUser)session.getAttribute("KEY_USER");
        if (user == null) {
            request.setAttribute("msg", (Object)"\u767b\u5f55\u5931\u8d25\u6216\u4f1a\u8bdd\u8d85\u65f6, \u8bf7\u91cd\u65b0\u767b\u5f55");
            return new ActionForward("/login.jsp", 2);
        }
        if (!user.getUserType().equals(1000)) {
            request.setAttribute("msg", (Object)"\u8eab\u4efd\u9519\u8bef, \u8bf7\u91cd\u65b0\u767b\u5f55");
            return new ActionForward("/login.jsp", 2);
        }
        LeimailUser agency = new LeimailUser().fill(wrapper);
        int num = Logic.leimailUserLogic.setAgency(agency);
        if (num == 0) {
            request.setAttribute("msg", (Object)"\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
            return new ActionForward("/jsp/super.jsp", 2);
        }
        request.setAttribute("msg", (Object)("\u628a " + agency.getUserAccount() + " \u8bbe\u7f6e\u4e3a\u4ee3\u7406\u7ba1\u7406\u5458\u6210\u529f!"));
        return new ActionForward("/jsp/super.jsp", 2);
    }

    private ActionForward showPwd(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        LeimailUser user = (LeimailUser)session.getAttribute("KEY_USER");
        if (user == null) {
            request.setAttribute("msg", (Object)"\u767b\u5f55\u5931\u8d25\u6216\u4f1a\u8bdd\u8d85\u65f6, \u8bf7\u91cd\u65b0\u767b\u5f55");
            return new ActionForward("/login.jsp", 2);
        }
        if (user.getUserType() < 100) {
            request.setAttribute("msg", (Object)"\u8eab\u4efd\u9519\u8bef, \u8bf7\u91cd\u65b0\u767b\u5f55");
            return new ActionForward("/login.jsp", 2);
        }
        request.setAttribute("msg", (Object)wrapper.getString("userAccount"));
        LeimailUser targetUser = Logic.leimailUserLogic.fetchByAccount(wrapper.getString("userAccount"), user);
        if (targetUser == null) {
            request.setAttribute("pwd", (Object)"\u5931\u8d25,\u6ca1\u6709\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e");
        } else {
            request.setAttribute("pwd", (Object)targetUser.getUserPassword());
            request.setAttribute("targetUser", (Object)targetUser);
        }
        if (user.getUserType() >= 100 && user.getUserType() < 1000) {
            return new ActionForward("/jsp/agency.jsp", 2);
        }
        if (user.getUserType().equals(1000)) {
            return new ActionForward("/jsp/super.jsp", 2);
        }
        request.setAttribute("msg", (Object)"\u767b\u5f55\u5931\u8d25\u6216\u4f1a\u8bdd\u8d85\u65f6, \u8bf7\u91cd\u65b0\u767b\u5f55");
        return new ActionForward("/login.jsp", 2);
    }

    private ActionForward logout(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) {
        session.removeAttribute("KEY_USER");
        return new ActionForward("/login.jsp", 2);
    }

    private ActionForward login(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        LeimailUser user = (LeimailUser)session.getAttribute("KEY_USER");
        if (user != null) {
            List<TinyUrl> urlList = Logic.tinyUrlLogic.fetchListByUserId(user.getUserId());
            if (urlList.size() > 0) {
                user.setTinyUrlList(urlList);
            } else {
                user.setTinyUrlList(null);
            }
            Integer userType = user.getUserType();
            if (userType.equals(0)) {
                Integer userId = user.getUserId();
                List<LeimailClient> clientList = Logic.leimailClientLogic.fetchListByUserId(userId);
                request.setAttribute("clientList", clientList);
                return new ActionForward("/jsp/normal.jsp", 2);
            }
            if (userType >= 100 && userType < 1000) {
                return new ActionForward("/jsp/agency.jsp", 2);
            }
            if (userType.equals(1000)) {
                return new ActionForward("/jsp/super.jsp", 2);
            }
        } else {
            user = new LeimailUser().fill(wrapper);
            if ((user = Logic.leimailUserLogic.login(user)) != null) {
                List<TinyUrl> urlList = Logic.tinyUrlLogic.fetchListByUserId(user.getUserId());
                if (urlList.size() > 0) {
                    user.setTinyUrlList(urlList);
                } else {
                    user.setTinyUrlList(null);
                }
                session.setAttribute("KEY_USER", (Object)user);
                Integer userType = user.getUserType();
                if (userType.equals(0)) {
                    Integer userId = user.getUserId();
                    List<LeimailClient> clientList = Logic.leimailClientLogic.fetchListByUserId(userId);
                    request.setAttribute("clientList", clientList);
                    return new ActionForward("/jsp/normal.jsp", 2);
                }
                if (userType >= 100 && userType < 1000) {
                    return new ActionForward("/jsp/agency.jsp", 2);
                }
                if (userType.equals(1000)) {
                    return new ActionForward("/jsp/super.jsp", 2);
                }
            }
        }
        request.setAttribute("msg", (Object)"\u767b\u5f55\u5931\u8d25\u6216\u4f1a\u8bdd\u8d85\u65f6, \u8bf7\u91cd\u65b0\u767b\u5f55");
        return new ActionForward("/login.jsp", 2);
    }

    private ActionForward create(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        LeimailClient client = (LeimailClient)session.getAttribute("client");
        if (client == null) {
            return new ActionForward("0", 1);
        }
        LeimailUser user = new LeimailUser().fill(wrapper);
        if (user.getUserAccount() == null) {
            return new ActionForward("0", 1);
        }
        user.setUserAccount(user.getUserAccount().trim());
        if (!pUserAccount.matcher(user.getUserAccount()).matches()) {
            return new ActionForward("0", 1);
        }
        UserClient userClient = new UserClient();
        userClient.setClientId(client.getClientId() - 10000).setLeimailUser(user);
        int resp = Logic.userClientLogic.create(userClient);
        return new ActionForward(resp, 1);
    }

    private ActionForward bind(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        LeimailClient client = (LeimailClient)session.getAttribute("client");
        if (client == null) {
            return new ActionForward("0", 1);
        }
        UserClient userClient = new UserClient();
        LeimailUser user = new LeimailUser().fill(wrapper);
        user.setUserAccount(user.getUserAccount().trim());
        userClient.setLeimailUser(user).setClientId(client.getClientId());
        int resp = Logic.userClientLogic.bind(userClient);
        return new ActionForward(resp, 1);
    }

    private ActionForward jsonCreate(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        Object jsonData = Json.toJavaObject((String)wrapper.getString("jsonData"));
        if (jsonData instanceof Map) {
            Logic.leimailUserLogic.create(new LeimailUser().fillJson((Map)jsonData));
        } else {
            List list = (List)jsonData;
            ArrayList<LeimailUser> leimailUserList = new ArrayList<LeimailUser>(list.size());
            for (Object obj : list) {
                leimailUserList.add(new LeimailUser().fillJson((Map)obj));
            }
            Logic.leimailUserLogic.create(leimailUserList);
        }
        return new ActionForward(1, 1);
    }

    private ActionForward remove(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.leimailUserLogic.remove(wrapper.getInteger("userId"));
        return new ActionForward(resp, 1);
    }

    private ActionForward update(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        int resp = Logic.leimailUserLogic.update(new LeimailUser().fill(wrapper));
        return new ActionForward(resp, 1);
    }

    private ActionForward fetch(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        LeimailUser leimailUser = Logic.leimailUserLogic.fetch(wrapper.getInteger("userId"));
        String resp = Json.toJs((String)"userId", (Object)leimailUser);
        return new ActionForward(resp, 1);
    }

    private ActionForward export(HttpServletRequest request, HttpServletResponse response, HttpSession session, RequestWrapper wrapper) throws Exception {
        List<LeimailUser> leimailUserList = Logic.leimailUserLogic.export(wrapper.getInteger("offset"), wrapper.getInteger("limit"));
        String resp = Json.toJs((String)"leimailUserList", leimailUserList);
        return new ActionForward(resp, 1);
    }
}

