/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.httputil;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieIdentityComparator;

public class UpdateableCookieStore
implements CookieStore {
    private final List<Cookie> cookies = new ArrayList<Cookie>();
    private final Comparator<Cookie> cookieComparator = new CookieIdentityComparator();

    private int getIndexOfCookie(String cookieName) {
        int i = 0;
        while (i < this.cookies.size()) {
            Cookie c = this.cookies.get(i);
            if (c.getName().equals(cookieName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Cookie getCookie(String name) {
        int index = this.getIndexOfCookie(name);
        if (index == -1) {
            return null;
        }
        return this.cookies.get(index);
    }

    public void removeCookie(String name) {
        int index = this.getIndexOfCookie(name);
        if (index == -1) {
            return;
        }
        this.cookies.remove(index);
    }

    public synchronized void addCookie(Cookie cookie) {
        if (cookie != null) {
            Iterator<Cookie> it = this.cookies.iterator();
            while (it.hasNext()) {
                if (this.cookieComparator.compare(cookie, it.next()) != 0) continue;
                it.remove();
                break;
            }
            if (!cookie.isExpired(new Date())) {
                this.cookies.add(cookie);
            }
        }
    }

    public synchronized void addCookies(Cookie[] cookies) {
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                this.addCookie(cookies[i]);
                ++i;
            }
        }
    }

    public synchronized List<Cookie> getCookies() {
        return Collections.unmodifiableList(this.cookies);
    }

    public synchronized boolean clearExpired(Date date) {
        if (date == null) {
            return false;
        }
        boolean removed = false;
        Iterator<Cookie> it = this.cookies.iterator();
        while (it.hasNext()) {
            if (!it.next().isExpired(date)) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public String toString() {
        return this.cookies.toString();
    }

    public synchronized void clear() {
        this.cookies.clear();
    }
}

