/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.httputil;

import com.coyousoft.httputil.MySingleClientConnManager;
import com.coyousoft.httputil.UpdateableCookieStore;
import com.coyousoft.util.ImageUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.sysolar.util.Des;

public class HttpUtil {
    private static final String[] USER_AGENT_ARR = new String[]{"Mozilla/5.0 (Windows NT 5.1) AppleWebKit/536.9 (KHTML, like Gecko) Chrome/20.0.1115.1 Safari/536.9", "Mozilla/5.0 (Windows NT 5.1; rv:12.0) Gecko/20100101 Firefox/12.0", "Opera/9.27 (Windows NT 5.2; U; zh-cn)", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.2)", "Mozilla/4.0 (compatible; MSIE 8.0; Windows NT 6.0)"};
    private static ThreadLocal<DefaultHttpClient> threadData = new ThreadLocal();
    private static String[] prefixIpArr = new String[]{"58.14.", "58.16.", "58.24.", "58.30.", "58.32.", "58.66.", "58.68.", "58.82.", "58.87.", "58.99.", "58.100.", "58.116.", "58.128.", "58.144.", "58.154.", "58.192.", "58.240.", "59.32.", "59.64.", "59.80.", "59.107.", "59.108.", "59.151.", "59.155.", "59.172.", "59.191.", "59.191.", "59.192.", "60.0.", "60.55.", "60.63.", "60.160.", "60.194.", "60.200.", "60.208.", "60.232.", "60.235.", "60.245.", "60.247.", "60.252.", "60.253.", "60.255.", "61.4.", "61.4.", "61.8.", "61.28.", "61.29.", "61.45.", "61.47.", "61.48.", "61.87.", "61.128.", "61.232.", "61.236.", "61.240.", "114.28.", "114.54.", "114.60.", "114.64.", "114.68.", "114.80.", "116.1.", "116.2.", "116.4.", "116.8.", "116.13.", "116.16.", "116.52.", "116.56.", "116.58.", "116.58.", "116.60.", "116.66.", "116.69.", "116.70.", "116.76.", "116.89.", "116.90.", "116.95.", "116.112.", "116.116.", "116.128.", "116.192.", "116.193.", "116.193.", "116.194.", "116.196.", "116.198.", "116.199.", "116.199.", "116.204.", "116.207.", "116.208.", "116.212.", "116.213.", "116.213.", "116.214.", "116.214.", "116.214.", "116.215.", "116.216.", "116.224.", "116.242.", "116.244.", "116.248.", "116.252.", "116.254.", "116.255.", "117.8.", "117.21.", "117.22.", "117.24.", "117.32.", "117.40.", "117.44.", "117.48.", "117.53.", "117.53.", "117.57.", "117.58.", "117.59.", "117.60.", "117.64.", "117.72.", "117.74.", "117.74.", "117.75.", "117.76.", "117.80.", "117.100.", "117.103.", "117.103.", "117.106.", "117.112.", "117.120.", "117.120.", "117.121.", "117.121.", "117.121.", "117.122.", "117.124.", "117.128.", "118.24.", "118.64.", "118.66.", "118.67.", "118.72.", "118.80.", "118.84.", "118.88.", "118.88.", "118.88.", "118.89.", "118.91.", "118.102.", "118.112.", "118.120.", "118.124.", "118.126.", "118.132.", "118.144.", "118.178.", "118.180.", "118.184.", "118.192.", "118.212.", "118.224.", "118.228.", "118.230.", "118.239.", "118.242.", "118.244.", "118.248.", "119.0.", "119.2.", "119.2.", "119.3.", "119.4.", "119.8.", "119.10.", "119.15.", "119.16.", "119.18.", "119.18.", "119.18.", "119.19.", "119.20.", "119.27.", "119.27.", "119.27.", "119.28.", "119.30.", "119.31.", "119.32.", "119.40.", "119.40.", "119.40.", "119.41.", "119.42.", "119.42.", "119.42.", "119.44.", "119.48.", "119.57.", "119.58.", "119.59.", "119.60.", "119.62.", "119.63.", "119.75.", "119.78.", "119.80.", "119.84.", "119.88.", "119.96.", "119.108.", "119.112.", "119.128.", "119.144.", "119.148.", "119.161.", "119.162.", "119.164.", "119.176.", "119.232.", "119.235.", "119.248.", "119.253.", "119.254.", "120.0.", "120.24.", "120.30.", "120.32.", "120.48.", "120.52.", "120.64.", "120.72.", "120.72.", "120.76.", "120.80.", "120.90.", "120.92.", "120.94.", "120.128.", "120.136.", "120.137.", "120.192.", "121.0.", "121.4.", "121.8.", "121.16.", "121.32.", "121.40.", "121.46.", "121.48.", "121.51.", "121.52.", "121.52.", "121.52.", "121.55.", "121.56.", "121.58.", "121.58.", "121.59.", "121.60.", "121.68.", "121.76.", "121.79.", "121.89.", "121.100.", "121.101.", "121.192.", "121.201.", "121.204.", "121.224.", "121.248.", "121.255.", "122.0.", "122.0.", "122.4.", "122.8.", "122.48.", "122.49.", "122.51.", "122.64.", "122.96.", "122.102.", "122.102.", "122.112.", "122.119.", "122.136.", "122.144.", "122.152.", "122.156.", "122.192.", "122.198.", "122.200.", "122.204.", "122.224.", "122.240.", "122.248.", "123.0.", "123.4.", "123.8.", "123.49.", "123.52.", "123.56.", "123.64.", "123.96.", "123.98.", "123.99.", "123.100.", "123.101.", "123.103.", "123.108.", "123.108.", "123.112.", "123.128.", "123.136.", "123.137.", "123.138.", "123.144.", "123.160.", "123.176.", "123.177.", "123.178.", "123.180.", "123.184.", "123.196.", "123.199.", "123.206.", "123.232.", "123.242.", "123.244.", "123.249.", "123.253.", "124.6.", "124.14.", "124.16.", "124.20.", "124.28.", "124.29.", "124.31.", "124.40.", "124.40.", "124.42.", "124.47.", "124.64.", "124.66.", "124.67.", "124.68.", "124.72.", "124.88.", "124.108.", "124.108.", "124.112.", "124.126.", "124.128.", "124.147.", "124.156.", "124.160.", "124.172.", "124.192.", "124.196.", "124.200.", "124.220.", "124.224.", "124.240.", "124.240.", "124.242.", "124.243.", "124.248.", "124.249.", "124.250.", "124.254.", "125.31.", "125.32.", "125.58.", "125.61.", "125.62.", "125.64.", "125.96.", "125.98.", "125.104.", "125.112.", "125.169.", "125.171.", "125.208.", "125.210.", "125.213.", "125.214.", "125.215.", "125.216.", "125.254.", "134.196.", "159.226.", "161.207.", "162.105.", "166.111.", "167.139.", "168.160.", "169.211.", "192.83.", "192.83.", "192.124.", "192.188.", "198.17.", "202.0.", "202.0.", "202.4.", "202.4.", "202.8.", "202.10.", "202.14.", "202.14.", "202.14.", "202.14.", "202.20.", "202.22.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.38.", "202.41.", "202.41.", "202.43.", "202.46.", "202.46.", "202.60.", "202.63.", "202.69.", "202.69.", "202.70.", "202.74.", "202.75.", "202.85.", "202.90.", "202.90.", "202.90.", "202.91.", "202.91.", "202.91.", "202.91.", "202.92.", "202.92.", "202.93.", "202.93.", "202.95.", "202.95.", "202.96.", "202.112.", "202.120.", "202.122.", "202.122.", "202.122.", "202.122.", "202.122.", "202.123.", "202.124.", "202.125.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.127.", "202.130.", "202.130.", "202.131.", "202.131.", "202.131.", "202.136.", "202.136.", "202.136.", "202.141.", "202.142.", "202.143.", "202.148.", "202.149.", "202.149.", "202.150.", "202.152.", "202.153.", "202.158.", "202.160.", "202.164.", "202.164.", "202.165.", "202.165.", "202.165.", "202.168.", "202.170.", "202.170.", "202.173.", "202.173.", "202.179.", "202.180.", "202.181.", "202.189.", "202.192.", "203.18.", "203.79.", "203.80.", "203.81.", "203.83.", "203.86.", "203.86.", "203.88.", "203.88.", "203.89.", "203.90.", "203.90.", "203.90.", "203.91.", "203.91.", "203.91.", "203.92.", "203.92.", "203.93.", "203.94.", "203.95.", "203.95.", "203.99.", "203.99.", "203.100.", "203.100.", "203.100.", "203.100.", "203.110.", "203.118.", "203.119.", "203.119.", "203.128.", "203.128.", "203.130.", "203.132.", "203.134.", "203.135.", "203.135.", "203.142.", "203.148.", "203.152.", "203.156.", "203.158.", "203.161.", "203.166.", "203.171.", "203.174.", "203.174.", "203.175.", "203.175.", "203.176.", "203.184.", "203.187.", "203.190.", "203.191.", "203.191.", "203.191.", "203.192.", "203.196.", "203.207.", "203.207.", "203.208.", "203.208.", "203.208.", "203.209.", "203.212.", "203.212.", "203.222.", "203.223.", "210.2.", "210.5.", "210.5.", "210.12.", "210.14.", "210.14.", "210.14.", "210.15.", "210.15.", "210.16.", "210.21.", "210.22.", "210.23.", "210.25.", "210.26.", "210.28.", "210.32.", "210.51.", "210.52.", "210.56.", "210.72.", "210.76.", "210.78.", "210.79.", "210.79.", "210.82.", "210.87.", "210.185.", "210.192.", "211.64.", "211.80.", "211.96.", "211.136.", "211.144.", "211.160.", "218.0.", "218.56.", "218.64.", "218.96.", "218.104.", "218.108.", "218.185.", "218.192.", "218.240.", "218.249.", "219.72.", "219.82.", "219.128.", "219.216.", "219.224.", "219.242.", "219.244.", "220.101.", "220.112.", "220.152.", "220.154.", "220.160.", "220.192.", "220.231.", "220.231.", "220.232.", "220.234.", "220.242.", "220.248.", "220.252.", "221.0.", "221.8.", "221.12.", "221.12.", "221.13.", "221.14.", "221.122.", "221.129.", "221.130.", "221.133.", "221.136.", "221.172.", "221.176.", "221.192.", "221.196.", "221.198.", "221.199.", "221.199.", "221.199.", "221.199.", "221.200.", "221.208.", "221.224.", "222.16.", "222.32.", "222.64.", "222.125.", "222.126.", "222.128.", "222.160.", "222.168.", "222.176.", "222.192.", "222.240.", "222.248."};

    public static byte[] readResp(HttpResponse resp) throws IllegalStateException, IOException {
        return HttpUtil.readResp(resp, true);
    }

    public static byte[] readResp(HttpResponse resp, boolean isCloseStream) throws IllegalStateException, IOException {
        String contentEncoding = "";
        InputStream in = null;
        try {
            int len;
            Header[] headerArray = resp.getHeaders("Content-Encoding");
            int n = headerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Header header = headerArray[n2];
                contentEncoding = header.getValue();
                ++n2;
            }
            in = "gzip".equalsIgnoreCase(contentEncoding) ? new GZIPInputStream(resp.getEntity().getContent()) : resp.getEntity().getContent();
            byte[] tempBuffer = new byte[8192];
            byte[] lastBuffer = null;
            byte[] resultBuffer = null;
            while (-1 != (len = in.read(tempBuffer))) {
                if (resultBuffer == null) {
                    resultBuffer = new byte[len];
                    System.arraycopy(tempBuffer, 0, resultBuffer, 0, len);
                    continue;
                }
                lastBuffer = resultBuffer;
                resultBuffer = new byte[resultBuffer.length + len];
                System.arraycopy(lastBuffer, 0, resultBuffer, 0, lastBuffer.length);
                System.arraycopy(tempBuffer, 0, resultBuffer, lastBuffer.length, len);
            }
            if (resultBuffer == null) {
                resultBuffer = new byte[]{};
            }
            byte[] byArray = resultBuffer;
            return byArray;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            resp.getEntity().consumeContent();
            if (isCloseStream && in != null) {
                in.close();
            }
        }
    }

    public static String getContent(HttpClient client, HttpUriRequest request, String encode) throws Exception {
        return HttpUtil.getContent(client, request, encode, true);
    }

    public static String getContent(HttpClient client, HttpUriRequest request, String encode, boolean isCloseStream) throws Exception {
        HttpResponse resp = HttpUtil.doRequest(client, request);
        byte[] bytes = HttpUtil.readResp(resp, isCloseStream);
        return new String(bytes, encode);
    }

    public static HttpResponse doRequest(HttpClient client, HttpUriRequest request) throws Exception {
        HttpProtocolParams.setUseExpectContinue((HttpParams)request.getParams(), (boolean)false);
        HttpResponse resp = null;
        try {
            request.setHeader("Connection", "Keep-Alive");
            resp = client.execute(request);
            return resp;
        }
        catch (IOException e) {
            try {
                request.abort();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resp != null) {
                resp.getEntity().getContent().close();
            }
            throw e;
        }
        catch (Exception e) {
            if (resp != null) {
                resp.getEntity().getContent().close();
            }
            throw e;
        }
    }

    public static String getRandomIp() {
        Random r = new Random();
        int ip1 = r.nextInt(200) + 1;
        while (ip1 == 10 || ip1 == 127 || ip1 == 192 || ip1 == 172 || ip1 == 169) {
            ip1 = r.nextInt(200) + 1;
        }
        int ip2 = r.nextInt(253) + 1;
        int ip3 = r.nextInt(253) + 1;
        int ip4 = r.nextInt(253) + 1;
        String ip = String.valueOf(ip1) + "." + ip2 + "." + ip3 + "." + ip4;
        return ip;
    }

    public static String getNearIp() {
        Random r = new Random();
        int ip3 = r.nextInt(253) + 1;
        int ip4 = r.nextInt(253) + 1;
        String prefixIp = "";
        String localIp = null;
        try {
            localIp = HttpUtil.getIp();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (localIp == null) {
            prefixIp = prefixIpArr[r.nextInt(prefixIpArr.length)];
        } else {
            String[] subIpArr = localIp.split("\\.");
            prefixIp = String.valueOf(subIpArr[0]) + "." + subIpArr[1] + ".";
        }
        return String.valueOf(prefixIp) + ip3 + "." + ip4;
    }

    private static boolean isInnerIP(long a_ip) {
        return a_ip >> 24 == 10L || a_ip >> 16 == 49320L || a_ip >> 22 == 688L;
    }

    private static long ipToLong(String strIP) {
        long[] ip = new long[4];
        int position1 = strIP.indexOf(".");
        int position2 = strIP.indexOf(".", position1 + 1);
        int position3 = strIP.indexOf(".", position2 + 1);
        ip[0] = Long.parseLong(strIP.substring(0, position1));
        ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
        ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
        ip[3] = Long.parseLong(strIP.substring(position3 + 1));
        return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
    }

    private static String getIp() throws UnknownHostException {
        String ip = null;
        InetAddress in = InetAddress.getLocalHost();
        InetAddress[] all = InetAddress.getAllByName(in.getHostName());
        int i = 0;
        while (i < all.length) {
            String tmp = null;
            tmp = ip = all[i].getHostAddress().toString();
            if (!ip.startsWith("169.254") && ip.indexOf(":") == -1 && !HttpUtil.isInnerIP(HttpUtil.ipToLong(tmp))) {
                return ip;
            }
            ++i;
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(HttpUtil.getRandomIp());
    }

    public static void printCookie(DefaultHttpClient client) {
        CookieStore cs = client.getCookieStore();
        for (Cookie c : cs.getCookies()) {
            System.out.println("Comment:" + c.getComment());
            System.out.println("CommentURL:" + c.getCommentURL());
            System.out.println("Domain:" + c.getDomain());
            System.out.println("Name:" + c.getName());
            System.out.println("Path:" + c.getPath());
            System.out.println("Value:" + c.getValue());
            System.out.println("Version:" + c.getVersion());
            System.out.println("ExpiryDate:" + c.getExpiryDate());
            System.out.print("Port:");
            if (c.getPorts() != null) {
                int[] nArray = c.getPorts();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int port = nArray[n2];
                    System.out.print(String.valueOf(port) + ",");
                    ++n2;
                }
            }
            System.out.println("**********************");
        }
    }

    public static void setXIp(DefaultHttpClient client, String xIp) {
        HttpParams params = client.getParams();
        List headerList = (List)params.getParameter("http.default-headers");
        headerList.add(new BasicHeader("x-forwarded-for", xIp));
    }

    public static DefaultHttpClient getClient(boolean isHttps, HttpHost proxy, Integer timeOut, boolean isNew) {
        timeOut = timeOut == null ? (timeOut = Integer.valueOf(60000)) : timeOut;
        DefaultHttpClient client = null;
        if (!isNew) {
            client = threadData.get();
        }
        BasicHttpParams params = new BasicHttpParams();
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        headers.add(new BasicHeader("User-Agent", HttpUtil.getUserAgent()));
        params.setParameter("http.default-headers", headers);
        params.setParameter("http.connection.timeout", (Object)timeOut);
        params.setParameter("http.socket.timeout", (Object)timeOut);
        params.setParameter("http.protocol.cookie-policy", (Object)"compatibility");
        if (client != null && !isNew) {
            client.setParams((HttpParams)params);
            if (isHttps) {
                try {
                    client.getConnectionManager().getSchemeRegistry().getScheme("https");
                    return client;
                }
                catch (IllegalStateException illegalStateException) {}
            } else {
                return client;
            }
        }
        SchemeRegistry sr = new SchemeRegistry();
        if (isHttps) {
            X509TrustManager easyTrustManager = new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            };
            SSLContext sslcontext = null;
            try {
                sslcontext = SSLContext.getInstance("SSL");
                sslcontext.init(null, new TrustManager[]{easyTrustManager}, null);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            SSLSocketFactory sf = new SSLSocketFactory(sslcontext);
            sf.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", (SocketFactory)sf, 443);
            sr.register(https);
        }
        sr.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        MySingleClientConnManager cm = new MySingleClientConnManager((HttpParams)params, sr);
        client = new DefaultHttpClient((ClientConnectionManager)cm, (HttpParams)params);
        client.setCookieStore((CookieStore)new UpdateableCookieStore());
        if (proxy != null) {
            client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        }
        if (!isNew) {
            threadData.set(client);
        }
        return client;
    }

    public static void setProxy(HttpClient client, HttpHost proxy) {
        client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
    }

    private static String getUserAgent() {
        Random r = new Random();
        return USER_AGENT_ARR[r.nextInt(USER_AGENT_ARR.length)];
    }

    public static DefaultHttpClient getClient(boolean isHttps) {
        return HttpUtil.getClient(isHttps, null, null, true);
    }

    public static DefaultHttpClient getClient(boolean isHttps, HttpHost proxy) {
        return HttpUtil.getClient(isHttps, proxy, null, true);
    }

    public static DefaultHttpClient getBindClient() {
        return HttpUtil.getClient(false, null, null, false);
    }

    public static void closeClient(HttpClient client) {
        if (client != null && client.getConnectionManager() != null) {
            client.getConnectionManager().shutdown();
        }
    }

    public static HttpGet getHttpGet(String url) {
        HttpGet get = new HttpGet(url);
        get.setHeader("Connection", "close");
        return get;
    }

    public static String doPost(HttpClient client, String url, Map<String, String> map, String encode, Header ... header) throws Exception {
        return HttpUtil.doPost(client, url, map, encode, true, header);
    }

    public static String doPost(HttpClient client, String url, Map<String, String> map, String encode, boolean isCloseStream, Header ... header) throws Exception {
        HttpPost post = new HttpPost(url);
        post.setHeader("Connection", "close");
        if (map != null) {
            ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>(map.size());
            Set<String> keySet = map.keySet();
            for (String key : keySet) {
                data.add(new BasicNameValuePair(key, map.get(key)));
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(data, encode));
        }
        if (header != null) {
            Header[] headerArray = header;
            int n = header.length;
            int n2 = 0;
            while (n2 < n) {
                Object h = headerArray[n2];
                post.addHeader((Header)h);
                ++n2;
            }
        }
        return HttpUtil.getContent(client, (HttpUriRequest)post, encode, isCloseStream);
    }

    public static String doPost(HttpClient client, String url, Map<String, String> map, String encode) throws Exception {
        return HttpUtil.doPost(client, url, map, encode, new Header[0]);
    }

    public static String doPost(HttpClient client, String url, Map<String, String> map, String encode, boolean isCloseStream) throws Exception {
        return HttpUtil.doPost(client, url, map, encode, isCloseStream, new Header[0]);
    }

    public static String doGet(HttpClient client, String url, String encode, Header ... header) throws Exception {
        HttpGet get = new HttpGet(url);
        get.setHeader("Connection", "close");
        if (header != null) {
            Header[] headerArray = header;
            int n = header.length;
            int n2 = 0;
            while (n2 < n) {
                Header h = headerArray[n2];
                get.addHeader(h);
                ++n2;
            }
        }
        return HttpUtil.getContent(client, (HttpUriRequest)get, encode);
    }

    public static String doGet(HttpClient client, String url, String encode) throws Exception {
        return HttpUtil.doGet(client, url, encode, new Header[0]);
    }

    public static String getLocation(HttpResponse resp, boolean consume) throws IOException {
        String location = "";
        Header[] headerArray = resp.getHeaders("Location");
        int n = headerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            location = header.getValue();
            ++n2;
        }
        if (consume) {
            resp.getEntity().consumeContent();
        }
        return location;
    }

    public static String send(String url, Map<String, String> map, String charset, boolean isEncrypt, String key) throws Exception {
        DefaultHttpClient client = HttpUtil.getBindClient();
        String content = HttpUtil.doPost((HttpClient)client, url, map, charset);
        if (isEncrypt) {
            content = Des.decrypt((String)content, (String)key);
        }
        return content;
    }

    public static byte[] getRemoteByteArr(String url, String mmName, String gift) throws Exception {
        ArrayList<BasicNameValuePair> data = new ArrayList<BasicNameValuePair>(4);
        data.add(new BasicNameValuePair("mmLove", mmName));
        data.add(new BasicNameValuePair("gift", gift));
        DefaultHttpClient client = HttpUtil.getClient(false, null, null, true);
        HttpPost post = new HttpPost(url);
        post.setEntity((HttpEntity)new UrlEncodedFormEntity(data, "UTF-8"));
        HttpResponse resp = HttpUtil.doRequest((HttpClient)client, (HttpUriRequest)post);
        byte[] b = HttpUtil.readResp(resp);
        resp.getEntity().consumeContent();
        if (b.length == 2) {
            throw new Exception(String.valueOf(new String(b)) + ".\u73cd\u60dc\u751f\u547d,\u8fdc\u79bb\u76d7\u7248!!");
        }
        String keyByteStr = Des.arrstr2string((String)gift);
        b = Des.decrypt((byte[])b, (byte[])keyByteStr.getBytes("ISO-8859-1"));
        return b;
    }

    public static Cookie getCookie(DefaultHttpClient client, String name) {
        List list = client.getCookieStore().getCookies();
        for (Cookie cookie : list) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    public static void removeXFor(DefaultHttpClient client) {
        List headerList = (List)client.getParams().getParameter("http.default-headers");
        for (BasicHeader header : headerList) {
            if (!header.getName().equals("x-forwarded-for")) continue;
            headerList.remove(header);
            break;
        }
    }

    public static void removeProxy(DefaultHttpClient client) {
        if (client == null) {
            return;
        }
        if (client.getParams() == null) {
            return;
        }
        client.getParams().removeParameter("http.route.default-proxy");
    }

    public static String getDebugCode(String imageUrl, DefaultHttpClient client) throws Exception {
        HttpGet get = new HttpGet(imageUrl);
        HttpResponse resp = HttpUtil.doRequest((HttpClient)client, (HttpUriRequest)get);
        byte[] b = HttpUtil.readResp(resp);
        resp.getEntity().consumeContent();
        ImageUtil.writeImage("D:/1.jpg", b);
        Scanner sc = new Scanner(System.in);
        String codeText = sc.next();
        return codeText;
    }

    public static String getEncryptData(HttpClient client, HttpUriRequest request, String encode, String key) throws Exception {
        String content = HttpUtil.getContent(client, request, encode);
        try {
            content = Des.decrypt((String)content, (String)key);
            content = URLDecoder.decode(content, "UTF-8");
            return content;
        }
        catch (InvalidKeyException e) {
            return content;
        }
        catch (NoSuchAlgorithmException e) {
            return content;
        }
        catch (InvalidKeySpecException e) {
            return content;
        }
        catch (NoSuchPaddingException e) {
            return content;
        }
        catch (IllegalBlockSizeException e) {
            return content;
        }
        catch (BadPaddingException e) {
            return content;
        }
    }
}

