/*
 * Decompiled with CFR 0.152.
 */
package com.coyousoft.httputil;

import com.coyousoft.httputil.HttpUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public final class HtmlReader {
    private static final Log log = LogFactory.getLog(HtmlReader.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    public static final int TIME_OUT = 30000;
    public static final String DEFAULT_CHARSET = "GB18030";
    private static final Pattern P_HEAD = Pattern.compile("<head[\\s>]+.+</head>", 2);
    private static final Pattern P_CHARSET;

    static {
        String s = "<meta [^<]*charset\\s*=\\s*[\"']?([\\w\\-]+)[\"']?\\s*[^<]*/?>";
        P_CHARSET = Pattern.compile(s, 2);
    }

    public static byte[] findHead(String url, Integer timeOut) throws Exception {
        byte[] result = new byte[]{};
        InputStream in = null;
        HttpEntity httpEntity = null;
        try {
            if (timeOut == null) {
                timeOut = 30000;
            }
            DefaultHttpClient client = new DefaultHttpClient();
            client.getParams().setParameter("http.connection.timeout", (Object)timeOut);
            client.getParams().setParameter("http.socket.timeout", (Object)timeOut);
            HttpGet request = new HttpGet(HtmlReader.appendSlash(url));
            HttpResponse response = HttpUtil.doRequest((HttpClient)client, (HttpUriRequest)request);
            httpEntity = response.getEntity();
            if (httpEntity == null) {
                return null;
            }
            in = new BufferedInputStream(httpEntity.getContent());
            byte[] buffer = new byte[1024];
            int len = -1;
            while ((len = in.read(buffer)) != -1) {
                String s;
                Matcher m;
                byte[] temp = new byte[result.length + len];
                System.arraycopy(result, 0, temp, 0, result.length);
                System.arraycopy(buffer, 0, temp, result.length, len);
                result = temp;
                if (DEBUG) {
                    log.debug(String.format("len=%d, result.length=%d", len, result.length));
                }
                if (result.length > 10240) {
                } else if (result.length <= 1024 || !(m = P_HEAD.matcher(s = new String(result).replaceAll("\\s+", " "))).find()) continue;
                break;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (httpEntity != null) {
                try {
                    httpEntity.consumeContent();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    private static String appendSlash(String url) {
        if (url.lastIndexOf(47) == url.indexOf(47) + 1) {
            url = String.valueOf(url) + "/";
        }
        return url;
    }

    private static String findCharset(byte[] head) {
        String headString = new String(head).replaceAll("\\s+", " ");
        Matcher m = P_CHARSET.matcher(headString);
        if (m.find()) {
            return m.group(1);
        }
        return DEFAULT_CHARSET;
    }

    public static String findCharset(String url, Integer timeOut) {
        try {
            return HtmlReader.findCharset(HtmlReader.findHead(url, timeOut));
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return DEFAULT_CHARSET;
        }
    }

    public static String findCharset(String url) {
        return HtmlReader.findCharset(url, null);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(HtmlReader.findCharset("http://www.hao123.com"));
    }
}

