/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.EventListener;
import javax.swing.SingleSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSingleSelectionModel
implements SingleSelectionModel,
Serializable {
    protected transient ChangeEvent changeEvent = null;
    protected EventListenerList listenerList = new EventListenerList();
    private int index = -1;

    @Override
    public int getSelectedIndex() {
        return this.index;
    }

    @Override
    public void setSelectedIndex(int n) {
        if (this.index != n) {
            this.index = n;
            this.fireStateChanged();
        }
    }

    @Override
    public void clearSelection() {
        this.setSelectedIndex(-1);
    }

    @Override
    public boolean isSelected() {
        boolean bl = false;
        if (this.getSelectedIndex() != -1) {
            bl = true;
        }
        return bl;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

