/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.util.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sysolar.util.file.FileManager;

public final class EncodingConverter {
    private static final Log log = LogFactory.getLog(EncodingConverter.class);
    private static final boolean DEBUG = log.isDebugEnabled();
    private static final String TEMP_FILE_EXTEND = ".org~sysolar~temp";

    public static boolean doBatch(File srcDir, String oldEnc, String newEnc) {
        if (srcDir == null || !srcDir.exists() || !srcDir.isDirectory()) {
            log.error((Object)("srcDir(" + srcDir + ") is invalid ! "));
            return false;
        }
        for (File file : FileManager.listDescendFiles(srcDir, null)) {
            if (EncodingConverter.doSingle(file, oldEnc, newEnc)) continue;
            log.error((Object)("failed: srcDir=" + srcDir + "; oldEnc=" + oldEnc + "; newEnc=" + newEnc));
            return false;
        }
        if (DEBUG) {
            log.debug((Object)("succeeded: srcDir=" + srcDir + "; oldEnc=" + oldEnc + "; newEnc=" + newEnc));
        }
        return true;
    }

    public static boolean doSingle(File srcFile, String oldEnc, String newEnc) {
        if (srcFile == null || !srcFile.isFile()) {
            log.error((Object)("srcFile(" + srcFile + ") is invalid !"));
            return false;
        }
        File tempFile = new File(srcFile.getParent(), String.valueOf(System.currentTimeMillis()) + TEMP_FILE_EXTEND);
        while (tempFile.exists()) {
            tempFile = new File(srcFile.getParent(), String.valueOf(System.currentTimeMillis()) + TEMP_FILE_EXTEND);
        }
        BufferedReader in = null;
        BufferedWriter out = null;
        try {
            try {
                String text;
                tempFile.createNewFile();
                in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(srcFile), oldEnc));
                out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), newEnc));
                while ((text = in.readLine()) != null) {
                    out.write(text);
                    out.newLine();
                }
                out.flush();
            }
            catch (Exception ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
                if (tempFile.exists()) {
                    tempFile.delete();
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        srcFile.delete();
        tempFile.renameTo(srcFile);
        if (DEBUG) {
            log.debug((Object)("succeeded: srcFile=" + srcFile));
        }
        return true;
    }

    public static void main(String[] args) {
    }
}

