/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessMonitor
extends Thread {
    protected static final Log l = LogFactory.getLog(ProcessMonitor.class);
    private String type = null;
    private Process p = null;
    private Map<String, Boolean> processStatusMap = null;

    ProcessMonitor(Process p, String type, Map<String, Boolean> processStatusMap) {
        this.p = p;
        this.type = type;
        this.processStatusMap = processStatusMap;
    }

    @Override
    public void run() {
        block35: {
            InputStream is = null;
            is = this.type.equals("ERROR") ? this.p.getErrorStream() : this.p.getInputStream();
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                try {
                    isr = new InputStreamReader(is, "GBK");
                    br = new BufferedReader(isr);
                    String line = br.readLine();
                    while (line != null) {
                        line = br.readLine();
                        if (line == null) continue;
                        l.info((Object)(String.valueOf(this.type) + ">" + line));
                        System.out.println(String.valueOf(this.type) + ">" + line);
                    }
                    this.processStatusMap.put(this.type, true);
                }
                catch (IOException ioe) {
                    Boolean errorStatus;
                    ioe.printStackTrace();
                    Boolean infoStatus = this.processStatusMap.get("INFO");
                    if (infoStatus == null) {
                        infoStatus = false;
                    }
                    if ((errorStatus = this.processStatusMap.get("ERROR")) == null) {
                        errorStatus = false;
                    }
                    if (!infoStatus.booleanValue() || !errorStatus.booleanValue()) break block35;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println(String.valueOf(this.type) + ">" + "\u9500\u6bc1\u8fdb\u7a0b");
                    this.p.destroy();
                }
            }
            finally {
                Boolean errorStatus;
                Boolean infoStatus = this.processStatusMap.get("INFO");
                if (infoStatus == null) {
                    infoStatus = false;
                }
                if ((errorStatus = this.processStatusMap.get("ERROR")) == null) {
                    errorStatus = false;
                }
                if (infoStatus.booleanValue() && errorStatus.booleanValue()) {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (isr != null) {
                        try {
                            isr.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    System.out.println(String.valueOf(this.type) + ">" + "\u9500\u6bc1\u8fdb\u7a0b");
                    this.p.destroy();
                }
            }
        }
    }
}

