/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.threadpool;

import java.util.Date;
import org.apache.log4j.Logger;
import org.sysolar.threadpool.Task;
import org.sysolar.threadpool.TaskQueue;

public class WorkerThread
extends Thread {
    protected static final Logger l = Logger.getLogger(WorkerThread.class);
    private boolean busy = false;
    private boolean stop = false;
    private TaskQueue queue = null;
    private Task task;

    public WorkerThread(TaskQueue queue) {
        this.queue = queue;
    }

    public void shutdown() {
        this.stop = true;
        this.interrupt();
    }

    public boolean isIdle() {
        return !this.busy;
    }

    @Override
    public void run() {
        while (!this.stop) {
            this.task = this.queue.getTask();
            if (this.task == null) continue;
            this.busy = true;
            try {
                this.task.setBeginRunTime(new Date());
                this.task.execute();
            }
            catch (Exception e) {
                l.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
            this.busy = false;
        }
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public Task getTask() {
        return this.task;
    }
}

