/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.threadpool;

import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;
import org.sysolar.threadpool.ThreadPool;

public abstract class Task {
    protected Logger log = Logger.getLogger(this.getClass());
    protected ThreadPool pool = null;
    protected long lastStartTime = System.currentTimeMillis();
    protected Integer point = null;
    protected int cycle = 0;
    private String taskName = null;
    private Date intoQueueTime = null;
    private Date beginRunTime = null;

    public abstract void execute() throws Exception;

    public abstract void work() throws Exception;

    public boolean isCycle() {
        if (this.cycle == 0) {
            return true;
        }
        int currentTime = (int)(System.currentTimeMillis() / 60000L);
        return currentTime - (int)(this.lastStartTime / 60000L) >= this.cycle;
    }

    public boolean isPoint() {
        if (this.point == null) {
            return true;
        }
        Calendar now = Calendar.getInstance();
        Integer hourOfDay = now.get(11);
        Integer minOfHour = now.get(12);
        return hourOfDay.equals(this.point) && minOfHour == 0;
    }

    public boolean isStart() {
        return this.isCycle() && this.isPoint();
    }

    public long getLastStartTime() {
        return this.lastStartTime;
    }

    public void setLastStartTime(long lastStartTime) {
        this.lastStartTime = lastStartTime;
    }

    public boolean isLast() {
        return true;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setIntoQueueTime(Date intoQueueTime) {
        this.intoQueueTime = intoQueueTime;
    }

    public Date getIntoQueueTime() {
        return this.intoQueueTime;
    }

    public void setBeginRunTime(Date beginRunTime) {
        this.beginRunTime = beginRunTime;
    }

    public Date getBeginRunTime() {
        return this.beginRunTime;
    }

    public String info() {
        return "[TaskName:" + this.taskName + "],[IntoQueue:" + this.intoQueueTime + "],[BeginRun:" + this.beginRunTime + "]";
    }
}

