/*
 * Decompiled with CFR 0.152.
 */
package org.sysolar.threadpool;

import java.net.BindException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.http.conn.ConnectTimeoutException;
import org.sysolar.threadpool.BackException;
import org.sysolar.threadpool.Task;

public abstract class NoTsTask
extends Task {
    private int backTimes = 0;
    protected boolean isBacked = false;
    protected boolean isAllowBack = true;

    @Override
    public void execute() throws Exception {
        try {
            this.work();
            this.lastStartTime = System.currentTimeMillis();
        }
        catch (ConnectTimeoutException e) {
            this.back((Exception)((Object)e));
            return;
        }
        catch (ConnectException e) {
            this.back(e);
            return;
        }
        catch (SocketTimeoutException e) {
            this.back(e);
            return;
        }
        catch (BindException e) {
            this.back(e);
            return;
        }
        catch (UnknownHostException e) {
            this.back(e);
            return;
        }
        catch (NoRouteToHostException e) {
            this.back(e);
            return;
        }
        catch (SocketException e) {
            this.back(e);
            return;
        }
        catch (BackException e) {
            this.back(e);
            return;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected void back(Exception e) throws InterruptedException {
        e.printStackTrace();
        if (this.backTimes >= this.getMaxBackTimes() || !this.isAllowBack) {
            this.drop();
            return;
        }
        if (this.pool != null) {
            this.beforeBack();
            Thread.sleep(3000L);
            this.pool.putTask(this);
            ++this.backTimes;
            this.isBacked = true;
        }
    }

    protected void drop() {
    }

    protected void beforeBack() {
    }

    protected int getMaxBackTimes() {
        return 3;
    }
}

